Program D1000;


Const Lcos : Real = 0.999847695;
      Lsin : Real = 0.017452406;


Type Dot = Record
     x,y,z : Real;
     End;

     Pdot = Record
     x,y,z : Integer;
     End;
   Virtual = array[1..64000] of byte;


Var Dots   : Array[0..999] of Dot;
    Pdots  : Array[0..999] of Pdot;
    Virscr : ^Virtual;
    Vaddr  : Word;
    Xofs,
    Yofs,
    Zofs   : Integer;
    lln:word;
    i:word;
    vola:word;
    vola2:word;
Procedure Init;


Var K : Integer;

Begin

  New(Virscr);
  Vaddr := seg(Virscr^);

  Xofs := 160;
  Yofs := 100;
  Zofs := -300;

  asm
  mov ax,13h
  int 10h
  end;

End;


{============================================================================}


Procedure SetZPal;


Var K,C : Byte;

Begin

  C := 255;
  For k:=1 to 255 do Begin
    Port[$3c8]:=c;
    Port[$3c9]:= k shr 2;
    Port[$3c9]:= k shr 2;
    Port[$3c9]:= k shr 2;
    Dec(c);
  End;

End;

{============================================================================}
Procedure RotateBox;
{Rota la Caja entera}

Var k : Integer;
    tx,ty,tz : Real;

Begin

  for k:=0 to 999 do  begin

  ty:=Lcos*Dots[k].y - Lsin*Dots[k].z;
  tz:=Lsin*Dots[k].y + Lcos*Dots[k].z;
  Dots[k].y := ty;Dots[k].z := tz;

  tx:=Lcos*Dots[k].x - Lsin*Dots[k].y;
  ty:=Lsin*Dots[k].x + Lcos*Dots[k].y;
  Dots[k].x := tx;Dots[k].y := ty;

  tx:=Lcos*Dots[k].x + Lsin*Dots[k].z;
  tz:=-Lsin*Dots[k].x + Lcos*Dots[k].z;
  Dots[k].x := tx;Dots[k].z := tz;

  Pdots[k].x := round ( (Dots[k].x * 256 ) / (Dots[k].z - zofs)+xofs);
  Pdots[k].y := round ( (Dots[k].y * 256 ) / (Dots[k].z - zofs)+yofs);
  Pdots[k].z := round (  Dots[k].z ) + 128;

  End;

End;


Procedure InitDots;


Var k,l,m : Integer;

Begin

  for k:=0 to 9 do
    for l:=0 to 9 do
      for m:=0 to 9 do
      begin
      Dots[k*100+l*10+m].x:=k * 15 - 60;
      Dots[k*100+l*10+m].y:=l * 15 - 60;
      Dots[k*100+l*10+m].z:=m * 15 - 60;
      End;

End;

{============================================================================}


Procedure RotateDots;

Var k : Integer;
    tx,ty,tz : real;

Begin

     if lln<99 then
     begin;
     lln:=lln+1;
     end;

  for k:=0 to lln do
 begin
 ty:=Lcos*Dots[k].y - Lsin*Dots[k].z;
 tz:=Lsin*Dots[k].y + Lcos*Dots[k].z;
 Dots[k].y := ty;Dots[k].z := tz;

  tx:=Lcos*Dots[k].x - Lsin*Dots[k].y;
  ty:=Lsin*Dots[k].x + Lcos*Dots[k].y;
  Dots[k].x := tx;Dots[k].y := ty;

  tx:=Lcos*Dots[k].x + Lsin*Dots[k].z;
  tz:=-Lsin*Dots[k].x + Lcos*Dots[k].z;
  Dots[k].x := tx;Dots[k].z := tz;

  Pdots[k].x := round ( (Dots[k].x * 256 ) / (Dots[k].z - zofs)+xofs);
  Pdots[k].y := round ( (Dots[k].y * 256 ) / (Dots[k].z - zofs)+yofs);
  Pdots[k].z := round (  Dots[k].z ) + 128;

end;
end;
{============================================================================}
Procedure WaitRetrace;Assembler;
{Waits for a vertical retrace}
asm mov dx,3DAh
@l1:
in al,dx
and al,08h
jnz @l1
@l2:
in al,dx
and al,08h
jz @l2
end;



Procedure DrawDots(where:word);


Var k : Integer;

Begin

  for k:=0 to lln do
    with Pdots[k] do
      if (x > -1) and (x < 320) and (y > -1) and (y < 200) then
      mem[where:x+y*320] := z;
End;

 Procedure DrawBox(where:word);


Var k : Integer;

Begin
     if lln<999  then lln:=lln+1;
  for k:=0 to lln do
    with Pdots[k] do
      if (x > -1) and (x < 320) and (y > -1) and (y < 200) then
      mem[where:x+y*320] := z;

End;
 Procedure DeDrawBox(where:word);


Var k : Integer;

Begin
     if lln>0  then lln:=lln-1;
  for k:=0 to lln do
    with Pdots[k] do
      if (x > -1) and (x < 320) and (y > -1) and (y < 200) then
      mem[where:x+y*320] := z;

End;
{============================================================================}
Procedure Flip;Assembler;
{Flips the Virtual screen to the VGA screen}
asm push ds
mov ax,$a000
mov es,ax
mov ax,vaddr
mov ds,ax
xor di,di
xor si,si
mov cx,16000
Db $66
rep movsw
pop ds
end;
{============================================================================}



{============================================================================}

{============================================================================}
{//////////////////////////////////BUCLE}
begin
    vola2:= 0 ;
    init;
    initdots;
    SetZPal ;
     for i:= 1 to 999 do
  begin;
    fillchar(mem[vaddr:0],64000,0);
    RotateBox;
    DrawBox(vaddr);
    WaitRetrace;
    Flip;
  end;
    for i:= 1 to 900 do
  begin;
  fillchar(mem[vaddr:0],64000,0);
  RotateBox;
  DeDrawBox(vaddr);
  WaitRetrace;
  Flip;
  end;
     for i:= 1 to 999 do
  begin;
  fillchar(mem[vaddr:0],64000,0);
  RotateDots;
  DrawDots(vaddr);
  WaitRetrace;
  Flip;
  end;

 asm;
 mov ax,3h
 int 10h
 end;



    end.
{MDG}



