.386                                    ;pmode/w
.model flat,prolog
locals

public copyBuffer32, copyBuffer24, copyBuffer16

include vesa.inc

Coltab32 struc
  ct_r32 dd 1024 dup(?)
  ct_g32 dd 1024 dup(?)
  ct_b32 dd 1024 dup(?)
ends

Coltab16 struc
  ct_r16 dw 1024 dup(?)
  ct_g16 dw 1024 dup(?)
  ct_b16 dw 1024 dup(?)
ends


.code

copyBuffer32 proc near
        ;-> esi -> source-screenbuffer
        ;-> ebx -> tvesa
        ;-> edx -> coltab

        push    ebp
        mov     ecx,[ebx].vesa_yres
        mov     edi,[ebx].vesa_linbuf
@@YLoop:
        push    ecx
        push    edi

        mov     ecx,[ebx].vesa_xres
        lea     esi,[esi+ecx*4]
        lea     edi,[edi+ecx*4]
        neg     ecx
        push    ebx
@@XLoop:
        mov     ebx,[esi+ecx*4]
        mov     eax,ebx
        and     eax,3FFh
        shr     ebx,11
        mov     ebp,[edx].ct_r32[eax*4]
        mov     eax,ebx
        and     eax,3FFh
        shr     ebx,11
        or      ebp,[edx].ct_g32[eax*4]
        or      ebp,[edx].ct_b32[ebx*4]
        mov     [edi+ecx*4],ebp
        inc     ecx
        jnz     @@XLoop
        pop     ebx

        pop     edi
        add     edi,[ebx].vesa_xbytes
        pop     ecx
        dec     ecx
        jnz     @@YLoop

        pop     ebp
        ret
copyBuffer32 endp

copyBuffer24 proc near
        ;-> esi -> source-screenbuffer
        ;-> ebx -> tvesa
        ;-> edx -> coltab

        push    ebp
        mov     ecx,[ebx].vesa_yres
        mov     edi,[ebx].vesa_linbuf
@@YLoop:
        push    ecx
        push    edi

        mov     ecx,[ebx].vesa_xres
        shr     ecx,2
        push    ebx
        push    ecx
@@XLoop:

                ;1.
        mov     ecx,[esi]
        mov     eax,ecx
        and     eax,3FFh
        shr     ecx,11
        mov     ebp,[edx].ct_r32[eax*4]
        mov     eax,ecx
        and     eax,3FFh
        shr     ecx,11
        or      ebp,[edx].ct_g32[eax*4]
        add     esi,4
        or      ebp,[edx].ct_b32[ecx*4]

                ;2.
      shl     ebp,8
        mov     ecx,[esi]
        mov     eax,ecx
        and     eax,3FFh
        shr     ecx,11
        mov     ebx,[edx].ct_r32[eax*4]
        mov     eax,ecx
        and     eax,3FFh
        shr     ecx,11
        or      ebx,[edx].ct_g32[eax*4]
        add     esi,4
        or      ebx,[edx].ct_b32[ecx*4]

                ;3.
      shrd    ebp,ebx,8
      mov     [edi],ebp
      add     edi,4
        mov     ecx,[esi]
        mov     eax,ecx
        and     eax,3FFh
        shr     ecx,11
        mov     ebp,[edx].ct_r32[eax*4]
        mov     eax,ecx
        and     eax,3FFh
        shr     ecx,11
        or      ebp,[edx].ct_g32[eax*4]
        add     esi,4
        or      ebp,[edx].ct_b32[ecx*4]
      shl     ebx,8

                ;4.
      shrd    ebx,ebp,16
      mov     [edi],ebx
      add     edi,4
      shl     ebp,8
        mov     ecx,[esi]
        mov     eax,ecx
        and     eax,3FFh
        shr     ecx,11
        mov     ebx,[edx].ct_r32[eax*4]
        mov     eax,ecx
        and     eax,3FFh
        shr     ecx,11
        or      ebx,[edx].ct_g32[eax*4]
        add     esi,4
        or      ebx,[edx].ct_b32[ecx*4]

      shld    ebx,ebp,8
      mov     [edi],ebx
      add     edi,4

        dec     dword ptr [esp] ;ecx
        jnz     @@XLoop
        pop     ecx

        pop     ebx
        pop     edi
        add     edi,[ebx].vesa_xbytes

        pop     ecx
        dec     ecx
        jnz     @@YLoop

        pop     ebp
        ret
copyBuffer24 endp

copyBuffer16 proc near
        ;-> esi -> source-screenbuffer
        ;-> ebx -> tvesa
        ;-> edx -> coltab

        push    ebp
        mov     ecx,[ebx].vesa_yres
        mov     edi,[ebx].vesa_linbuf
@@YLoop:
        push    ecx
        push    edi

        mov     ecx,[ebx].vesa_xres
        lea     esi,[esi+ecx*4]
        lea     edi,[edi+ecx*2]
        neg     ecx
        push    ebx
@@XLoop:
        mov     ebx,[esi+ecx*4]
        mov     eax,ebx
        and     eax,3FFh
        shr     ebx,11
        mov     bp,[edx].ct_r16[eax*2]
        mov     eax,ebx
        and     eax,3FFh
        shr     ebx,11
        or      bp,[edx].ct_g16[eax*2]
        or      bp,[edx].ct_b16[ebx*2]
        mov     [edi+ecx*2],bp
        inc     ecx
        jnz     @@XLoop
        pop     ebx

        pop     edi
        add     edi,[ebx].vesa_xbytes
        pop     ecx
        dec     ecx
        jnz     @@YLoop

        pop     ebp
        ret
copyBuffer16 endp


end