#pragma pack(1)
//#include <stdlib.h>
#include <stdio.h>


#include "remix.h"
#include "copro.h"
#include "memory.h"
#include "string.h"
#include "rxm.h"
#include "vesa.h"
#include "copy.h"
#include "poly.h"

#include "../gfx/matrming.cpp"
#include "../gfx/luxol.cpp"
#include "../gfx/luxoman.cpp"
#include "../gfx/digisnap.cpp"
#include "../gfx/nero.cpp"
#include "../gfx/muffler.cpp"

int timecount;
extern volatile int maincount;
#pragma aux maincount "*"
int mainsub;

//resolution
extern int xres;
#pragma aux xres "*"
extern int yres;

extern int endFlag;


//--- global heap
void *globalHeap;
int memInfo;

void initmem(int size) {
  globalHeap = memalloc(&memInfo, size);
}

void *getalignmem(int size, int align) {
  int p;

  size = (size +3) & ~3;

  align--;
  p = (int) globalHeap + align & ~align;

  globalHeap = (void *) (p + size);

  bzero((void *) p, size);
  return (void *) p;
}

void *getmem(int size) {
  return getalignmem(size, 4);
}

//--- player
#include "startxm.h"
extern int dflags;
extern int mixrate;
extern int mastervol;
extern int iwflag;

//--- vesa
extern unsigned int *screenBuf;
#pragma aux screenBuf "*"

tvesa vesa;


//grabber

typedef struct {
 char  ident_len;   //zahl an byte, die nach dem header zu berspringen ist
 char  cmap_type;   // = 1: palette vorhanden
 char  image_type;  //bit0 = 1: mit palette, bit1 = 1: rgb, bit3 = 1: gepackt
 short cmap_origin; //?
 short cmap_len;    //palettenlnge
 char  centry_size; //bit pro paletteneintrag
 short image_xorg;  //x - ursprung
 short image_yorg;  //y - ursprung
 short image_width; //x - auflsung
 short image_height;//y - auflsung
 char  pixel_size;  //bit pro pixel
 char  image_discr; //bit5 = 0: bild "auf dem kopf"
} theader;

void grab();
#pragma aux grab "grab"

void grab() {
  FILE *f;
  static int num = 0;
  char fname[16];
  theader header;
  char *cp;
  int x, y, i;
  char col[3];
  tvesa *aktvesa;

  aktvesa = &vesa;
  if (aktvesa->redbits != 8 || aktvesa->greenbits != 8 || aktvesa->bluebits != 8) return;

  sprintf(fname, "pic%05d.tga", num);
  num++;
  f = fopen(fname,"wb");

  header.ident_len = 0;
  header.cmap_type = 0;   // = 1: palette vorhanden
  header.image_type = 2;  //bit0 = 1: mit palette, bit1 = 1: rgb, bit3 = 1: gepackt
  header.cmap_origin = 0; //?
  header.cmap_len = 0;    //palettenlnge
  header.centry_size = 0; //bit pro paletteneintrag
  header.image_xorg = 0;  //x - ursprung
  header.image_yorg = 0;  //y - ursprung
  header.image_width = aktvesa->xres; //x - auflsung
  header.image_height = aktvesa->yres;//y - auflsung
  header.pixel_size = 24;  //bit pro pixel
  header.image_discr = 32; //bit5 = 0: bild "auf dem kopf"
  fwrite(&header,1,sizeof(theader),f);

  for (y = 0; y < aktvesa->yres; y++) {
    cp = (char *) aktvesa->linbuf + y*aktvesa->xbytes;
    for (x = 0; x < aktvesa->xres; x++) {
      i = *(int *) cp;

      col[2] = i >> aktvesa->redpos;
      col[1] = i >> aktvesa->greenpos;
      col[0] = i >> aktvesa->bluepos;
      fwrite(col,1,3,f);

      cp += aktvesa->pbytes;
    }
  }

  fclose(f);
}


//--- config file
void readline(FILE *f, char *str) {
  int c;
  int count = 0;
  int z;

  do {
    if ((c = fgetc(f)) == EOF) break;
    if (c > 32 && count < 45) {
      if (c >= 'A' && c <= 'Z') c += 32;
      str[count] = c;
      count++;
    };

  } while (c != 10);
  str[count] = '\0';
};

int hex(char *s) {
  int r = 0;

  while (*s) {
    r <<=4;
    if (*s >= '0' && *s <= '9') r += *s - '0';
    if (*s >= 'a' && *s <= 'f') r += *s - 'a' + 10;
    if (*s >= 'A' && *s <= 'F') r += *s - 'A' + 10;
    s++;
  };
  return r;
}

void readlist(char *s, char *values, int novalues) {
  int z;
  for(z = 0; z < novalues; z++) values[z] = 0;
  z = 0;
  while (*s && novalues > 0) {
    if (*s >= '0' && *s <= '9') {
      *values *= 10;
      *values += *s - '0';
    };
    if (*s == ',') {
      values++;
      novalues--;
    }
    s++;
  }
}

int atob(char *s) {
  int i;
  i = atoi(s);
  if (i) return i;
  if (*s == 'y' || *s == 'Y') return 1;
  return 0;
}

void readconfig() {
  char str[48];
  char *val;
  FILE *f;

  f = fopen("luxo.cfg","rb");
  if (!f) exits("Can't read config file (luxo.cfg)");
  while (!feof(f)) {
    readline(f,str);
    val = strchr(str,';');
    if (val) *val = '\0';
    val = strchr(str,'=');
    if (val) {
      *val = '\0';
      val++;

      //mode 1
      if (!strcmp(str,"mode")) vesa.mode = hex(val);
      if (!strcmp(str,"mode_x")) vesa.xres = atoi(val);
      if (!strcmp(str,"mode_y")) vesa.yres = atoi(val);
      if (!strcmp(str,"mode_bit")) readlist(val,vesa.bpplist,4);
      if (!strcmp(str,"mode_a")) vesa.area = atoi(val);

      //player
      if (!strcmp(str,"nosound")) if (atob(val)) dflags |= dfNosound;
//      if (!strcmp(str,"volume")) vol = atoi(val);
      if (!strcmp(str,"16bit")) if (!atob(val)) dflags &= ~df16bit;
      if (!strcmp(str,"stereo")) if (!atob(val)) dflags &= ~dfStereo;
      if (!strcmp(str,"reverse")) if (atob(val)) dflags &= ~dfReverse;
      if (!strcmp(str,"rate")) mixrate = atoi(val);
      if (!strcmp(str,"sb_dsp1")) if (atob(val)) dflags |= sb_dsp1;
      if (!strcmp(str,"sb_awe")) if (atob(val)) dflags |= sb_awe;
      if (!strcmp(str,"sb_master")) mastervol = atoi(val);
      if (!strcmp(str,"gus_iw")) iwflag = atob(val);
    }
  }
  fclose(f);
}


//--- coltabs
void *coltab;

typedef struct {
  unsigned int r[1024];
  unsigned int g[1024];
  unsigned int b[1024];
} Coltab32;

typedef struct {
  unsigned short r[1024];
  unsigned short g[1024];
  unsigned short b[1024];
} Coltab16;

void makeColtab32() {
  int z, c;
  Coltab32 *coltab32;

  coltab32 = (Coltab32 *) getmem(sizeof(Coltab32));
  for (z = 0; z < 1024; z++) {
    c = (z < 256) ? z : 255;
    coltab32->r[z] = c << vesa.redpos;
    coltab32->g[z] = c << vesa.greenpos;
    coltab32->b[z] = c << vesa.bluepos;
  }
  coltab = (void *) coltab32;
}

void makeColtab16() {
  int z, c;
  Coltab16 *coltab16;

  coltab16 = (Coltab16 *) getmem(sizeof(Coltab16));
  for (z = 0; z < 1024; z++) {
    c = (z < 256) ? z : 255;
    coltab16->r[z] = (c >> (8 - vesa.redbits)) << vesa.redpos;
    coltab16->g[z] = (c >> (8 - vesa.greenbits)) << vesa.greenpos;
    coltab16->b[z] = (c >> (8 - vesa.bluebits)) << vesa.bluepos;
  }
  coltab = (void *) coltab16;
}

//--- tracks
extern Track3 camPosTrack;
extern Track3 camTargetTrack;
extern Track3 lightTrack[numLights];

extern Key3 camPosKeys;
#pragma aux camPosKeys "*"

extern Key3 camTargetKeys;
#pragma aux camTargetKeys "*"

extern Key3 light0Keys;
#pragma aux light0Keys "*"

extern Key3 light1Keys;
#pragma aux light1Keys "*"

void initTracks() {
  initTrack3(&camPosTrack, &camPosKeys);
  initTrack3(&camTargetTrack, &camTargetKeys);
  initTrack3(&lightTrack[0], &light0Keys);
  initTrack3(&lightTrack[1], &light1Keys);
}


void copyBuffer() {
  switch (vesa.pbytes) {
    case 4:
      copyBuffer32(screenBuf, &vesa, coltab);
      break;
    case 3:
      copyBuffer24(screenBuf, &vesa, coltab);
      break;
    default:
      copyBuffer16(screenBuf, &vesa, coltab);
  }
}

//--- picture stuff
void setRect(Rectangle *r, int x, int y, int *res) {
  r->ow = res[0];
  r->oh = res[1];
  r->w = (x + res[0])*xres/320;
  r->h = (y + res[1])*yres/240;
  r->x = x*xres/320;
  r->y = y*yres/240;
  r->w -= r->x;
  r->h -= r->y;
}

void paintPic(Rectangle *r, uchar *pal, uchar *pic) {
  uint *screen;
  uchar *picl;
  int h, z, uAdd, vAdd, u, v, p;

  if (r->w == 0 || r->h == 0) return;
  screen = &screenBuf[r->x + r->w + xres*r->y];
  uAdd = (r->ow << 8)/r->w;
  vAdd = (r->oh << 8)/r->h;
  v = 0;
  h = r->h;
  do {
    picl = &pic[(v >> 8)*r->ow];
    z = -r->w;
    u = 0;
    do {
      p = picl[u >> 8]*3;
      screen[z] += pal[p +0] | pal[p +1] << 11 | pal[p +2] << 22;
      u += uAdd;
      z++;
    } while (z != 0);
    screen += xres;
    v += vAdd;
    h--;
  } while (h != 0);
}

void paintPic2(Rectangle *r, uchar *pal, uchar *pic) {
  uint *screen;
  uchar *picl;
  int h, z, uAdd, vAdd, u, v, p;

  if (r->w == 0 || r->h == 0) return;
  screen = &screenBuf[r->x + r->w + xres*r->y];
  uAdd = (r->ow << 8)/r->w;
  vAdd = (r->oh << 8)/r->h;
  v = 0;
  h = r->h;
  do {
    picl = &pic[(v >> 8)*r->ow];
    z = -r->w;
    u = 0;
    do {
      p = picl[u >> 8]*3;
      if (p != 0) screen[z] = pal[p +0] | pal[p +1] << 11 | pal[p +2] << 22;
      u += uAdd;
      z++;
    } while (z != 0);
    screen += xres;
    v += vAdd;
    h--;
  } while (h != 0);
}

void paintPic3(Rectangle *r, int x, int y, int zmul, uchar *pal, uchar *pic) {
  uint *screen;
  uchar *picl;
  int h, z, uAdd, vAdd, u, v, p;

  if (r->w == 0 || r->h == 0) return;
  pic = &pic[x + y*zmul];
  screen = &screenBuf[r->x + r->w + xres*r->y];
  uAdd = (r->ow << 8)/r->w;
  vAdd = (r->oh << 8)/r->h;
  v = 0;
  h = r->h;
  do {
    picl = &pic[(v >> 8)*zmul];
    z = -r->w;
    u = 0;
    do {
      p = picl[u >> 8]*3;
      screen[z] += pal[p +0] | pal[p +1] << 11 | pal[p +2] << 22;
      u += uAdd;
      z++;
    } while (z != 0);
    screen += xres;
    v += vAdd;
    h--;
  } while (h != 0);
}
/*
void fade(float t, Rectangle *r, uchar *pal, uchar *pic) {
  int z;
  uchar fpal[768];

  for (z = 0; z < 768; z++) {
    fpal[z] = (int) (t*pal[z]);
  }
  paintPic(r, fpal, pic);
}
*/

void fade(float t, uchar *pal, uchar *fpal) {
  int z;

  for (z = 0; z < 768; z++) {
    fpal[z] = (int) (t*pal[z]);
  }
}

int luxomanA1Res[] = {96,80};
int luxomanA2Res[] = {117,60};

void fadePics(float t) {
  uchar fpal[768];
  Rectangle r;

  setRect(&r, 74, 129, luxomanA2Res);
  fade(t, luxomanPal, fpal);
  paintPic3(&r, 74, 129, luxomanRes[0], fpal, luxomanPic);

  setRect(&r, 31, 106, luxolRes);
//  fade(t, luxolPal, fpal);
  paintPic(&r, fpal, luxolPic);
}

void fadePics2(float t) {
  uchar fpal[768];
  Rectangle r;

  fade(t, luxomanPal, fpal);
  setRect(&r, 0, 0, luxomanRes);
  paintPic(&r, fpal, luxomanPic);
  setRect(&r, 0, 40, digisnapRes);
  paintPic2(&r, fpal, digisnapPic);
  setRect(&r, 0, 72, neroRes);
  paintPic2(&r, fpal, neroPic);
  setRect(&r, 0, 104, mufflerRes);
  paintPic2(&r, fpal, mufflerPic);

}

//--- main
void main() {
  int debug = 0;
  int z;
  Rectangle r;

  vesa.mode = 0;
  vesa.xres = 320;//640;
  vesa.yres = 240;//480;
  vesa.bpplist[0] = 32;
  vesa.bpplist[1] = 24;
  vesa.bpplist[2] = 16;
  vesa.bpplist[3] = 15;
  vesa.area = 0;
  readconfig();
if (debug <= 0) {
  initvesa(&vesa, 1);
  if (!setmode(&vesa)) exits("Error initing mode");
}
/*
if (debug > 0) {
  vesa.xres = (vesa.xres*vesa.area)/100;
  vesa.yres = (vesa.yres*vesa.area)/100;
  vesa.pbytes = (vesa.bpplist[0]+7) >> 3;
  vesa.xbytes = vesa.pbytes*vesa.xres;
  vesa.linbuf = getmem(vesa.xbytes*vesa.yres);//allocmem(vesa.xbytes*vesa.yres);
  vesa.redbits = 8;
  vesa.greenbits = 8;
  vesa.bluebits = 8;
  vesa.redpos = 0;
  vesa.greenpos = 8;
  vesa.bluepos = 16;
}
*/

  finit(0x167F); //I=affine, rc=down, pc=double
  initAlpha();

  initIntro(vesa.xres, vesa.yres); //initmem
if (debug <= 0) {
  if (vesa.pbytes > 2) makeColtab32(); else makeColtab16();

  startxm(); //start playing
}
  //---pic
  mainsub = maincount;
  do {
    timecount = maincount - mainsub;

    bzero(screenBuf, xres*yres*4);
    if (timecount < 4800) {
      setRect(&r, 101, 160, luxomanA1Res);
      paintPic3(&r, 101, 160, luxomanRes[0], luxomanPal, luxomanPic);

      if (timecount > 1650) {
       setRect(&r, 180, 190, matrmingRes);
       paintPic(&r, matrmingPal, matrmingPic);
      }
    } else {
      setRect(&r, 74, 129, luxomanA2Res);
      paintPic3(&r, 74, 129, luxomanRes[0], luxomanPal, luxomanPic);

      if (timecount > 6450) {
       setRect(&r, 31, 106, luxolRes);
       paintPic(&r, luxolPal, luxolPic);
      }
    }

/*
    setRect(&r, 0, 0, luxomanRes);
    paintPic(&r, luxomanPal, luxomanPic);
    if (timecount > 2000) {
      setRect(&r, 300, 20, matrminiRes);
      paintPic2(&r, matrminiPal, matrminiPic);
    }
    if (timecount > 5000) {
      setRect(&r, 110, 70, luxominiRes);
      paintPic2(&r, luxominiPal, luxominiPic);
    }
*/

    copyBuffer();
    if (keypressed()) goto end;
  } while (timecount < 8000);

  //---main
  endFlag = 0;
  mainsub = maincount;// - 55000;
  do {
    timecount = 3*(maincount - mainsub)/2;
    step();
    render();

    if (timecount < 2000) {
//      setRect(&r, 110, 70, luxominiRes);
//      fade(1.0 - timecount/2000.0, &r, luxominiPal, luxominiPic);
//        paintPic2(&r, luxominiPal, luxominiPic);
      fadePics(1.0 - timecount/2000.0);
    }
    if (debug <= 0) copyBuffer();
    if (keypressed()) goto end;
  } while (!endFlag);
//end2:
  //---pic
  mainsub = maincount;
  do {
    timecount = maincount - mainsub;

    bzero(screenBuf, xres*yres*4);
    setRect(&r, 0, 0, luxomanRes);
    paintPic(&r, luxomanPal, luxomanPic);
    if (timecount > 2000) {
      setRect(&r, 0, 40, digisnapRes);
      paintPic2(&r, digisnapPal, digisnapPic);
      setRect(&r, 0, 72, neroRes);
      paintPic2(&r, neroPal, neroPic);
      setRect(&r, 0, 104, mufflerRes);
      paintPic2(&r, mufflerPal, mufflerPic);
    }
    copyBuffer();
    if (keypressed()) goto end;
  } while (timecount < 8000);

  mainsub = maincount;
  do {
    timecount = maincount - mainsub;

    bzero(screenBuf, xres*yres*4);
    fadePics2(1.0 - timecount/1000.0);
    copyBuffer();
    if (keypressed()) goto end;
  } while (timecount < 1000);
end:
  stopxm();
  textmode();
}