#ifndef _POLY_H_
#define _POLY_H_

#include "remix.h"

void bumpPolygon(ParamPoint *start, ParamPoint *end,
  ushort *bumpMap, uint **bInfos);
#pragma aux bumpPolygon "*" parm [] routine reverse modify [eax ebx ecx edx esi edi]

void shadowPolygon(ParamPoint *start, ParamPoint *end);
#pragma aux shadowPolygon "*" parm [] routine reverse modify [eax ebx ecx edx esi edi]

void lightPolygon(ParamPoint *start, ParamPoint *end, Vector *colVec);
#pragma aux lightPolygon "*" parm [] routine reverse modify [eax ebx ecx edx esi edi]

void initAlpha();
#pragma aux initAlpha "*" modify [eax ebx ecx edx]

void txtAlphaPhongPolygon(ParamPoint *start, ParamPoint *end,
  int nParams1, int size, uint *tMap, uint **pMaps);
#pragma aux txtAlphaPhongPolygon "*" parm [] routine reverse modify [eax ebx ecx edx esi edi]

/*
void txtPhongPolygon(ParamPoint *start, ParamPoint *end,
  int nParams1, int size, uint *tMap, uint **pMaps);
#pragma aux txtPhongPolygon "*" parm [] routine reverse modify [eax ebx ecx edx esi edi]
*/

void gouraudAddPolygon(ParamPoint *start, ParamPoint *end, uint *gMap);
#pragma aux gouraudAddPolygon "*" parm [] routine reverse modify [eax ebx ecx edx esi edi]

void txtAddPolygon(ParamPoint *start, ParamPoint *end, uint *tMap);
#pragma aux txtAddPolygon "*" parm [] routine reverse modify [eax ebx ecx edx esi edi]

// must have at least 2 lightsources
void anisoPolygon(ParamPoint *start, ParamPoint *end,
  int nParams1, int size, uint **aMaps);
#pragma aux anisoPolygon "*" parm [] routine reverse modify [eax ebx ecx edx esi edi]

void plainPolygon(ParamPoint *start, ParamPoint *end, int col);
#pragma aux plainPolygon "*" parm [] routine reverse modify [eax ebx ecx edx esi edi]

#endif