// start xm

#include <stdlib.h>

#include "rxm.h"

int dflags = df16bit | dfStereo;
//int vol = 12;
int mixrate = 44100;
int mastervol = 0;
int iwflag = 1;

extern char mucke;
#pragma aux mucke "*"

int parse(char *s, int mul) {
  int r = 0;

  while (*s && (*s < '0' || *s > '9')) s++;
  while (*s >= '0' && *s <= '9') {
    r *= mul;
    r += *s - '0';
    s++;
  }
  return r;
}

int checkenv(tdinfo *dinfo) {
  int i;
  i = dinfo->base >= 0x200 && dinfo->base <= 0x290;
  i &= dinfo->irq >= 2 && dinfo->irq <= 15;
  i &= dinfo->dma1 <= 7;
  i &= dinfo->dma2 <= 7;
  return i;
}

int gusenv(tdinfo *dinfo, int flags, int iwflag) {
  char *s;

  memset(dinfo,0,sizeof(tdinfo));
  s = getenv("ULTRASND");
  dinfo->base = parse(s,16);
  s = strchr(s,',');
  if (!s) return 0;
  dinfo->dma1 = parse(s,10);
  s = strchr(s+1,',');
  if (!s) return 0;
  dinfo->dma2 = parse(s,10);
  s = strchr(s+1,',');
  if (!s) return 0;
  dinfo->irq = parse(s,10);

  if (iwflag >= 2 || (iwflag == 1 && getenv("INTERWAVE"))) dinfo->flags |= gus_iw;
  dinfo->flags |= flags;

  return checkenv(dinfo);
}

int sbenv(tdinfo *dinfo, int rate, int flags) {
  char *s;
  char *v;

  memset(dinfo,0,sizeof(tdinfo));
  s = getenv("BLASTER");
  v = strchr(s,'A');
  if (v) dinfo->base = parse(v,16);
  v = strchr(s,'I');
  if (v) dinfo->irq = parse(v,10);
  v = strchr(s,'D');
  if (!v) return 0;
  dinfo->dma1 = parse(v,10);
  v = strchr(s,'H');
  if (v) dinfo->dma2 = parse(v,10);
  dinfo->rate = rate;
  dinfo->flags = flags;
  return checkenv(dinfo);
}

void startxm() {
  int t;
  tdinfo dinfo;
  void *drv_mem = NULL;

  i8_init();
  rxminit();

  t = 0;
  if (!(dflags & dfNosound)) {
    //gus
    if (gusenv(&dinfo,dflags,iwflag)) t = u_test(&dinfo);
    //sb
    if (!t && sbenv(&dinfo,mixrate,dflags)) {
      if (dflags & sb_awe) t = a_test(&dinfo);
      if (!t) t = sb_test(&dinfo);
    }
  }
  //no sound
  if (!t) n_test(&dinfo);

  if (dinfo.mem) drv_mem = getmem(dinfo.mem);
  if (dinfo.dmabuf) {
    if (!(dinfo.dmabuf = getdmabuf(dinfo.dmabuf))) {
      exits("Not enough low mem");
    }
  }

  dinfo.mastervol = mastervol;

  t = rxmdevinit(&dinfo,drv_mem);
  if (t) {
    if (t == 1) exits("DMA error");
    exits("IRQ error");
  }
  rxmsetvol(12);
  rxmplay(&mucke, 0);
}

void stopxm() {
  rxmdevdone();
  freedmabuf();
  i8_done();
}
