#include "vector.h"

#include "copro.h"

void vecAssign(Vector *v1, Vector *v2) {
  v1->x = v2->x;
  v1->y = v2->y;
  v1->z = v2->z;
}

void vecAssign4(Vector *v, float x, float y, float z) {
  v->x = x;
  v->y = y;
  v->z = z;
}

void vecNeg(Vector *v) {
  v->x = -v->x;
  v->y = -v->y;
  v->z = -v->z;
}

void vecAdd(Vector *v1, Vector *v2) {
  v1->x += v2->x;
  v1->y += v2->y;
  v1->z += v2->z;
}

void vecAdd3(Vector *r, Vector *v1, Vector *v2) {
  r->x = v1->x + v2->x;
  r->y = v1->y + v2->y;
  r->z = v1->z + v2->z;
}

void vecSub(Vector *v1, Vector *v2) {
  v1->x -= v2->x;
  v1->y -= v2->y;
  v1->z -= v2->z;
}

void vecSub3(Vector *r, Vector *v1, Vector *v2) {
  r->x = v1->x - v2->x;
  r->y = v1->y - v2->y;
  r->z = v1->z - v2->z;
}

void vecMulf(Vector *v, float f) {
  v->x *= f;
  v->y *= f;
  v->z *= f;
}

void vecMul3(Vector *r, Vector *v, float f) {
  r->x = v->x*f;
  r->y = v->y*f;
  r->z = v->z*f;
}

void vecMulAdd(Vector *r, Vector *v, float f) {
  r->x += v->x*f;
  r->y += v->y*f;
  r->z += v->z*f;
}

void vecMulC(Vector *r, Vector *v) {
  r->x *= v->x;
  r->y *= v->y;
  r->z *= v->z;
}

float vecMul(Vector *v1, Vector *v2) {
  return v1->x*v2->x + v1->y*v2->y + v1->z*v2->z;
}

void vecCross(Vector *r, Vector *v1, Vector *v2) {
  r->x = v1->y*v2->z - v1->z*v2->y;
  r->y = v1->z*v2->x - v1->x*v2->z;
  r->z = v1->x*v2->y - v1->y*v2->x;
}

float vecAbs(Vector *v) {
  return sqrt(v->x*v->x + v->y*v->y + v->z*v->z);
}

void vecNorm(Vector *v) {
  float f;
  f = 1.0/sqrt(v->x*v->x + v->y*v->y + v->z*v->z);
  v->x *= f;
  v->y *= f;
  v->z *= f;
}

void dvecAssign(DVector *v1, DVector *v2) {
  v1->x = v2->x;
  v1->y = v2->y;
  v1->z = v2->z;
}

void dvecAssign4(DVector *v, double x, double y, double z) {
  v->x = x;
  v->y = y;
  v->z = z;
}

void dvecClear(DVector *v) {
  v->x = v->y = v->z = 0.0;
}

void dvecAdd(DVector *v1, DVector *v2) {
  v1->x += v2->x;
  v1->y += v2->y;
  v1->z += v2->z;
}

void dvecAdd3(DVector *r, DVector *v1, DVector *v2) {
  r->x = v1->x + v2->x;
  r->y = v1->y + v2->y;
  r->z = v1->z + v2->z;
}

void dvecSub(DVector *v1, DVector *v2) {
  v1->x -= v2->x;
  v1->y -= v2->y;
  v1->z -= v2->z;
}

void dvecSub3(DVector *r, DVector *v1, DVector *v2) {
  r->x = v1->x - v2->x;
  r->y = v1->y - v2->y;
  r->z = v1->z - v2->z;
}

void dvecMulf(DVector *v, double f) {
  v->x *= f;
  v->y *= f;
  v->z *= f;
}

void dvecMul3(DVector *r, DVector *v, double f) {
  r->x = v->x*f;
  r->y = v->y*f;
  r->z = v->z*f;
}

void dvecMulAdd(DVector *r, DVector *v, double f) {
  r->x += v->x*f;
  r->y += v->y*f;
  r->z += v->z*f;
}

double dvecMul(DVector *v1, DVector *v2) {
  return v1->x*v2->x + v1->y*v2->y + v1->z*v2->z;
}

void dvecCross(DVector *r, DVector *v1, DVector *v2) {
  r->x = v1->y*v2->z - v1->z*v2->y;
  r->y = v1->z*v2->x - v1->x*v2->z;
  r->z = v1->x*v2->y - v1->y*v2->x;
}

double dvecAbs(DVector *v) {
  return sqrt(v->x*v->x + v->y*v->y + v->z*v->z);
}

void dvecNorm(DVector *v) {
  double f;
  f = 1.0/sqrt(v->x*v->x + v->y*v->y + v->z*v->z);
  v->x *= f;
  v->y *= f;
  v->z *= f;
}
