#ifndef _VECTOR_H_
#define _VECTOR_H_

typedef struct {
  float x;
  float y;
  float z;
} Vector;

typedef struct {
  double x;
  double y;
  double z;
} DVector;

void vecAssign(Vector *v1, Vector *v2);
void vecAssign4(Vector *v, float x, float y, float z);
void vecNeg(Vector *v);
void vecAdd(Vector *v1, Vector *v2);
void vecAdd3(Vector *r, Vector *v1, Vector *v2);
void vecSub(Vector *v1, Vector *v2);
void vecSub3(Vector *r, Vector *v1, Vector *v2);
void vecMulf(Vector *v, float f);
void vecMul3(Vector *r, Vector *v, float f);
void vecMulAdd(Vector *r, Vector *v, float f);
void vecMulC(Vector *r, Vector *v);
float vecMul(Vector *v1, Vector *v2);
void vecCross(Vector *r, Vector *v1, Vector *v2);
float vecAbs(Vector *v);
void vecNorm(Vector *v);

void dvecAssign(DVector *v1, DVector *v2);
void dvecAssign4(DVector *v, double x, double y, double z);
void dvecClear(DVector *v);
void dvecNeg(DVector *v);
void dvecAdd(DVector *v1, DVector *v2);
void dvecAdd3(DVector *r, DVector *v1, DVector *v2);
void dvecSub(DVector *v1, DVector *v2);
void dvecSub3(DVector *r, DVector *v1, DVector *v2);
void dvecMulf(DVector *v, double f);
void dvecMul3(DVector *r, DVector *v, double f);
void dvecMulAdd(DVector *r, DVector *v, double f);
void dvecMulC(DVector *r, DVector *v);
double dvecMul(DVector *v1, DVector *v2);
void dvecCross(DVector *r, DVector *v1, DVector *v2);
double dvecAbs(DVector *v);
void dvecNorm(DVector *v);

#endif