#pragma pack(1)

#include <stdlib.h>
#include <stdio.h>

#include "gcube.h"
#include "copro.h"
#include "memory.h"
#include "string.h"
#include "rxm.h"
#include "vesa.h"
#include "copy.h"
#include "poly.h"

int timecount;
extern volatile int maincount;
#pragma aux maincount "*"
int mainsub;

extern int endFlag;

//vesa
tvesa vesa;

//player
int dflags = df16bit | dfStereo;
//int vol = 12;
int mixrate = 44100;
int mastervol = 0;
int iwflag = 1;


//grabber

typedef struct {
 char  ident_len;   //zahl an byte, die nach dem header zu berspringen ist
 char  cmap_type;   // = 1: palette vorhanden
 char  image_type;  //bit0 = 1: mit palette, bit1 = 1: rgb, bit3 = 1: gepackt
 short cmap_origin; //?
 short cmap_len;    //palettenlnge
 char  centry_size; //bit pro paletteneintrag
 short image_xorg;  //x - ursprung
 short image_yorg;  //y - ursprung
 short image_width; //x - auflsung
 short image_height;//y - auflsung
 char  pixel_size;  //bit pro pixel
 char  image_discr; //bit5 = 0: bild "auf dem kopf"
} theader;

void grab();
#pragma aux grab "grab"

void grab() {
  FILE *f;
  static int num = 0;
  char fname[16];
  theader header;
  char *cp;
  int x, y, i;
  char col[3];
  tvesa *aktvesa;

  aktvesa = &vesa;
  if (aktvesa->redbits != 8 || aktvesa->greenbits != 8 || aktvesa->bluebits != 8) return;

  sprintf(fname, "pic%05d.tga", num);
  num++;
  f = fopen(fname,"wb");

  header.ident_len = 0;
  header.cmap_type = 0;   // = 1: palette vorhanden
  header.image_type = 2;  //bit0 = 1: mit palette, bit1 = 1: rgb, bit3 = 1: gepackt
  header.cmap_origin = 0; //?
  header.cmap_len = 0;    //palettenlnge
  header.centry_size = 0; //bit pro paletteneintrag
  header.image_xorg = 0;  //x - ursprung
  header.image_yorg = 0;  //y - ursprung
  header.image_width = aktvesa->xres; //x - auflsung
  header.image_height = aktvesa->yres;//y - auflsung
  header.pixel_size = 24;  //bit pro pixel
  header.image_discr = 32; //bit5 = 0: bild "auf dem kopf"
  fwrite(&header,1,sizeof(theader),f);

  for (y = 0; y < aktvesa->yres; y++) {
    cp = (char *) aktvesa->linbuf + y*aktvesa->xbytes;
    for (x = 0; x < aktvesa->xres; x++) {
      i = *(int *) cp;

      col[2] = i >> aktvesa->redpos;
      col[1] = i >> aktvesa->greenpos;
      col[0] = i >> aktvesa->bluepos;
      fwrite(col,1,3,f);

      cp += aktvesa->pbytes;
    }
  }

  fclose(f);
}


//--- global heap
void *globalHeap;
int memInfo;

void initmem(int size) {
  globalHeap = memalloc(&memInfo, size);
}

void *getalignmem(int size, int align) {
  int p;

  size = (size +3) & ~3;

  align--;
  p = (int) globalHeap + align & ~align;

  globalHeap = (void *) (p + size);

  bzero((void *) p, size);
  return (void *) p;
}

void *getmem(int size) {
  return getalignmem(size, 4);
}


//--- config file
void readline(FILE *f, char *str) {
  int c;
  int count = 0;
  int z;

  do {
    if ((c = fgetc(f)) == EOF) break;
    if (c > 32 && count < 45) {
      if (c >= 'A' && c <= 'Z') c += 32;
      str[count] = c;
      count++;
    };

  } while (c != 10);
  str[count] = '\0';
};

int hex(char *s) {
  int r = 0;

  while (*s) {
    r <<=4;
    if (*s >= '0' && *s <= '9') r += *s - '0';
    if (*s >= 'a' && *s <= 'f') r += *s - 'a' + 10;
    if (*s >= 'A' && *s <= 'F') r += *s - 'A' + 10;
    s++;
  };
  return r;
}

void readlist(char *s, char *values, int novalues) {
  int z;
  for(z = 0; z < novalues; z++) values[z] = 0;
  z = 0;
  while (*s && novalues > 0) {
    if (*s >= '0' && *s <= '9') {
      *values *= 10;
      *values += *s - '0';
    };
    if (*s == ',') {
      values++;
      novalues--;
    }
    s++;
  }
}

int atob(char *s) {
  int i;
  i = atoi(s);
  if (i) return i;
  if (*s == 'y' || *s == 'Y') return 1;
  return 0;
}

void readconfig() {
  char str[48];
  char *val;
  FILE *f;

  f = fopen("gcube.cfg","rb");
  if (!f) exits("Can't read config file (gcube.cfg)");
  while (!feof(f)) {
    readline(f,str);
    val = strchr(str,';');
    if (val) *val = '\0';
    val = strchr(str,'=');
    if (val) {
      *val = '\0';
      val++;

      //mode 1
      if (!strcmp(str,"mode")) vesa.mode = hex(val);
      if (!strcmp(str,"mode_x")) vesa.xres = atoi(val);
      if (!strcmp(str,"mode_y")) vesa.yres = atoi(val);
      if (!strcmp(str,"mode_bit")) readlist(val,vesa.bpplist,4);
      if (!strcmp(str,"mode_a")) vesa.area = atoi(val);

      //player
      if (!strcmp(str,"nosound")) if (atob(val)) dflags |= dfNosound;
//      if (!strcmp(str,"volume")) vol = atoi(val);
      if (!strcmp(str,"16bit")) if (!atob(val)) dflags &= ~df16bit;
      if (!strcmp(str,"stereo")) if (!atob(val)) dflags &= ~dfStereo;
      if (!strcmp(str,"reverse")) if (atob(val)) dflags &= ~dfReverse;
      if (!strcmp(str,"rate")) mixrate = atoi(val);
      if (!strcmp(str,"sb_dsp1")) if (atob(val)) dflags |= sb_dsp1;
      if (!strcmp(str,"sb_awe")) if (atob(val)) dflags |= sb_awe;
      if (!strcmp(str,"sb_master")) mastervol = atoi(val);
      if (!strcmp(str,"gus_iw")) iwflag = atob(val);
    }
  }
  fclose(f);
}


//--- player
extern char mucke;
#pragma aux mucke "*"

//void startxm();
//void stopxm();
int parse(char *s, int mul) {
  int r = 0;

  while (*s && (*s < '0' || *s > '9')) s++;
  while (*s >= '0' && *s <= '9') {
    r *= mul;
    r += *s - '0';
    s++;
  }
  return r;
}

int checkenv(tdinfo *dinfo) {
  int i;
  i = dinfo->base >= 0x200 && dinfo->base <= 0x290;
  i &= dinfo->irq >= 2 && dinfo->irq <= 15;
  i &= dinfo->dma1 <= 7;
  i &= dinfo->dma2 <= 7;
  return i;
}

int gusenv(tdinfo *dinfo, int flags, int iwflag) {
  char *s;

  memset(dinfo,0,sizeof(tdinfo));
  s = getenv("ULTRASND");
  dinfo->base = parse(s,16);
  s = strchr(s,',');
  if (!s) return 0;
  dinfo->dma1 = parse(s,10);
  s = strchr(s+1,',');
  if (!s) return 0;
  dinfo->dma2 = parse(s,10);
  s = strchr(s+1,',');
  if (!s) return 0;
  dinfo->irq = parse(s,10);

  if (iwflag >= 2 || (iwflag == 1 && getenv("INTERWAVE"))) dinfo->flags |= gus_iw;
  dinfo->flags |= flags;

  return checkenv(dinfo);
}

int sbenv(tdinfo *dinfo, int rate, int flags) {
  char *s;
  char *v;

  memset(dinfo,0,sizeof(tdinfo));
  s = getenv("BLASTER");
  v = strchr(s,'A');
  if (v) dinfo->base = parse(v,16);
  v = strchr(s,'I');
  if (v) dinfo->irq = parse(v,10);
  v = strchr(s,'D');
  if (!v) return 0;
  dinfo->dma1 = parse(v,10);
  v = strchr(s,'H');
  if (v) dinfo->dma2 = parse(v,10);
  dinfo->rate = rate;
  dinfo->flags = flags;
  return checkenv(dinfo);
}

void startxm() {
  int t;
  tdinfo dinfo;
  void *drv_mem = NULL;

  i8_init();
  rxminit();

  t = 0;
  if (!(dflags & dfNosound)) {
    //gus
    if (gusenv(&dinfo,dflags,iwflag)) t = u_test(&dinfo);
    //sb
    if (!t && sbenv(&dinfo,mixrate,dflags)) {
      if (dflags & sb_awe) t = a_test(&dinfo);
      if (!t) t = sb_test(&dinfo);
    }
  }
  //no sound
  if (!t) n_test(&dinfo);

  if (dinfo.mem) drv_mem = getmem(dinfo.mem);
  if (dinfo.dmabuf) {
    if (!(dinfo.dmabuf = getdmabuf(dinfo.dmabuf))) {
      exits("Not enough low mem");
    }
  }

  dinfo.mastervol = mastervol;

  t = rxmdevinit(&dinfo,drv_mem);
  if (t) {
    if (t == 1) exits("DMA error");
    exits("IRQ error");
  }
  rxmsetvol(12);
  rxmplay(&mucke, 0);
}

void stopxm() {
  rxmdevdone();
  freedmabuf();
  i8_done();
}

//--- vesa
extern unsigned int *screenBuf;
#pragma aux screenBuf "*"

void *coltab;

typedef struct {
  unsigned int r[1024];
  unsigned int g[1024];
  unsigned int b[1024];
} Coltab32;

typedef struct {
  unsigned short r[1024];
  unsigned short g[1024];
  unsigned short b[1024];
} Coltab16;

void makeColtab32() {
  int z, c;
  Coltab32 *coltab32;

  coltab32 = (Coltab32 *) getmem(sizeof(Coltab32));
  for (z = 0; z < 1024; z++) {
    c = (z < 256) ? z : 255;
    coltab32->r[z] = c << vesa.redpos;
    coltab32->g[z] = c << vesa.greenpos;
    coltab32->b[z] = c << vesa.bluepos;
  }
  coltab = (void *) coltab32;
}

void makeColtab16() {
  int z, c;
  Coltab16 *coltab16;

  coltab16 = (Coltab16 *) getmem(sizeof(Coltab16));
  for (z = 0; z < 1024; z++) {
    c = (z < 256) ? z : 255;
    coltab16->r[z] = (c >> (8 - vesa.redbits)) << vesa.redpos;
    coltab16->g[z] = (c >> (8 - vesa.greenbits)) << vesa.greenpos;
    coltab16->b[z] = (c >> (8 - vesa.bluebits)) << vesa.bluepos;
  }
  coltab = (void *) coltab16;
}

//--- tracks
extern Track3 camPosTrack;
extern Track3 camTargetTrack;
extern Track3 pSourceTrack;
extern SwitchTrack pSourceActiveTrack;
extern Track3 lightTrack[numLights];

extern Key3 camPosKeys;
#pragma aux camPosKeys "*"

extern Key3 camTargetKeys;
#pragma aux camTargetKeys "*"

extern Key3 pSourceKeys;
#pragma aux pSourceKeys "*"

extern int pSourceActiveKeys;
#pragma aux pSourceActiveKeys "*"

extern Key3 light0Keys;
#pragma aux light0Keys "*"

extern Key3 light1Keys;
#pragma aux light1Keys "*"

void initTracks() {
  initTrack3(&camPosTrack, &camPosKeys);
  initTrack3(&camTargetTrack, &camTargetKeys);
  initTrack3(&pSourceTrack, &pSourceKeys);
  initSwitchTrack(&pSourceActiveTrack, &pSourceActiveKeys);
  initTrack3(&lightTrack[0], &light0Keys);
  initTrack3(&lightTrack[1], &light1Keys);
}


//--- main
void main() {
  int debug = 0;
  int z;

  vesa.mode = 0;
  vesa.flags = 0;
  vesa.xres = 320;//640;
  vesa.yres = 240;//480;
  vesa.bpplist[0] = 32;
  vesa.bpplist[1] = 24;
  vesa.bpplist[2] = 16;
  vesa.bpplist[3] = 15;
  vesa.area = 0;
  readconfig();
if (debug <= 0) {
  initvesa(&vesa, 1);
  if (!setmode(&vesa)) exits("Error initing mode");
}
/*
if (debug > 0) {
  vesa.xres = (vesa.xres*vesa.area)/100;
  vesa.yres = (vesa.yres*vesa.area)/100;
  vesa.pbytes = (vesa.bpplist[0]+7) >> 3;
  vesa.xbytes = vesa.pbytes*vesa.xres;
  vesa.linbuf = getmem(vesa.xbytes*vesa.yres);//allocmem(vesa.xbytes*vesa.yres);
  vesa.redbits = 8;
  vesa.greenbits = 8;
  vesa.bluebits = 8;
  vesa.redpos = 0;
  vesa.greenpos = 8;
  vesa.bluepos = 16;
}
*/

  finit(0x167F); //I=affine, rc=down, pc=double
  initAlpha();

  initIntro(vesa.xres, vesa.yres); //initmem
if (debug <= 0) {
  if (vesa.pbytes > 2) makeColtab32(); else makeColtab16();

  startxm(); //start playing
}
  endFlag = 0;
  mainsub = maincount;// - 55000;
  do {
    timecount = (maincount - mainsub)*2;
    step();
    render();
    if (debug <= 0) {
      switch (vesa.pbytes) {
        case 4:
          copyBuffer32(screenBuf, &vesa, coltab);
          break;
        case 3:
          copyBuffer24(screenBuf, &vesa, coltab);
          break;
        default:
          copyBuffer16(screenBuf, &vesa, coltab);
      }
    }
  } while (!endFlag && !keypressed());
  stopxm();
  textmode();
}