// control.cpp : Defines the entry point for the application.
//
// greetings, fellow demo coder. 
//
// here you will find all the tricks that made us demo gods. 
// you will find a lot of useful comments throughout the code. 
// remember to give us credit when you reuse it.

#include "stdafx.h"
#include "resource.h"


#include <fmod.h>
#include <fmod_errors.h>
#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>
#include <io.h>
// ---

HINSTANCE inst;

HWND hwndMain ;

FMUSIC_MODULE * mod;

int sizeX, sizeY ;

// the following variables will contain the size of the screen, which is defined
// by an x-axis and a y-axis. the x-axis is horizontal, the y-axis is vertical. 
// scanlines are horizontal.
// a pixel is defined in two dimensions, x and y, or horizontal and vertical.

int screenX = 1152, screenY = 870 ;

int period = 20 ;

int beat = 0 ;

// ---

#define NUMC 32
class Tunnel
{
private:

	struct Carre 
	{
		HWND hwnd ;
		RECT rect ;
	} ;

	Carre c[ NUMC ] ;
	int cLast ;

public:

	bool rolling ;

	Tunnel() 
		: cLast( NUMC - 1 )
		, rolling( false ) 
	{
		ZeroMemory( c, NUMC * sizeof( Carre ) ) ;
	}

	void Tick( int vel ) 
	{
		for ( int i = 0 ; i < NUMC ; i++ )
		{
			if ( c[i].hwnd != NULL ) 
			{
				InflateRect( &c[i].rect, vel, vel ) ;

				if ( c[i].rect.left < 0
					&& c[i].rect.top < 0 
					&& c[i].rect.right > sizeX
					&& c[i].rect.bottom > sizeY )
				{
					DestroyWindow( c[i].hwnd ) ;
					c[i].hwnd = NULL ;
				}

				else
				{
					SetWindowPos( c[i].hwnd, NULL, c[i].rect.left, c[i].rect.top, 
						c[i].rect.right - c[i].rect.left, c[i].rect.bottom -  c[i].rect.top,
						SWP_NOZORDER | SWP_DEFERERASE );
				}
			}
		}
	}

	void AddAtPos( int x, int y )
	{
		cLast = ( cLast + 1 ) % NUMC ; 

		if ( c[cLast].hwnd != NULL )
		{
			DestroyWindow( c[cLast].hwnd ) ;
			c[cLast].hwnd = NULL ;
		}

		c[cLast].rect.left = x  ;
		c[cLast].rect.top  = y ;
		c[cLast].rect.right  = x  ;
		c[cLast].rect.bottom = y  ;

		c[cLast].hwnd = CreateWindow("button", "", 
			WS_CHILD | WS_VISIBLE | BS_GROUPBOX,
			x, y,
			0, 0,
			hwndMain, NULL, inst, NULL) ;
	}

	void DoitRandom()
	{
		static int freq = 5 ;
		static int freqEau = 5 ;
		static int tick = 0 ;
		static int tickEau = 0 ;
		static int genX = 0 ;
		static int genY = 0 ;

		if ( tick % freq == 0 )
		{
			cLast = ( cLast + 1 ) % NUMC ; 

			if ( c[cLast].hwnd != NULL )
			{
				DestroyWindow( c[cLast].hwnd ) ;
				c[cLast].hwnd = NULL ;
			}

			if ( tickEau % freqEau == 0 )
			{
				genX = rand() % sizeX ;
				genY = rand() % sizeY ;

			}

			tickEau++ ;

			if ( rolling ) 
				AddAtPos( genX, genY ) ;
		}

		tick++ ;

		Tick( 1 ) ;
	}
} ;

// ---

class CheckMan
{
public:
	struct Model
	{
		int * pts ; // x, y, dx, dy, repeat
		int nPt ;
	} ;

	bool mustSwitch ;
	bool dance ;

private:
	static Model * models[] ;
	static int     nModels ;

	// ---

	int curModel ;
	Model * pModel ; 

	HWND hwndPool[ 16 ] ;

	double x[ 16 ] ;
	double y[ 16 ] ;
	double dx[ 16 ] ;
	double dy[ 16 ] ;

	Tunnel tLocal ;

public:
	CheckMan()
		: curModel( 0 )
		, mustSwitch( true ) 
		, dance( false ) 
	{
		ZeroMemory( hwndPool, sizeof( hwndPool ) ) ;
	}

	void Tick() 
	{
		if ( mustSwitch ) 
		{
			SwitchModel() ;
			mustSwitch = false ;
		}	

		if ( pModel != NULL ) 
		{
			for ( int i = 0 ; i < pModel->nPt ; i++ )
			{
				SetWindowPos( hwndPool[ i ], NULL, (int) x[i], (int) y[i], 
					20, 20,
					SWP_NOZORDER | SWP_DEFERERASE ) ;

				x[i] += dx[i] ;
				y[i] += dy[i] ;
				dx[i] *= 0.80 ;
				dy[i] *= 0.80 ;
			}
		}

		tLocal.Tick( 1 ) ;
	}

	void SwitchModel() 
	{
		if ( !dance ) 
			return ; 

		curModel = ( curModel + 1 ) % nModels ;

		pModel = models[ curModel ] ;

		for ( int i = 0 ; i < pModel->nPt ; i++ )
		{
			x[i]  = (double ) ( pModel->pts[ i * 5 + 1 ] - 200 ) / 60 * ( sizeX / 8 ) + sizeX / 2 ;
			y[i]  = (double ) ( pModel->pts[ i * 5 + 2 ] - 130 ) / 120 * ( sizeY / 3 ) + sizeY / 2;
			dx[i] = pModel->pts[ i * 5 + 3 ] ; 
			dy[i] = pModel->pts[ i * 5 + 4 ] ; 

			if ( hwndPool[ i ] == NULL ) 
			{
				hwndPool[i] = CreateWindow("button", "", 
					WS_CHILD | WS_VISIBLE | BS_CHECKBOX,
					(int) x[i], (int) y[i],
					20, 20,
					hwndMain, NULL, inst, NULL) ;
			}

			else
			{
				SetWindowPos( hwndPool[ i ], NULL, (int) x[i], (int) y[i], 
					20, 20,
					SWP_NOZORDER | SWP_DEFERERASE );

			}

			if ( pModel->pts[ i * 5 ] != 0 )
			{
				tLocal.AddAtPos( (int) x[i], (int) y[i] ) ;
			}
		}
	}
} ;

int pts1[] = 
{
	0, 180, 10, 10, 0,	// head
	0, 190, 60, 5, 0,   // torso
	0, 200, 120, -1, 0,   
	0, 140,  60, 4, 4,   // left arm
	0, 260, 60, 0, 0,   // right arm
	0, 150,  160, 0, -1,   // upper leg
	0, 250,  160, 0, 1,   
	0, 110, 250, 0, -2,   // lower leg
	0, 290, 250, 0, 1,
} ; 
CheckMan::Model Model1 = { pts1, sizeof( pts1 ) / sizeof( int ) / 5 } ;

int pts2[] = 
{
	0, 220, 10, -10, 0,	// head
	0, 210, 60, -5, 0,   // torso
	0, 200, 120, 1, 0,   
	0, 140,  60, 0, 0,   // left arm
	0, 260, 60, -4, 4,   // right arm
	0, 150,  160, 0, 1,   // upper leg
	0, 250,  160, 0, -1,   
	0, 110, 250, 0, 1,   // lower leg
	0, 290, 250, 0, -2,
} ; 
CheckMan::Model Model2 = { pts2, sizeof( pts2 ) / sizeof( int ) / 5 } ;

CheckMan::Model * CheckMan::models[] =
{
	&Model1,
	&Model2
} ;
int CheckMan::nModels = sizeof( CheckMan::models ) / sizeof( CheckMan::Model * ) ;

// ---

class WindowScroll
{
public:

	int lastBeat ;
	int freq ;

	int chunkiness ;

	bool sinus ;
	bool rolling ;

	struct wsItem
	{
		HWND hwnd ;
		RECT rect ;
		int  vel ;

	} ;

	static BOOL CALLBACK wndProc(HWND h,UINT m,WPARAM w,LPARAM l)
	{
		return DefWindowProc(h, m, w, l);
	}

	WindowScroll() 
		: freq( 2 ) 
		, lastBeat( -1 )
		, sinus( false )
		, rolling( false ) 
	{
	}
	~WindowScroll() 
	{
	}

	void Register()
	{
		WNDCLASS wc ;

		wc.style = 0;
		wc.lpfnWndProc = (WNDPROC) wndProc ;
		wc.cbClsExtra = 0;
		wc.cbWndExtra = 0;
		wc.hInstance = inst; 
		wc.hIcon = LoadIcon((HINSTANCE) NULL, IDI_APPLICATION);
		wc.hCursor = LoadCursor((HINSTANCE) NULL, IDC_ARROW);
		wc.hbrBackground = (HBRUSH) (COLOR_BTNFACE+1);
		wc.lpszMenuName =  NULL;
		wc.lpszClassName = "DCBWindowScrollClass";

		VERIFY( RegisterClass(&wc) ) ;
	}

	void Tick()
	{
		if ( lastBeat < beat / freq ) 
		{
			lastBeat = beat / freq ;

			if ( rolling ) 
			{
				wsItem item ;

				item.rect.left   = screenX ;
				item.rect.top    = rand() % screenY ; 
				item.rect.right  = item.rect.left + rand() % ( screenX / 3 ) ;
				item.rect.bottom = item.rect.top  + rand() % ( screenY / 3 ) ;
				item.vel         = rand() % ( screenX / chunkiness ) + ( screenX / chunkiness ) ;

				item.hwnd = CreateWindow( "DCBWindowScrollClass", "con",
					WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX, 
					item.rect.left, item.rect.top,
					item.rect.right - item.rect.left, item.rect.bottom - item.rect.top, (HWND) NULL,  
					NULL, inst, (LPVOID) NULL);

				ShowWindow( item.hwnd, SW_SHOW );
				UpdateWindow( item.hwnd ) ;

				wnd.AddTail( item ) ;
			}
		}

		POSITION pos = wnd.GetHeadPosition() ;

		while ( pos != NULL )
		{
			wsItem & item = wnd.GetNext( pos ) ;

			if ( item.rect.right < 0 && item.hwnd != NULL )
			{
				DestroyWindow( item.hwnd ) ;

				item.hwnd = NULL ;
			}
			else
			{
				item.rect.left -= item.vel ;
				item.rect.right -= item.vel ;

				if ( sinus ) 
				{
					int dY = sin( (double) item.rect.left / ( screenX / 4 ) * 3.14 ) * ( screenY / 20 ) ; 

					SetWindowPos( item.hwnd, NULL, 
						(int) item.rect.left, (int) item.rect.top + dY, 
						item.rect.right - item.rect.left, item.rect.bottom - item.rect.top + dY,
						SWP_NOZORDER | SWP_DEFERERASE );
				}

				else
				{
					SetWindowPos( item.hwnd, NULL, 
						(int) item.rect.left, (int) item.rect.top, 
						item.rect.right - item.rect.left, item.rect.bottom - item.rect.top,
						SWP_NOZORDER | SWP_DEFERERASE );
				}

			}
		}
	}

private:
	CList< wsItem, const wsItem & > wnd ;
} ;

// ---

class Titler
{
public:

	struct dcbTitle 
	{
		char * str ;
	} ;

	static dcbTitle titles[] ;
	
	Titler() 
	{
	}

	~Titler()
	{
	}

	void OnPaint( HDC hdc )
	{
		SelectObject(hdc, GetStockObject(SYSTEM_FIXED_FONT));
	}
} ;

Titler::dcbTitle Titler::titles[] =
{
	"Title1",
	"Title2",
	NULL
} ;


// ---

CheckMan man ;

Tunnel t ;

WindowScroll wscrl ;

Titler titler ;

// ---

void RowCallback( FMUSIC_MODULE *mod, unsigned char param )
{
	man.mustSwitch = true ;

	beat++ ;
}

struct mainSync
{
	int beat ;
	bool bubbles ;
	bool win ;
	bool winsin ;
	char * text ;
	int  textX ;
	int textY ;
	int chunky ;
	bool dancer ;
	bool fin ;
} ;

BOOL  displayBMP(HWND hwnd, HDC hdc,LPSTR lpstrFileName,DWORD dwX,DWORD dwY)
{
	int dwFile;
	BITMAPFILEHEADER bmfh;
	BITMAPINFOHEADER bmih;
	BITMAPINFO	 *lpMem;
	LPVOID  lpMem2;
	HBITMAP hbm;
	HDC     hdcMem;
	BITMAP  bm; 
  
	/* Retrieve a handle identifying the file.																*/
  dwFile = open(lpstrFileName, O_RDONLY ) ;
  
	/* Retrieve the BITMAPFILEHEADER structure.																*/
  read(dwFile,&bmfh, sizeof(BITMAPFILEHEADER));
  
	/* Retrieve the BITMAPINFOHEADER structure.																*/
  read(dwFile,&bmih, sizeof(BITMAPINFOHEADER));
  
	/* Allocate memory for the BITMAPINFO structure.													*/
  lpMem = (BITMAPINFO *)malloc(sizeof(BITMAPINFOHEADER) +  ((1<<bmih.biBitCount) * sizeof(RGBQUAD)));
  
	/* Load BITMAPINFOHEADER into the BITMAPINFO structure.										*/
  lpMem->bmiHeader.biSize = bmih.biSize;
  lpMem->bmiHeader.biWidth = bmih.biWidth;
  lpMem->bmiHeader.biHeight = bmih.biHeight;
  lpMem->bmiHeader.biPlanes = bmih.biPlanes;
  lpMem->bmiHeader.biBitCount = bmih.biBitCount;
  lpMem->bmiHeader.biCompression = bmih.biCompression;
  lpMem->bmiHeader.biSizeImage = bmih.biSizeImage;
  lpMem->bmiHeader.biXPelsPerMeter = bmih.biXPelsPerMeter;
  lpMem->bmiHeader.biYPelsPerMeter = bmih.biYPelsPerMeter;
  lpMem->bmiHeader.biClrUsed = bmih.biClrUsed;
  lpMem->bmiHeader.biClrImportant = bmih.biClrImportant;
  /*retrieve the color table. * 1 << bmih.biBitCount == 2 ^ bmih.biBitCount	*/
  read( dwFile,lpMem->bmiColors,((1<<bmih.biBitCount) * sizeof(RGBQUAD)) );
  /* Allocate memory for the required number of bytes.											*/
  lpMem2 = malloc(bmfh.bfSize - bmfh.bfOffBits );
  memset( lpMem2,0,bmfh.bfSize - bmfh.bfOffBits );
  /* Retrieve the bitmap data.																							*/
  read( dwFile,lpMem2,(bmfh.bfSize - bmfh.bfOffBits) );
  /* Create a bitmap from the data stored in the *.BMP file.								*/
  hbm = CreateDIBitmap( hdc, &bmih,CBM_INIT, lpMem2,lpMem, DIB_RGB_COLORS );
  /* Unlock the global memory objects and close the .BMP file.							*/
	free( lpMem );
	free( lpMem2 );
	close( dwFile );

  if(!hbm)
		return FALSE;
  
	hdcMem = CreateCompatibleDC(hdc);
  SelectObject(hdcMem, hbm);
  GetObject(hbm, sizeof(BITMAP), (LPSTR) &bm);
  BitBlt(hdc, dwX, dwY, bm.bmWidth, bm.bmHeight,hdcMem, 0, 0, SRCCOPY);
  DeleteDC(hdcMem);

  return TRUE;
}

mainSync syncList[] = 
{
	{ 0, false, false, false, "", 0, 0, 40, false, true } ,
	{ 5, false, false, false, "dCb presents", 0, 0, 40, false, true } ,
	{ 9, false, false, false, "the world's first GDI dem0", 0, 0, 40, false, true } ,
	{ 16, false, false, false,"the world's first GDI dem0", 0, 0, 40, true } ,
	{ 32, false, false, false,"napster sucks0", 0, 0, 40, true } ,
	{ 48, true, false, false, "linux sucks", 0, 0, 40, true },
	{ 64, true, false, false, "metro honore-beaugrand sucks", 0, 0, 40, true },
	{ 112, true, true, false, "Welcome to the MSDN Library\n"
"The MSDN Library is an essential resource for developers using Microsoft tools, \n"
"products, and technologies. It contains a bounty of technical programming information, \n"
"including sample code, documentation, technical articles, and reference guides\n"
, 0, 0, 40, true },
	{ 144, true, true, true, "catch the flying windoz with your mouz", 0, 0, 80, true },
	{ 180, true, true, true, "vote dcb", 0, 0, 400, true },
	{ 196, false, true, true, "vote win32", 0, 0, 400, true, false },
	{ 8192, false, true, true, "dcb: poetic democoding.", 0, 0, 400, true, false }
} ;

int syncPos = 0 ;

BOOL CALLBACK wndProc(HWND h,UINT m,WPARAM w,LPARAM l)
{
	static HWND hStart = NULL ;

	HDC hdc ;
	PAINTSTRUCT ps ;

	switch (m)
	{
	case WM_COMMAND:
		DestroyWindow( hStart ) ;
		hStart = NULL ;
		SetTimer(h,1,period,NULL);
		FMUSIC_PlaySong(mod);
		FMUSIC_SetRowCallback( mod, RowCallback, 4 ) ;
		return 0 ;
	case WM_TIMER: 

		if ( beat > syncList[ syncPos ].beat )
		{
			t.rolling = syncList[ syncPos ].bubbles ;
			wscrl.rolling = syncList[ syncPos ].win ;
			wscrl.sinus = syncList[ syncPos ].winsin ;
			wscrl.chunkiness = syncList[ syncPos ].chunky ;
			man.dance = syncList[ syncPos ].dancer ;
			syncPos++ ;

			InvalidateRect( h, NULL, FALSE ) ;
		}

		man.Tick() ;
		t.DoitRandom() ;
		wscrl.Tick() ;
		return 0 ;

	case WM_PAINT :
		hdc = BeginPaint(h, &ps);

		if ( hStart == NULL ) 
		{
		if ( syncList[ syncPos ].fin )
		{
			displayBMP(h, hdc, "glaucos2.bmp", ( sizeX - 480 ) / 2 , ( sizeY - 360 ) / 2 ) ;
		}

			SelectObject(hdc, GetStockObject(SYSTEM_FIXED_FONT));
			TextOut( hdc, 50 + rand() % 50, 30 + rand() % 10, syncList[ syncPos ].text, strlen (syncList[ syncPos ].text ) );
		}

		EndPaint(h, &ps);
		return 0 ;

	case WM_CLOSE:
	case WM_DESTROY:
		PostQuitMessage(0);
		return 0;

	case WM_CREATE:
		hStart = CreateWindow("button", "gouda tuer", 
			WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
			sizeX/4, sizeY/4,
			sizeX/2, sizeY/2,
			h, NULL, ((LPCREATESTRUCT) l)->hInstance, NULL) ;

		return 0;
	}
	return DefWindowProc(h, m, w, l);
}

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{
	inst = hInstance;

	screenX = (GetSystemMetrics(SM_CXFULLSCREEN));
	screenY = (GetSystemMetrics(SM_CYFULLSCREEN));

	sizeX = screenX/2 ;
	sizeY = screenY/2 ;

	wscrl.Register() ;

	// ------------------------------------------------------------------------

	WNDCLASS wc ;

	wc.style = 0;
	wc.lpfnWndProc = (WNDPROC) wndProc ;
	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;
	wc.hInstance = inst; 
	wc.hIcon = LoadIcon((HINSTANCE) NULL, IDI_APPLICATION);
	wc.hCursor = LoadCursor((HINSTANCE) NULL, IDC_ARROW);
	wc.hbrBackground = (HBRUSH) (COLOR_BTNFACE+1);
	wc.lpszMenuName =  NULL;
	wc.lpszClassName = "DCBControlClass";

	VERIFY( RegisterClass(&wc) ) ;

	// ------------------------------------------------------------------------

	if ( FSOUND_GetVersion() != FMOD_VERSION )
	{
		MessageBox(NULL, "Incorrect FMOD version.", "gouda tuer by dcbouz", MB_OK );
		return 1 ;
	}

	if ( !FSOUND_Init(44100, 32, 0) )
	{
		MessageBox(NULL, "FMOD initialization failed.", "gouda tuer by dcbouz", MB_OK );
		return 1 ;
	}
	
	mod = FMUSIC_LoadSong("nugen4.s3m");

	// ------------------------------------------------------------------------

	hwndMain = CreateWindow("DCBControlClass", "gouda tuer by dcbouz",
		WS_CAPTION | WS_SYSMENU, screenX / 2 - sizeX / 2, screenY / 2 - sizeY / 2,
		sizeX, sizeY, (HWND) NULL,
		NULL, inst, (LPVOID) NULL);

	ShowWindow(hwndMain, nCmdShow);
	UpdateWindow(hwndMain);

	MSG msg ;

	while (GetMessage(&msg, (HWND) NULL, 0, 0)) 
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	// ------------------------------------------------------------------------

	FMUSIC_FreeSong(mod);

	FSOUND_Close();

	return 0;
}



