//
// Copy class for OpenPTC 1.0 Java Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

// package
package ptc;



public class Copy implements ptc.base.Copy
{
    public Copy() throws Error
    {
        // initialize factory
        Factory.initialize();

        // create copy object
        copy = Factory.copy();
    }
    
    protected void finalize() throws Error
    {
        // free factory
        Factory.free();

        // null copy
        copy = null;
    }

    public void request(Format source,Format destination) throws Error
    {
        // request copy
        copy.request(source,destination);
    }

    public void palette(Palette source,Palette destination) throws Error
    {
        // set palettes
        copy.palette(source,destination);
    }

    public void copy(Object source_pixels,int source_x,int source_y,int source_width,int source_height,int source_pitch,Object destination_pixels,int destination_x,int destination_y,int destination_width,int destination_height,int destination_pitch) throws Error
    {
        // perform copy
        copy.copy(source_pixels,source_x,source_y,source_width,source_height,source_pitch,destination_pixels,destination_x,destination_y,destination_width,destination_height,destination_pitch);
    }

    public boolean option(String string) throws Error
    {
        // copy option string
        return copy.option(string);
    }

    // internal copy object
    private ptc.base.Copy copy;
}
