//
// Java Clear class for OpenPTC 1.0 Java Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

// package name
package ptc.java;

// class imports
import ptc.Error;
import ptc.Color;
import ptc.Format;



public class Clear implements ptc.base.Clear
{
    public Clear() throws Error
    {
        // default format
        format = new Format();
    }
    
    public void request(Format format) throws Error
    {
        // setup clear format
        this.format = format.copy();
    }
    
    public void clear(Object pixels,int x,int y,int width,int height,int pitch,Color color) throws Error
    {
        // check that pitch is valid
        if (pitch%format.bytes()!=0) throw new Error("invalid pitch");
        
        // calculate stride from pitch
        final int stride = pitch / format.bytes();

        // check bits per pixel
        switch (format.bits())
        {
            case 32:
            {
                // cast pixels to int array
                int array[] = (int[]) pixels;

                // pack color value (kludge! assumes argb8888!)
                int value = ( ( (int) (color.a() * 255.0f) << 24 ) | 
                              ( (int) (color.r() * 255.0f) << 16 ) |
                              ( (int) (color.g() * 255.0f) << 8  ) |
                              ( (int) (color.b() * 255.0f) << 0  ) );

                // calculate offset (x,y)
                int offset = y*stride + x;

                // clear a line at a time
                for (int i=0; i<height; i++)
                {
                    // clear line to value
                    clear(array,offset,width,value);

                    // next line
                    offset += stride;
                }
            }
            break;
            
            case 16:
            {
                // cast pixels to short array
                short array[] = (short[]) pixels;

                // pack color value (kludge: black)
                short value = 0;

                // calculate offset (x,y)
                int offset = y*stride + x;

                // clear a line at a time
                for (int i=0; i<height; i++)
                {
                    // clear line to value
                    clear(array,offset,width,value);

                    // next line
                    offset += stride;
                }
            }
            break;

            case 8:
            {
                // cast pixels to byte array
                byte array[] = (byte[]) pixels;

                // pack color value (kludge: assume index)
                byte value = (byte) color.index();

                // calculate offset (x,y)
                int offset = y*stride + x;

                // clear a line at a time
                for (int i=0; i<height; i++)
                {
                    // clear line to value
                    clear(array,offset,width,value);

                    // next line
                    offset += stride;
                }
            }
            break;

            default:
            {
                // error message
                throw new Error(format.bits() + " bits per pixel clearing is not supported");
            }
        }
    }

    private void clear(int pixels[],int offset,int length,int value)
    {
        // clear a strip of pixels
        for (int i=0; i<length; i++) pixels[offset+i] = value;
    }

    private void clear(short pixels[],int offset,int length,short value)
    {
        // clear a strip of pixels
        for (int i=0; i<length; i++) pixels[offset+i] = value;
    }

    private void clear(byte pixels[],int offset,int length,byte value)
    {
        // clear a strip of pixels
        for (int i=0; i<length; i++) pixels[offset+i] = value;
    }

    // clear data
    private Format format;
}
