//
// Java Listener class for OpenPTC 1.0 Java Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

// package name
package ptc.java;

// import classes
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowAdapter;



public class Listener extends WindowAdapter
{
    public void windowClosing(WindowEvent event)
    {
        // get window that is closing
        Window window = event.getWindow();
        
        // dispose of window
        window.dispose();

        try
        {
            // exit program
            System.exit(0);
        }
        catch (Throwable error)
        {
            // could not exit... applet?
        }
    }
}
