//
// JNI Clear class for OpenPTC 1.0 Java Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

// package name
package ptc.jni;

// class imports
import ptc.Error;
import ptc.Color;
import ptc.Format;



public class Clear implements ptc.base.Clear
{
    public Clear() throws Error
    {
        // create object
        object = create();
    }
    
    protected void finalize() throws Error
    {
        // destroy object
        destroy(object);
    }

    public void request(Format format) throws Error
    {
        // request clear
        request(object,format);
    }
    
    public void clear(Object pixels,int x,int y,int width,int height,int pitch,Color color) throws Error
    {
        // clear pixels
        clear(object,pixels,x,y,width,height,pitch,color);
    }

    // object handle
    private long object;
    
    // native methods
    private native long create() throws Error;
    private native void destroy(long object) throws Error;
    public native void request(long object,Format format) throws Error;
    public native void clear(long object,Object pixels,int x,int y,int width,int height,int pitch,Color color) throws Error;
}
