/*
 * Decompiled with CFR 0.152.
 */
package org.fuzzion.audio.player;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import org.fuzzion.audio.player.Mod;
import org.fuzzion.audio.player.ModInstrument;
import org.fuzzion.audio.player.ModPlayerState;
import org.fuzzion.audio.player.ModTrackInfo;
import org.komplex.audio.AudioOutDevice;
import org.komplex.audio.AudioOutDeviceFactory;
import org.komplex.audio.PullAudioSource;

public class ModPlayer
implements Runnable {
    static final int EFF_VOL_SLIDE = 1;
    static final int EFF_PORT_DOWN = 2;
    static final int EFF_PORT_UP = 4;
    static final int EFF_VIBRATO = 8;
    static final int EFF_ARPEGGIO = 16;
    static final int EFF_PORT_TO = 32;
    static final int EFF_TREMOLO = 64;
    static final int EFF_RETRIG = 128;
    static final int MIX_BUF_SIZE = 2048;
    static final int DEF_TEMPO_NTSC = 6;
    static final int DEF_TEMPO_PAL = 6;
    static final int DEF_BPM_NTSC = 125;
    static final int DEF_BPM_PAL = 145;
    static final int MIDCRATE = 8448;
    static final int MAX_SAMPLES = 100;
    static final int MAX_TRACKS = 32;
    static final int S3M_MAGIC1 = 4122;
    static final int S3M_MAGIC2 = Mod.FOURCC("SCRM");
    static final int S3M_INSTR2 = Mod.FOURCC("SCRS");
    static final int[] normal_vol_adj = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 63};
    static final int[] loud_vol_adj = new int[]{0, 0, 1, 2, 2, 3, 3, 4, 5, 6, 7, 8, 9, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 47, 48, 49, 50, 51, 52, 53, 53, 54, 55, 55, 56, 56, 57, 57, 58, 58, 59, 59, 60, 60, 61, 61, 61, 62, 62, 62, 63, 63, 63, 63, 63, 63};
    static final int[] sintable = new int[]{0, 25, 50, 74, 98, 120, 142, 162, 180, 197, 212, 225, 236, 244, 250, 254, 255, 254, 250, 244, 236, 225, 212, 197, 180, 162, 142, 120, 98, 74, 50, 25};
    static final int[] period_set = new int[]{1712, 1616, 1525, 1440, 1359, 1283, 1211, 1143, 1078, 1018, 961, 907, 856, 808, 763, 720, 679, 641, 605, 571, 539, 509, 480, 453, 428, 404, 381, 360, 340, 321, 303, 286, 270, 254, 240, 227, 214, 202, 191, 180, 170, 160, 151, 143, 135, 127, 120, 113, 107, 101, 95, 90, 85, 80, 76, 71, 67, 64, 60, 57, 53, 50, 48, 45, 42, 40, 38, 36, 34, 32, 30, 28, 27, 25, 24, 22, 21, 20, 19, 18, 17, 16, 15, 14};
    static final int[] period_set_step = new int[]{1664, 1570, 1482, 1399, 1321, 1247, 1177, 1110, 1048, 989, 934, 881, 832, 785, 741, 699, 660, 623, 588, 555, 524, 494, 466, 440, 416, 392, 370, 350, 330, 312, 294, 278, 262, 247, 233, 220, 208, 196, 185, 175, 165, 155, 147, 139, 131, 123, 116, 110, 104, 98, 92, 87, 82, 78, 73, 69, 65, 62, 58, 55, 51, 49, 46, 43, 41, 39, 37, 35, 33, 31, 29, 27, 26, 24, 23, 21, 20, 19, 18, 17, 16, 15, 14, 14};
    static final byte[] sunfmt = new byte[]{46, 115, 110, 100, 0, 0, 0, 24, 127, 127, 127, 127, 0, 0, 0, 1, 0, 0, 31, 76, 0, 0, 0, 1, 0, 0, 0, 0};
    private static final int ERROR_SHIFT = 12;
    private static final int ERROR_MASK = 4095;
    private static final long ratediv = 22748294283264L;
    int def_tempo;
    int def_bpm;
    Thread playThread;
    PullAudioSource src;
    int[] pull_buf;
    int pull_buf_head;
    int pull_buf_tail;
    byte[] vol_table;
    int[] vol_adj;
    int vol_shift;
    Mod mod;
    int order_pos;
    int tempo;
    int tempo_wait;
    int bpm;
    int row;
    int break_row;
    int bpm_samples;
    int pattofs;
    byte[] patt;
    int numtracks;
    ModTrackInfo[] tracks;
    int mixspeed;
    boolean mod_done;
    public boolean bit16;
    public int samplingrate = 22050;
    public int oversample = 1;
    public int audiobuflen = 32768;
    public int gain = 256;
    public boolean loop = false;
    AudioOutDevice dev;

    public ModPlayerState getState() {
        ModPlayerState modPlayerState = new ModPlayerState();
        modPlayerState.order = this.order_pos;
        modPlayerState.row = this.row;
        modPlayerState.tempo = this.tempo;
        return modPlayerState;
    }

    public synchronized void start() {
        if (this.playThread == null) {
            this.playThread = new Thread(this);
            this.playThread.start();
        }
    }

    public synchronized void stop() {
        if (this.playThread != null) {
            this.mm_stop();
            this.playThread.stop();
            try {
                this.playThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.playThread = null;
        }
    }

    public synchronized void pause() {
        if (this.playThread != null) {
            this.playThread.suspend();
        }
    }

    public synchronized void resume() {
        if (this.playThread != null) {
            this.playThread.resume();
        }
    }

    public void outputTo(OutputStream outputStream) throws IOException {
        if (this.bit16) {
            this.play_mod16(false);
        } else {
            this.play_mod(false);
        }
    }

    public void mm_init() {
        this.pull_buf = new int[this.samplingrate * 4];
        this.pull_buf_head = 0;
        this.pull_buf_tail = 0;
        ModPlayer modPlayer = this;
        if (modPlayer == null) {
            throw null;
        }
        this.src = new PullAudioSource(modPlayer){
            private final /* synthetic */ ModPlayer this$0;

            public int read(int[] nArray, int n, int n2) {
                int n3;
                int n4 = this.this$0.pull_buf_tail;
                int n5 = this.this$0.pull_buf_tail - this.this$0.pull_buf_head;
                if (n5 < 0) {
                    n5 *= -1;
                }
                if (this.this$0.pull_buf_tail < this.this$0.pull_buf_head) {
                    n5 = this.this$0.pull_buf.length - n5;
                }
                if (n5 < 1) {
                    return 0;
                }
                int n6 = n3 = n2 < n5 ? n2 : n5;
                if (this.this$0.pull_buf_head <= n4) {
                    System.arraycopy(this.this$0.pull_buf, this.this$0.pull_buf_head, nArray, n, n3);
                    this.this$0.pull_buf_head += n3;
                } else {
                    int n7 = this.this$0.pull_buf.length - this.this$0.pull_buf_head - 1;
                    int n8 = n3 - n7;
                    if (n3 < n7) {
                        n7 = n3;
                    }
                    System.arraycopy(this.this$0.pull_buf, this.this$0.pull_buf_head, nArray, n, n7);
                    if (n8 > 0) {
                        System.arraycopy(this.this$0.pull_buf, 0, nArray, n + n7, n8);
                    }
                    this.this$0.pull_buf_head += n3;
                    this.this$0.pull_buf_head %= this.this$0.pull_buf.length;
                }
                return n3;
            }
            {
                this.this$0 = modPlayer;
                this.constructor$0(modPlayer);
            }

            private final void constructor$0(ModPlayer modPlayer) {
            }
        };
    }

    public AudioOutDevice mm_getAudioDevice() {
        AudioOutDeviceFactory audioOutDeviceFactory = new AudioOutDeviceFactory();
        AudioOutDevice audioOutDevice = null;
        while (audioOutDevice == null) {
            try {
                audioOutDevice = audioOutDeviceFactory.getAudioOutDevice();
                System.out.println(">>>>>" + audioOutDevice);
                if (audioOutDevice == null) break;
                Hashtable<String, ModPlayer> hashtable = new Hashtable<String, ModPlayer>();
                hashtable.put("component", this);
                audioOutDevice.setProperties(hashtable);
                audioOutDevice.init(3665);
                audioOutDevice.start();
                break;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                audioOutDeviceFactory.disableDevice(audioOutDevice);
                audioOutDevice = null;
            }
        }
        return audioOutDevice;
    }

    public void mm_start() {
        this.dev = this.mm_getAudioDevice();
        this.dev.setPullSource(this.src);
    }

    public void mm_stop() {
        this.dev.stop();
        this.dev = null;
    }

    public void run() {
        try {
            this.mm_init();
            this.mm_start();
            this.play_mod16(false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    final void make_vol_table8() {
        this.vol_table = new byte[16640];
        int n = 0;
        while (n < 16640) {
            this.vol_table[n] = (byte)(this.vol_adj[n >> 8] * (byte)n >> 8 + this.vol_shift);
            ++n;
        }
    }

    final void beattrack(ModTrackInfo modTrackInfo) {
        if (modTrackInfo.period_low_limit == 0) {
            modTrackInfo.period_low_limit = 1;
        }
        if ((modTrackInfo.effect & 1) != 0) {
            modTrackInfo.volume += modTrackInfo.vol_slide;
            if (modTrackInfo.volume < 0) {
                modTrackInfo.volume = 0;
            }
            if (modTrackInfo.volume > 64) {
                modTrackInfo.volume = 64;
            }
        }
        if ((modTrackInfo.effect & 2) != 0) {
            if ((modTrackInfo.period += modTrackInfo.port_down) > modTrackInfo.period_high_limit) {
                modTrackInfo.period = modTrackInfo.period_high_limit;
            }
            modTrackInfo.pitch = modTrackInfo.finetune_rate / modTrackInfo.period;
        }
        if ((modTrackInfo.effect & 4) != 0) {
            if ((modTrackInfo.period -= modTrackInfo.port_up) < modTrackInfo.period_low_limit) {
                modTrackInfo.period = this.mod.s3m ? modTrackInfo.period_high_limit : modTrackInfo.period_low_limit;
            }
            modTrackInfo.pitch = modTrackInfo.finetune_rate / modTrackInfo.period;
        }
        if ((modTrackInfo.effect & 0x20) != 0) {
            if (modTrackInfo.portto < modTrackInfo.period) {
                if ((modTrackInfo.period += modTrackInfo.port_inc) > modTrackInfo.portto) {
                    modTrackInfo.period = modTrackInfo.portto;
                }
            } else if (modTrackInfo.portto > modTrackInfo.period && (modTrackInfo.period -= modTrackInfo.port_inc) < modTrackInfo.portto) {
                modTrackInfo.period = modTrackInfo.portto;
            }
            modTrackInfo.pitch = modTrackInfo.finetune_rate / modTrackInfo.period;
        }
        if ((modTrackInfo.effect & 8) != 0) {
            modTrackInfo.vibpos += modTrackInfo.vib_rate << 2;
            int n = sintable[modTrackInfo.vibpos >> 2 & 0x1F] * modTrackInfo.vib_depth >> 7;
            if ((modTrackInfo.vibpos & 0x80) != 0) {
                n = -n;
            }
            if ((n += modTrackInfo.period) < modTrackInfo.period_low_limit) {
                n = modTrackInfo.period_low_limit;
            }
            if (n > modTrackInfo.period_high_limit) {
                n = modTrackInfo.period_high_limit;
            }
            modTrackInfo.pitch = modTrackInfo.finetune_rate / n;
        }
        if ((modTrackInfo.effect & 0x10) != 0) {
            modTrackInfo.pitch = modTrackInfo.finetune_rate / modTrackInfo.arp[modTrackInfo.arpindex];
            ++modTrackInfo.arpindex;
            if (modTrackInfo.arpindex >= 3) {
                modTrackInfo.arpindex = 0;
            }
        }
    }

    final int get_track(ModTrackInfo modTrackInfo, byte[] byArray, int n) {
        int n2 = byArray[n] & 0xF0;
        int n3 = (byArray[n++] & 0xF) << 8;
        n3 |= byArray[n++] & 0xFF;
        int n4 = byArray[n] & 0xF;
        int n5 = n++;
        int n6 = byArray[n++];
        modTrackInfo.effect = 0;
        if ((n2 |= (byArray[n5] & 0xF0) >> 4) != 0) {
            ModInstrument modInstrument = this.mod.insts[--n2];
            modTrackInfo.volume = modInstrument.volume;
            modTrackInfo.length = modInstrument.sample_length;
            modTrackInfo.repeat = modInstrument.repeat_point;
            modTrackInfo.replen = modInstrument.repeat_length;
            modTrackInfo.finetune_rate = modInstrument.finetune_rate;
            modTrackInfo.samples = modInstrument.samples;
            modTrackInfo.period_low_limit = modInstrument.period_low_limit;
            modTrackInfo.period_high_limit = modInstrument.period_high_limit;
        }
        if (n3 != 0) {
            modTrackInfo.portto = n3;
            if (n4 != 3 && n4 != 5) {
                modTrackInfo.start_period = modTrackInfo.period = n3;
                modTrackInfo.pitch = modTrackInfo.finetune_rate / n3;
                modTrackInfo.position = 0;
            }
        }
        if (n4 != 0 || n6 != 0) {
            block0 : switch (n4) {
                case 0: {
                    int n7 = 12;
                    while (n7 < 48) {
                        if (modTrackInfo.period >= period_set[n7]) break;
                        ++n7;
                    }
                    modTrackInfo.arp[0] = period_set[n7];
                    modTrackInfo.arp[1] = period_set[n7 + (n6 & 0xF)];
                    modTrackInfo.arp[2] = period_set[n7 + ((n6 & 0xF0) >> 4)];
                    modTrackInfo.arpindex = 0;
                    modTrackInfo.effect |= 0x10;
                    break;
                }
                case 1: {
                    modTrackInfo.effect |= 4;
                    if (n6 == 0) break;
                    modTrackInfo.port_up = n6;
                    break;
                }
                case 2: {
                    modTrackInfo.effect |= 2;
                    if (n6 == 0) break;
                    modTrackInfo.port_down = n6;
                    break;
                }
                case 3: {
                    if (n6 != 0) {
                        modTrackInfo.port_inc = n6 & 0xFF;
                    }
                    modTrackInfo.effect |= 0x20;
                    break;
                }
                case 4: {
                    if ((n6 & 0xF) != 0) {
                        modTrackInfo.vib_depth = n6 & 0xF;
                    }
                    if ((n6 & 0xF0) != 0) {
                        modTrackInfo.vib_rate = (n6 & 0xF0) >> 4;
                    }
                    if (n3 != 0) {
                        modTrackInfo.vibpos = 0;
                    }
                    modTrackInfo.effect |= 8;
                    break;
                }
                case 9: {
                    if (n6 == 0) {
                        n6 = modTrackInfo.oldsampofs;
                    }
                    modTrackInfo.oldsampofs = n6;
                    modTrackInfo.position = (n6 & 0xFF) << 8;
                    break;
                }
                case 5: {
                    modTrackInfo.effect |= 0x20;
                }
                case 6: {
                    if (n4 == 6) {
                        modTrackInfo.effect |= 8;
                    }
                }
                case 10: {
                    modTrackInfo.vol_slide = ((n6 & 0xF0) >> 4) - (n6 & 0xF);
                    modTrackInfo.effect |= 1;
                    break;
                }
                case 11: {
                    if (!this.loop) break;
                    this.order_pos = n6 & 0xFF;
                    this.row = 64;
                    break;
                }
                case 12: {
                    if (n6 > 64 || n6 < 0) {
                        modTrackInfo.volume = 64;
                        break;
                    }
                    modTrackInfo.volume = n6;
                    break;
                }
                case 13: {
                    this.break_row = ((n6 & 0xF0) >> 4) * 10 + (n6 & 0xF);
                    this.row = 64;
                    break;
                }
                case 14: {
                    int n8 = n6 & 0xF0;
                    n6 &= 0xF;
                    switch (n8) {
                        case 1: {
                            modTrackInfo.period += n6;
                            if (modTrackInfo.period > modTrackInfo.period_high_limit) {
                                modTrackInfo.period = modTrackInfo.period_high_limit;
                            }
                            modTrackInfo.pitch = modTrackInfo.finetune_rate / modTrackInfo.period;
                            break block0;
                        }
                        case 2: {
                            modTrackInfo.period -= n6;
                            if (modTrackInfo.period < modTrackInfo.period_low_limit) {
                                modTrackInfo.period = modTrackInfo.period_low_limit;
                            }
                            modTrackInfo.pitch = modTrackInfo.finetune_rate / modTrackInfo.period;
                            break block0;
                        }
                    }
                    break;
                }
                case 15: {
                    if (n6 == 0) break;
                    if ((n6 &= 0xFF) <= 32) {
                        this.tempo = n6;
                        this.tempo_wait = n6;
                        break;
                    }
                    this.bpm = n6;
                    this.bpm_samples = this.samplingrate / (103 * n6 >> 8) * this.oversample;
                    break;
                }
            }
        }
        return n;
    }

    final void startplaying(boolean bl) {
        this.vol_adj = bl ? loud_vol_adj : normal_vol_adj;
        this.mixspeed = this.samplingrate * this.oversample;
        this.order_pos = 0;
        this.tempo_wait = this.tempo = this.def_tempo;
        this.bpm = this.def_bpm;
        this.row = 64;
        this.break_row = 0;
        this.bpm_samples = this.samplingrate / (24 * this.bpm / 60) * this.oversample;
        this.numtracks = this.mod.numtracks;
        this.tracks = new ModTrackInfo[this.numtracks];
        int n = 0;
        while (n < this.tracks.length) {
            this.tracks[n] = new ModTrackInfo();
            ++n;
        }
        if (this.mod.s3m) {
            n = 0;
            while (n < this.mod.insts.length) {
                ModInstrument modInstrument = this.mod.insts[n];
                modInstrument.finetune_rate = (int)(428L * (long)modInstrument.finetune_value << 8) / this.mixspeed;
                modInstrument.period_low_limit = 14;
                modInstrument.period_high_limit = 1712;
                ++n;
            }
        } else {
            n = 0;
            while (n < this.mod.insts.length) {
                ModInstrument modInstrument = this.mod.insts[n];
                modInstrument.finetune_rate = (int)(22748294283264L / (long)(this.mixspeed * (1536 - modInstrument.finetune_value)));
                modInstrument.period_low_limit = 113;
                modInstrument.period_high_limit = 856;
                ++n;
            }
        }
        this.vol_shift = this.numtracks > 8 ? 2 : (this.numtracks > 4 ? 1 : 0);
        if (!this.bit16) {
            this.make_vol_table8();
        }
    }

    final void mixtrack_8_mono(ModTrackInfo modTrackInfo, byte[] byArray, int n, int n2) {
        byte[] byArray2 = modTrackInfo.samples;
        int n3 = modTrackInfo.position;
        int n4 = modTrackInfo.volume * this.gain << 16;
        int n5 = modTrackInfo.error;
        int n6 = modTrackInfo.pitch & 0xFFF;
        int n7 = modTrackInfo.pitch >> 12;
        if (modTrackInfo.replen < 3) {
            int n8 = modTrackInfo.length;
            int n9 = n + n2;
            while (n3 < n8 && n < n9) {
                int n10 = n++;
                byArray[n10] = (byte)(byArray[n10] + this.vol_table[byArray2[n3] & 0xFF | n4]);
                n3 += n7 + ((n5 += n6) >> 12);
                n5 &= 0xFFF;
            }
            modTrackInfo.error = n5;
            modTrackInfo.position = n3;
        } else {
            int n11 = modTrackInfo.replen + modTrackInfo.repeat;
            while (n2 > 0) {
                if (n3 >= n11) {
                    n3 -= modTrackInfo.replen;
                }
                int n12 = n++;
                byArray[n12] = (byte)(byArray[n12] + this.vol_table[byArray2[n3] & 0xFF | n4]);
                n3 += n7 + ((n5 += n6) >> 12);
                n5 &= 0xFFF;
                --n2;
            }
            modTrackInfo.error = n5;
            modTrackInfo.position = n3;
        }
    }

    /*
     * Unable to fully structure code
     */
    final void mixtrack_16_mono(ModTrackInfo var1_1, int[] var2_2, int var3_3, int var4_4) {
        block9: {
            block10: {
                block7: {
                    block8: {
                        var5_5 = var1_1.samples;
                        var6_6 = var1_1.position;
                        var8_7 = this.vol_adj[var1_1.volume] * this.gain >> this.vol_shift + 8;
                        var11_8 = var1_1.error;
                        var9_9 = var1_1.pitch & 4095;
                        var10_10 = var1_1.pitch >> 12;
                        if (var1_1.replen >= 3) break block7;
                        var7_11 = var1_1.length;
                        if (var6_6 >= var7_11) {
                            return;
                        }
                        var12_13 = var3_3 + var4_4;
                        if (var1_1.pitch >= 4096) ** GOTO lbl24
                        while (var6_6 < var7_11 && var3_3 < var12_13) {
                            v0 = var3_3++;
                            var2_2[v0] = var2_2[v0] + ((var5_5[var6_6] * (4096 - var11_8) + var5_5[var6_6 + 1] * var11_8) * var8_7 >> 12);
                            var6_6 += var10_10 + ((var11_8 += var9_9) >> 12);
                            var11_8 &= 4095;
                        }
                        break block8;
lbl-1000:
                        // 1 sources

                        {
                            v1 = var3_3++;
                            var2_2[v1] = var2_2[v1] + var5_5[var6_6] * var8_7;
                            var6_6 += var10_10 + ((var11_8 += var9_9) >> 12);
                            var11_8 &= 4095;
lbl24:
                            // 2 sources

                            ** while (var6_6 < var7_11 && var3_3 < var12_13)
                        }
                    }
                    var1_1.error = var11_8;
                    var1_1.position = var6_6;
                    break block9;
                }
                var7_12 = var1_1.replen + var1_1.repeat;
                if (var1_1.pitch >= 4096) ** GOTO lbl50
                while (var4_4 > 0) {
                    if (var6_6 >= var7_12) {
                        var6_6 -= var1_1.replen;
                    }
                    var12_14 = var6_6 < var5_5.length ? (var5_5[var6_6] * (4096 - var11_8) + var5_5[var6_6 + 1] * var11_8) * var8_7 >> 12 : var5_5[var5_5.length - 1];
                    v2 = var3_3++;
                    var2_2[v2] = var2_2[v2] + var12_14;
                    var6_6 += var10_10 + ((var11_8 += var9_9) >> 12);
                    var11_8 &= 4095;
                    --var4_4;
                }
                break block10;
lbl-1000:
                // 1 sources

                {
                    if (var6_6 >= var7_12) {
                        var6_6 -= var1_1.replen;
                    }
                    v3 = var3_3++;
                    var2_2[v3] = var2_2[v3] + var5_5[var6_6] * var8_7;
                    var6_6 += var10_10 + ((var11_8 += var9_9) >> 12);
                    var11_8 &= 4095;
                    --var4_4;
lbl50:
                    // 2 sources

                    ** while (var4_4 > 0)
                }
            }
            var1_1.error = var11_8;
            var1_1.position = var6_6;
        }
    }

    final void updatetracks() {
        this.tempo_wait = this.tempo;
        if (this.row >= 64) {
            if (this.order_pos >= this.mod.song_length_patterns) {
                this.order_pos = this.mod.song_repeat_patterns;
                if (this.order_pos >= this.mod.song_length_patterns) {
                    this.order_pos = 0;
                    this.mod_done = true;
                }
            }
            this.row = this.break_row;
            this.break_row = 0;
            if (this.mod.positions[this.order_pos] == 255) {
                if (!this.loop) {
                    this.mod_done = true;
                    return;
                }
                this.order_pos = 0;
                this.row = 0;
            }
            this.patt = this.mod.patterns[this.mod.positions[this.order_pos]];
            this.pattofs = this.row * 4 * this.numtracks;
            ++this.order_pos;
        }
        ++this.row;
        int n = 0;
        while (n < this.numtracks) {
            this.pattofs = this.get_track(this.tracks[n], this.patt, this.pattofs);
            ++n;
        }
    }

    final void play_mod(boolean bl) throws IOException {
        this.bit16 = false;
        this.startplaying(bl);
        this.mod_done = false;
        byte[] byArray = new byte[this.mixspeed];
        byte[] byArray2 = new byte[this.mixspeed];
        while (!this.mod_done || !this.loop) {
            if (--this.tempo_wait > 0) {
                int n = 0;
                while (n < this.numtracks) {
                    this.beattrack(this.tracks[n]);
                    ++n;
                }
            } else {
                this.updatetracks();
            }
            System.arraycopy(byArray2, 0, byArray, 0, this.bpm_samples);
            int n = 0;
            while (n < this.numtracks) {
                this.mixtrack_8_mono(this.tracks[n], byArray, 0, this.bpm_samples);
                ++n;
            }
        }
    }

    final void play_mod16(boolean bl) throws IOException {
        this.bit16 = true;
        this.startplaying(bl);
        this.mod_done = false;
        int[] nArray = new int[this.mixspeed];
        int[] nArray2 = new int[this.mixspeed];
        while (!this.mod_done) {
            int n;
            int n2;
            int n3;
            if (--this.tempo_wait > 0) {
                int n4 = 0;
                while (n4 < this.numtracks) {
                    this.beattrack(this.tracks[n4]);
                    ++n4;
                }
            } else {
                this.updatetracks();
            }
            System.arraycopy(nArray2, 0, nArray, 0, this.bpm_samples);
            int n5 = 0;
            while (n5 < this.numtracks) {
                this.mixtrack_16_mono(this.tracks[n5], nArray, 0, this.bpm_samples);
                ++n5;
            }
            int n6 = this.bpm_samples;
            if (this.oversample > 1) {
                n3 = 0;
                n6 = this.bpm_samples / this.oversample;
                if (this.oversample == 2) {
                    n5 = 0;
                    while (n5 < n6) {
                        nArray[n5] = nArray[n3] + nArray[n3 + 1] >> 1;
                        n3 += 2;
                        ++n5;
                    }
                } else {
                    n5 = 0;
                    while (n5 < n6) {
                        n2 = nArray[n3++];
                        n = 1;
                        while (n < this.oversample) {
                            n2 += nArray[n3++];
                            ++n;
                        }
                        nArray[n5] = n2 / this.oversample;
                        ++n5;
                    }
                }
            }
            if (this.pull_buf.length > this.pull_buf_tail + (n3 = n6)) {
                System.arraycopy(nArray, 0, this.pull_buf, this.pull_buf_tail, n3);
                this.pull_buf_tail += n3;
            } else {
                n2 = this.pull_buf.length - this.pull_buf_tail;
                n = n3 - n2;
                System.arraycopy(nArray, 0, this.pull_buf, this.pull_buf_tail, n2);
                if (n > 0) {
                    System.arraycopy(nArray, n2, this.pull_buf, 0, n);
                }
                this.pull_buf_tail += n3;
                this.pull_buf_tail %= this.pull_buf.length;
            }
            int n7 = this.pull_buf_tail - this.pull_buf_head;
            if (n7 < 0) {
                n7 *= -1;
            }
            if (this.pull_buf_tail < this.pull_buf_head) {
                n7 = this.pull_buf.length - n7;
            }
            if (n7 <= this.samplingrate) continue;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public ModPlayer(Mod mod) {
        this(mod, false);
    }

    public ModPlayer(Mod mod, boolean bl) {
        this.mod = mod;
        if (bl) {
            this.def_tempo = 6;
            this.def_bpm = 145;
        } else {
            this.def_tempo = 6;
            this.def_bpm = 125;
        }
    }
}

