// Primer intento de realizar un robot de Utopian
// El codigo de inicio esta basado en el rotate&fire
// 20/5/2000

// Notas a tener en cuenta:
//
// - Los angulos del caon y el radar son relativos al tanque


#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>
#include <math.h>
#include <string.h>

#include "Messagetypes.h"



// Variables globales, definicines de funciones, etc...
void chequear_mensajes(void);
char *nombre="SoS will rule :)";
char *color_casa="AAFFAA";
char *color_fuera="FFAAAA";

// Variables que definen el estado actual del objeto

static double distancia_pared=100000.0; // Ultima distancia a pared conocida
static int girando=0;                   // Toy girando?
static double aceleracion=0.0;          // Toy acelerando?
static int pared_seguidas=0;            // Numero de veces seguidas que he visto pared
static double robot_energia;
static double angulo_canyon;
static double velocidad;
static double tiempo;
static char tmpmensaje[256];
static char comando[256];
static char cadenawarning[60];

// Inicio del codigo en si

enum message_to_robot_type name2msg_to_robot_type(char* msg_name)
{
    int i;
  for( i=0; message_to_robot[i].msg[0] != '\0'; i++)
    {
      if( strcmp(message_to_robot[i].msg, msg_name) == 0 )
        return (message_to_robot_type)i;
    }
  return UNKNOWN_MESSAGE_TO_ROBOT;
}



// Me gusta la idea de recibir seales, asi que seguire ese estilo.

void handle_signal(int signr)
{
  // Chequear mensajes...

   chequear_mensajes();
  // Mantenemos la seal para la proxima vez
  signal(signr, handle_signal);
}


// Las siguientes funciones definen la interaccion en el sentido robot->juego

void robot_debug(const char *cadena)
{
    printf("Debug %s\n",cadena);
    fflush(stdout);

}

void robot_dispara(const double energia)
{
    printf("Shoot %lf\n",energia);
    fflush(stdout);
}

void robot_opcion(const int opcion, const int valor)
{
    printf("RobotOption %d %d\n",opcion,valor);
    fflush(stdout);
}

void robot_nombre(const char *nombre)
{
    printf("Name %s\n",nombre);
    fflush(stdout);
}

void robot_color(const char *home, const char *away)
{
    printf("Colour %s %s\n",home,away);
    fflush(stdout);
}

void robot_rota(const int que,const double velocidad)
{
   printf("Rotate %d %lf\n",que,velocidad);
   fflush(stdout);
}

// Con esta funcion solo se pueden rotar el caon y el radar

void robot_rota_hasta(const int que, const double velocidad, const double angulo)
{
  printf("RotateTo %d %lf %lf\n",que,velocidad,angulo);
   fflush(stdout);
}

// Con esta si que rota todo

void robot_rota_angulo(const int que, const double velocidad, const double angulo)
{
 printf("RotateAmount %d %lf %lf\n",que,velocidad,angulo);
   fflush(stdout);
}

void robot_acelera(const double accel)
{
   aceleracion=accel;
   printf("Accelerate %lf\n",accel);
   fflush(stdout);
}

// La frenada maxima es 1.0

void robot_frena(const double aceleracion)
{
  printf("Brake %lf\n",aceleracion);
   fflush(stdout);
}


void robot_print(const char *cadena)
{
    printf("Print %s\n",cadena);
    fflush(stdout);
}


// Acciones en respuesta a mensajes

void inicializa(int primera_vez)
{
    if(primera_vez == 1)
    {
        robot_nombre(nombre);
        robot_color(color_casa,color_fuera);
    }
    distancia_pared=100000.0; // Ultima distancia a pared conocida
    girando=0;                   // Toy girando?
    aceleracion=0.0;          // Toy acelerando?
    pared_seguidas=0;            // Numero de veces seguidas que he visto pared
}


void chequear_mensajes(void)
{

    char *mensaje;
    char *tmp;
    message_to_robot_type msg;
    
    memset(tmpmensaje,0,256);   // Limpiamos los buffers donde recogeremos el mensaje
    memset(comando,0,256);

    fgets(tmpmensaje,255,stdin);

    mensaje=tmpmensaje;
    tmp=comando;
    while((*mensaje!=' ') && (*mensaje!='\0') && (*mensaje!='\n')) *tmp++=*mensaje++; // Asi cogemos el comando
    *tmp='\0';

    // Ahora tenemos que comando almacena la parte del comando (tmp se ha pasado)
    // Y mensaje los parametros, aunque esta situado sobre el primer espacio, el NULL o el \n

    if(*mensaje == ' ') mensaje++;
    
    msg=name2msg_to_robot_type(comando);

    // Aqui viene todo el procesamiento de mensajes
    
    switch(msg)
    {
    case INITIALIZE:
        {
            int i;
            sscanf(mensaje,"%d",&i);
            inicializa(i);
//            robot_print("Inicializacion");
        }
        break;
    case YOUR_NAME:
        {
            //char temp[40];  // No hacemos nada
            //fgets(temp,40,stdin);
//            robot_print("Mi nombre");
        }
        break;
    case YOUR_COLOUR:
        {
            //char temp[40]; // Idem
           // fgets(temp,40,stdin);
//            robot_print("Mi color");
        }
        
        break;
    case GAME_OPTION:
        
          {
            int nr;
            double valor;
            sscanf(mensaje,"%d %lf", &nr, &valor);
//            robot_print("Opciones");
            //game_option( nr, value );
          }
          break;
    case GAME_STARTS:
        robot_print("A jugar!");
        inicializa(0);
          break;
    case RADAR:
          {
            double distancia, angulo;
            int objeto;
            sscanf(mensaje,"%lf %d %lf",&distancia,&objeto,&angulo);
 //           printf("Print Objeto tipo %d a distancia %lf y angulo %lf\n",objeto,distancia,angulo);
 //           fflush(stdout);
            switch(objeto)
              {
              case NOOBJECT:
                      robot_print("No veo na, no deberia pasar");
                      break;

                      // En cuanto localicemos un robot, paramos y apuntamos a por el!!!
                      
              case ROBOT:
                  pared_seguidas=0;
                  robot_acelera(0.0f);
                  robot_frena(1.0f); // Clavamos los frenos
                  robot_rota(7,0.0f);
                  girando=0.0f;
//                  robot_acelera(3.0f);
                  robot_print("Al ataquerl");
                  robot_dispara(10);
                  
                  
                break;
              case WALL:
                  //      robot_print("Veo una pared");
                  pared_seguidas++;
                  
                  if(distancia < distancia_pared) // Nos acercamos a una pared
                  {
                      distancia_pared=distancia;
                  }
                  if(distancia_pared < 2.0f) // Nos acercamos DEMASIADO a una pared
                  {
                      robot_frena(1.0f);
                      if(!girando)
                      {
                          girando=1;
                          //                          robot_rota_angulo(7,M_PI/4,M_PI/2);
                          if(random()%2)  robot_rota(7,M_PI/4); else robot_rota(7,-M_PI/4);
                      }
                  }
                  else if(pared_seguidas > 4) // No mas de 5 turnos quietos
                  {
                      robot_acelera(2.0f);
                  }
/*                  else // Nada, a girar un poco
                  {
                      if(!girando)
                      {
                       robot_print("Giro un poco");
                       girando=1;
                       robot_rota_angulo(7,M_PI/8,M_PI);
                      }
                  }*/
                break;
              case SHOT:
                  pared_seguidas=0;                  
//                  robot_dispara(3);
                break;
              case COOKIE:
                  pared_seguidas=0;
                  robot_acelera(2.0f);
                  break;
              case MINE:
                  pared_seguidas=0;
                  robot_dispara(3);
                  break;
              default:
                  robot_print("He visto un OVNI!");
                break;
              }
          }
          break;
    case INFO: sscanf(mensaje,"%lf %lf %lf",&tiempo,&velocidad,&angulo_canyon);
//               printf("Print %lf %lf %lf", tiempo,velocidad, angulo_canyon);
//               robot_print("InFO");
          break;
    case ROBOT_INFO:
        {
            double energia;
            int amigo;
            sscanf(mensaje,"%lf %d",&energia, &amigo); // De momento no haremos nada
        }
//            robot_print("ROBOT INFO");
        break;
        
    case ROTATION_REACHED:
        {
            int que;
            sscanf(mensaje,"%d",&que);
//          robot_print("Fin del giro");
            girando=0;
        }
          break;
    case ENERGY:
        sscanf(mensaje,"%lf",&robot_energia);
//        robot_print("Energia");
          break;
    case ROBOTS_LEFT:
        {
            int cuantos_quedan;
            sscanf(mensaje,"%d",&cuantos_quedan);
        }
//            robot_print("Robots left");
          break;
    case COLLISION:
        {

            int objeto;
            double angulo;
            sscanf(mensaje,"%d %lf",&objeto, &angulo);
//            robot_print("Colision");
            switch( objeto )
              {
              case NOOBJECT:
                break;
              case ROBOT:
                break;
              case WALL:
                break;
              case SHOT:
                break;
              case COOKIE:
                break;
              case MINE:
                break;
              default:
                  robot_print("He tocado un OVNI!");
                break;
              }
          }
          break;
    case WARNING:
        {
            int tipo;

            sscanf(mensaje,"%d %s",&tipo,cadenawarning);
            robot_print("Warning!");
        }
        break;
        
    case DEAD:

                    robot_print("Muerto");
        break;
    case GAME_FINISHES:
                    robot_print("Game over");
        break;
    case EXIT_ROBOT:
                    robot_print("ta luego lucas");
        exit(0);
        break;
     default:
//        robot_print(comando);
//        robot_print(mensaje);
        robot_print("eto que erl?");
          break;
        
    }
    
// robot_print("SACABO");
}














int main(int argc, char * argv[])
{
  sigset_t usr1set;

  // No nos bloqueamos y usamos seales

//  fflush(stdin);
  robot_opcion(SEND_ROTATION_REACHED,1); // Cuando terminemos de rotar recibiremos un mensaje
  robot_opcion( USE_NON_BLOCKING, 0 );
//  robot_opcion( SIGNAL, SIGUSR1 );



  // Inicializar la seal
//  signal(SIGUSR1, handle_signal);


  // libpthread seems to block USR1 sometimes for some reason (?!)
//  sigemptyset(&usr1set);
//  sigaddset(&usr1set, SIGUSR1);
//  sigprocmask(SIG_UNBLOCK, &usr1set, NULL);

  while( 1)
  {
      // Aqui deberia ir el procesamiento de la IA, aparte de la mera respuesta a mensajes
//            sleep(1);
      chequear_mensajes();
  }
  return( EXIT_SUCCESS );
}
