/*

tesla efekt

return:
  0 - doslo k chybe
  1 - este nezacal
  2 - prebehol v poriadku
  3 - uz skoncil
*/

#include <iostream>
#include "api3ds.h"
#include "efekt.h"
#include "efekt_02.h"
#include "syncs.h"

extern int sync_id;
extern bool showlogo;
extern BOOL usefog;

int  efekt_02::init()
{
  cout << "Efekt 2 init ... ";
  start=TRUE;
  counter=ZACIATOK02*refresh;
  glClearColor (cl_r, cl_g, cl_b, 1.0);
  l_r=l_g=l_b=1.0;
  tex_x_counter=0;
  tex_y_counter=0.0;
  real_in=0.0;
  cout << "ok!" << endl;
  return 1;
}

int  efekt_02::load()
{
    cout << "Loading efekt02 ... ";
    Vector3f o,i,j,k;
    FILE *stream;

    stream=fopen(CFGNAME02,"r");
    if (stream==NULL) return 0;

    fscanf(stream,"pocet ploch          %i\n",&plochy);
    fscanf(stream,"intenzita            %f\n",&intens);
    fscanf(stream,"x-krok               %f\n",&txadd);
    fscanf(stream,"y-krok               %f\n",&tyadd);
    fscanf(stream,"podstava valca       %i\n",&podstava);
    fscanf(stream,"vyska valca          %i\n",&vyska);
    fscanf(stream,"background color     %f,%f,%f\n",&cl_r,&cl_g,&cl_b);
    fscanf(stream,"visibility           %f\n",&vis);
    fscanf(stream,"minvisibility        %f\n",&minvis);
    fscanf(stream,"Descent origin       (%f,%f,%f)\n",&o.x,&o.y,&o.z);
    fscanf(stream,"Descent right        (%f,%f,%f)\n",&i.x,&i.y,&i.z);
    fscanf(stream,"Descent up           (%f,%f,%f)\n",&j.x,&j.y,&j.z);
    fscanf(stream,"Descent forward      (%f,%f,%f)\n",&k.x,&k.y,&k.z);
    fclose(stream);

    cam.SetAll(o,i,j,k);
    cam.FarClipplane(vis);
    cam.NearClipplane(minvis);
    cam.HorizontalFOV(0.63);
    cam.VerticalFOV(0.47);
    texla=texture_library->GetOrCreate("TESLA1.JPG");
    loading=texture_library->GetOrCreate("LOADING.JPG");

    cout << "ok!"<<endl;
}

int  efekt_02::free()  //vrati 3 ako ok, 0 ak doslo k chybe
{
end=true;
glClearColor(0.0,0.0,0.0,1.0);
return 3;
}

int  efekt_02::update()
{
id=Sync[GetSyncNum(float(counter)/float(refresh))].id;

tex_x_counter+=txadd;
tex_y_counter+=tyadd;
uhol_counter+=0.01;
if (id==SYNC_START_TESLA1)
  {
  if (real_in<intens) real_in+=0.002;
                else  real_in=intens;
  if (l_r>0.0) l_r-=0.01;
          else l_r=0.0;
  if (l_g>0.0) l_g-=0.01;
          else l_g=0.0;
  if (l_b>0.0) l_b-=0.01;
          else l_b=0.0;
  }
if (id==SYNC_GO_IN_BLACK)
  {
  if (cl_r>0.0) cl_r-=0.04;
           else cl_r=0.0;
  if (cl_g>0.0) cl_g-=0.04;
           else cl_g=0.0;
  if (cl_b>0.0) cl_b-=0.04;
           else cl_b=0.0;
//  cout << "clr=" << cl_r << endl;
  glClearColor(cl_r,cl_g,cl_b,1.0);
  }
return 1;
}

int efekt_02::go(double t)
{
if (t<ZACIATOK02) return 1;
if (end) return 3;
if (counter>=KONIEC02*refresh) return free();

if (!start) if (!init()) return 0;
int cur_frm=(int)(t*refresh);
if (cur_frm>KONIEC02*refresh) cur_frm=int(KONIEC02*refresh);
if (cur_frm>counter)
  while (counter<cur_frm)
    {
    counter++;
    if (counter<KONIEC02*refresh) update();
    }
if (counter>=KONIEC02*refresh) return free();

//tu sa kresli->
  loading->GL();
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
  glEnable(GL_TEXTURE_2D);
  glDisable(GL_FOG);
  glDisable(GL_LIGHTING);
  glDisable(GL_DEPTH_TEST);
  glDisable(GL_CULL_FACE);
  glEnable(GL_BLEND);
  glBlendFunc(GL_ZERO, GL_ONE_MINUS_SRC_COLOR);

  if (l_r<1.0) showlogo=false;
  glBegin(GL_QUADS);
    glColor3f(l_r,l_g,l_b);
    glTexCoord2f( 1.0, 1.0);
    glVertex2f  (-0.5,-0.8);
    glTexCoord2f( 1.0, 0.0);
    glVertex2f  (-0.5,-1.0); 
    glTexCoord2f( 0.0, 0.0);
    glVertex2f  (-0.9,-1.0);
    glTexCoord2f( 0.0, 1.0);
    glVertex2f  (-0.9,-0.8);
  glEnd();


   glBlendFunc(GL_ZERO, GL_ONE_MINUS_SRC_COLOR);
   texla->GL();
   cam.GL();

   glBegin(GL_QUADS);
     for (int i=plochy;i;i--)
       {
       float y=podstava*cos(uhol_counter+i*2*PI/plochy);
       float z=podstava*sin(uhol_counter+i*2*PI/plochy);

       glColor3f(0.0,0.0,0.0);
       glTexCoord2f( tex_x_counter, tex_y_counter);
       glVertex3f(-vyska, y, z);

       glColor3f(real_in,real_in,real_in);
       glTexCoord2f( tex_x_counter, tex_y_counter+1.0);
       glVertex3f(-vyska, 0, 0);

       glTexCoord2f( tex_x_counter+1.0, tex_y_counter+1.0);
       glVertex3f( vyska, 0, 0);

       glColor3f(0.0,0.0,0.0);
       glTexCoord2f( tex_x_counter+1.0, tex_y_counter);
       glVertex3f( vyska, y, z);

       }
   glEnd();

//<-
return 2;
}