#ifndef __OGL2_ENTITY__
#define __OGL2_ENTITY__

#include "String.h"
#include "List.h"

extern "C++" {

class Entity
{
  String __entity_name;
public:
  Entity(const char* p = 0) {
    __entity_name = p;
  }
  virtual ~Entity() {}

  void Name(const char* p) {
    __entity_name = p;
  }
  void Name(const String& S) {
    __entity_name = S;
  }
  const String& Name() {
    return __entity_name;
  }
};

template <class __type>
class EntityList {
protected:
  List<__type*> __entity_list;

public:

  EntityList<__type>& Add(__type* p) {
    if(p) __entity_list.push_back(p);
    return *this;
  }
  EntityList<__type>& operator += (__type* p) {
    return Add(p);
  }

  EntityList<__type>& Add (const EntityList<__type> & A) {
    __entity_list+=A.__entity_list;
    return *this;
  }
  EntityList<__type>& operator += (const EntityList<__type>& A) {
    return Add(A);
  }

  __type* Get(const char *p)
  {
    if(__entity_list.size()==0) return 0;
    __type* __temp;
    __entity_list.rewind();
    for(int i=__entity_list.size(); i; i--) {
      __temp = *__entity_list;
      if(__temp->Name()==p)
        return __temp;
      ++__entity_list;
      }
    return 0;
  }
  __type* Get(const String& S) { 
    return Get(S());
  }

  void DeleteEntities () {
    __entity_list.rewind();
    for(int i=__entity_list.size(); i; i--) {
      delete *__entity_list;
      ++__entity_list;
    }
    __entity_list.erase();
  }

};

} // extern "C++"

#endif
