//--FILE-DESC-----------------------------------------------------------------
//	file: camera.cpp
//	desc: some additional loading function
//----------------------------------------------------------------------------
#include "loader.h"
#include "directgem.h"

BYTE ReadByte(FILE *f)
{

	return fgetc(f);
}


WORD ReadWord(FILE *f)
{
	WORD				tmp;
	
	fread( &tmp, sizeof(WORD), 1, f );

	return tmp;
}


DWORD ReadDword(FILE *f)
{
	DWORD				tmp;

	fread( &tmp, sizeof(DWORD), 1, f );

	return tmp;
}


FLOAT ReadFloat(FILE *f)
{
	FLOAT		tmp;

	fread( &tmp, sizeof(D3DVALUE), 1, f);

	return tmp;
}


DWORD ReadASCIIZ(FILE* f, TCHAR* str)
{
	TCHAR		tmp;
	WORD		i = 0;

	while( tmp = ReadByte( f ) )
		str[i++] = tmp;

	str[i] = 0;

	return i;
}


DWORD JumpThroughtChunk( FILE* inFile  )
{
	DWORD		position;

	position=ReadDword( inFile )-6;
	fseek( inFile, position, SEEK_CUR);

	if( feof( inFile ) )
		return GEMERROR_LOAD;

	return GEMERROR_OK;
}

DWORD ReadObjectInfo( FILE *inFile, TCHAR* name, WORD& parent )
{

	ReadDword( inFile );
	ReadASCIIZ( inFile, name );
	
	ReadWord( inFile );
	ReadWord( inFile );
	parent = ReadWord( inFile );	

	if( feof( inFile ) )
		return GEMERROR_LOAD;

	return GEMERROR_OK;
}

DWORD ReadHierarchy( FILE* inFile, WORD& hierarchy )
{
	ReadDword( inFile );
	hierarchy = ReadWord( inFile );

	if( feof( inFile ) )
		return GEMERROR_LOAD;

	return GEMERROR_OK;
}