//----------------------------------------------------------------------------
//	file: vector.cpp
//	desc: implementation of gem_Vector methods
//----------------------------------------------------------------------------
#include <math.h>
#include "directgem.h"
#include "gemmath.h"

FLOAT Length(gem_Vector& v)
{
	return sqrt(v.x*v.x + v.y*v.y + v.z*v.z);
}

gem_Vector Normalize(gem_Vector& v)
{
	FLOAT		len = sqrt(v.x*v.x + v.y*v.y + v.z*v.z);

	if( !len )
		return v;

	return gem_Vector( v.x/len, v.y/len, v.z/len );
}


FLOAT Dot(gem_Vector& v, gem_Vector& u)
{
	return v.x*u.x + v.y*u.y + v.z*u.z;
}

gem_Vector Cross(gem_Vector& v, gem_Vector& u)
{
	gem_Vector		tmp;

	tmp.x = v.y*u.z - v.z*u.y;	
	tmp.y = v.z*u.x - v.x*u.z;
	tmp.z = v.x*u.y - v.y*u.x;	

	return tmp;
}

gem_Vector LERP(gem_Vector v, gem_Vector u, FLOAT t)
{
	gem_Vector		tmp;
	FLOAT			_1t = 1-t;
	
	tmp.x = _1t*v.x + t*u.x;
	tmp.y = _1t*v.y + t*u.y;
	tmp.z = _1t*v.z + t*u.z;

	return tmp;	
}

D3DVERTEX vLERP( D3DVERTEX a, D3DVERTEX b, FLOAT t )
{
	D3DVERTEX		tmp;
	FLOAT			_1t = 1-t;

	tmp.x = _1t*a.x + t*b.x;
	tmp.y = _1t*a.y + t*b.y;
	tmp.z = _1t*a.z + t*b.z;

	tmp.nx = _1t*a.nx + t*b.nx;
	tmp.ny = _1t*a.ny + t*b.ny;
	tmp.nz = _1t*a.nz + t*b.nz;

	tmp.tu = _1t*a.tu + t*b.tu;
	tmp.tv = _1t*a.tv + t*b.tv;
	
	return tmp;
}
	


gem_Vector operator- (gem_Vector& v)
{
	return gem_Vector( -v.x, -v.y, -v.z );
}

gem_Vector operator- (gem_Vector& v, gem_Vector& u)
{
	return gem_Vector( v.x-u.x, v.y-u.y, v.z-u.z );
}

gem_Vector operator+ (gem_Vector& v, gem_Vector& u)
{
	return gem_Vector( v.x+u.x, v.y+u.y, v.z+u.z );
}

gem_Vector operator* (FLOAT a, gem_Vector& v)
{
	return gem_Vector( a*v.x, a*v.y, a*v.z );
}

gem_Vector operator* (gem_Vector& v, FLOAT a)
{
	return gem_Vector( a*v.x, a*v.y, a*v.z );
}

D3DVECTOR GetD3DVECTOR(gem_Vector& v)
{
	D3DVECTOR		d3dvec;

	d3dvec.dvX = v.x;
	d3dvec.dvY = v.y;
	d3dvec.dvZ = v.z;

	return d3dvec;
}
