#ifndef		__BLOBS_H_
#define		__BLOBS_H_

#include	<d3d.h>

typedef struct blobgrid
{
	float		val[32][32][32];
	D3DVECTOR	pos;

	FLOAT		size;
	FLOAT		delta;
} BLOBGRID, *LPBLOBGRID;


typedef struct _blob3d
{
	D3DVECTOR	pos;
	FLOAT		r;
	FLOAT		R;
	BOOL		negative;

} BLOB3D, *LPBLOB3D;

VOID InitGrid( BLOBGRID&, D3DVECTOR, FLOAT );
FLOAT BlobFun( BLOB3D&, D3DVECTOR );
VOID Calculate( BLOBGRID&, LPBLOB3D, DWORD );
LONG CalculateVertex( BLOBGRID&, LPBLOB3D, DWORD, D3DVERTEX*, BOOL = FALSE );

#endif
