#ifndef __CUBE_H_
#define __CUBE_H_

#include <d3d.h>

VOID CreateCube( LPD3DVERTEX cube, FLOAT size )
{
	D3DVECTOR		normal = D3DVECTOR( 0, 0, -1 );

	cube[ 0] = D3DVERTEX( D3DVECTOR( -size,  size, -size ), D3DVECTOR( 0, 0, -1 ), 0, 0 );
	cube[ 1] = D3DVERTEX( D3DVECTOR(  size,  size, -size ), D3DVECTOR( 0, 0, -1 ), 1, 0 );
	cube[ 2] = D3DVERTEX( D3DVECTOR( -size, -size, -size ), D3DVECTOR( 0, 0, -1 ), 0, 1 );
	cube[ 3] = D3DVERTEX( D3DVECTOR( -size, -size, -size ), D3DVECTOR( 0, 0, -1 ), 0, 1 );
	cube[ 4] = D3DVERTEX( D3DVECTOR(  size,  size, -size ), D3DVECTOR( 0, 0, -1 ), 1, 0 );
	cube[ 5] = D3DVERTEX( D3DVECTOR(  size, -size, -size ), D3DVECTOR( 0, 0, -1 ), 1, 1 );

	cube[ 6] = D3DVERTEX( D3DVECTOR( -size, -size,  size ), D3DVECTOR( 0, 0,  1 ), 0, 1 );
	cube[ 7] = D3DVERTEX( D3DVECTOR(  size,  size,  size ), D3DVECTOR( 0, 0,  1 ), 1, 0 );	
	cube[ 8] = D3DVERTEX( D3DVECTOR( -size,  size,  size ), D3DVECTOR( 0, 0,  1 ), 0, 0 );
	cube[ 9] = D3DVERTEX( D3DVECTOR(  size, -size,  size ), D3DVECTOR( 0, 0,  1 ), 1, 1 );
	cube[10] = D3DVERTEX( D3DVECTOR(  size,  size,  size ), D3DVECTOR( 0, 0,  1 ), 1, 0 );
	cube[11] = D3DVERTEX( D3DVECTOR( -size, -size,  size ), D3DVECTOR( 0, 0,  1 ), 0, 1 );
	
	cube[12] = D3DVERTEX( D3DVECTOR( -size,  size, -size ), D3DVECTOR( 0,  1, 0 ), 0, 0 );
	cube[13] = D3DVERTEX( D3DVECTOR(  size,  size,  size ), D3DVECTOR( 0,  1, 0 ), 1, 1 );
	cube[14] = D3DVERTEX( D3DVECTOR(  size,  size, -size ), D3DVECTOR( 0,  1, 0 ), 1, 0 );
	cube[15] = D3DVERTEX( D3DVECTOR( -size,  size, -size ), D3DVECTOR( 0,  1, 0 ), 0, 0 );
	cube[16] = D3DVERTEX( D3DVECTOR( -size,  size,  size ), D3DVECTOR( 0,  1, 0 ), 0, 1 );
	cube[17] = D3DVERTEX( D3DVECTOR(  size,  size,  size ), D3DVECTOR( 0,  1, 0 ), 1, 1 );

	cube[18] = D3DVERTEX( D3DVECTOR( -size, -size, -size ), D3DVECTOR( 0, -1, 0 ), 0, 0 );
	cube[19] = D3DVERTEX( D3DVECTOR(  size, -size, -size ), D3DVECTOR( 0, -1, 0 ), 1, 0 );
	cube[20] = D3DVERTEX( D3DVECTOR(  size, -size,  size ), D3DVECTOR( 0, -1, 0 ), 1, 1 );
	cube[21] = D3DVERTEX( D3DVECTOR( -size, -size, -size ), D3DVECTOR( 0, -1, 0 ), 0, 0 );
	cube[22] = D3DVERTEX( D3DVECTOR(  size, -size,  size ), D3DVECTOR( 0, -1, 0 ), 1, 1 );
	cube[23] = D3DVERTEX( D3DVECTOR( -size, -size,  size ), D3DVECTOR( 0, -1, 0 ), 0, 1 );

	cube[24] = D3DVERTEX( D3DVECTOR( -size,  size, -size ), D3DVECTOR( -1, 0, 0 ), 0, 0 );
	cube[25] = D3DVERTEX( D3DVECTOR( -size, -size, -size ), D3DVECTOR( -1, 0, 0 ), 0, 1 );
	cube[26] = D3DVERTEX( D3DVECTOR( -size, -size,  size ), D3DVECTOR( -1, 0, 0 ), 1, 1 );	
	cube[27] = D3DVERTEX( D3DVECTOR( -size,  size, -size ), D3DVECTOR( -1, 0, 0 ), 0, 0 );
	cube[28] = D3DVERTEX( D3DVECTOR( -size, -size,  size ), D3DVECTOR( -1, 0, 0 ), 1, 1 );
	cube[29] = D3DVERTEX( D3DVECTOR( -size,  size,  size ), D3DVECTOR( -1, 0, 0 ), 1, 0 );
	
	cube[30] = D3DVERTEX( D3DVECTOR(  size, -size, -size ), D3DVECTOR(  1, 0, 0 ), 0, 1 );
	cube[31] = D3DVERTEX( D3DVECTOR(  size,  size, -size ), D3DVECTOR(  1, 0, 0 ), 0, 0 );	
	cube[32] = D3DVERTEX( D3DVECTOR(  size, -size,  size ), D3DVECTOR(  1, 0, 0 ), 1, 1 );
	cube[33] = D3DVERTEX( D3DVECTOR(  size,  size, -size ), D3DVECTOR(  1, 0, 0 ), 0, 0 );
	cube[34] = D3DVERTEX( D3DVECTOR(  size,  size,  size ), D3DVECTOR(  1, 0, 0 ), 1, 0 );	
	cube[35] = D3DVERTEX( D3DVECTOR(  size, -size,  size ), D3DVECTOR(  1, 0, 0 ), 1, 1 );
}

#endif