/* crap_mod.c - 
   Copyright (C) 2000 Tijs van Bakel and Jorik Blaas.
   Tijs van Bakel <smoke@casema.net>
   Jorik Blaas <jrk@panic.et.tudelft.nl>
 
 This file is part of INTRONAME
 
 CrapStation is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 CrapStation is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with CrapStation; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <stdlib.h>

#include "config.h"
#include "crap_mod.h"

int _fake_patterns;
int* _fake_pattern_lengths;

#ifdef HAVE_MIKMOD
#include <mikmod.h>
MODULE *_module;
#else
#include <sys/time.h>
#include <unistd.h>

#define PATTERN_DURATION 4000
struct timeval _start_time;

int
get_msec_passed ()
{
  struct timeval tv;
  long diff_sec;
  long diff_usec;
  long diff;
  
  gettimeofday(&tv,NULL);
  
  diff_sec = tv.tv_sec - _start_time.tv_sec;
  diff_usec = tv.tv_usec - _start_time.tv_usec;

  diff = diff_usec / 1000 + diff_sec * 1000;
  return diff;
}
#endif /* HAVE_MIKMOD */

void
crap_mod_update ()
{
#ifdef HAVE_MIKMOD      
  MikMod_Update();
#endif /* HAVE_MIKMOD */
}

int
crap_mod_init ( char* filename, int channels )
{
  _fake_patterns = 0;
  
#ifdef HAVE_MIKMOD
  
  /* set the dsp fragment size to something small */
  setenv("MM_FRAGSIZE","8",0);
  
  MikMod_RegisterAllDrivers();
  
  /* i register these by hand, since i don't need a music.raw, perhaps
  you want it, then just add it here and send me a note that there
  really are people who use it */
  
/*    MikMod_RegisterDriver ( &drv_AF ); */
/*    MikMod_RegisterDriver ( &drv_esd ); */
/*    MikMod_RegisterDriver ( &drv_alsa ); */
/*    MikMod_RegisterDriver ( &drv_oss ); */
/*    MikMod_RegisterDriver ( &drv_aix ); */
/*    MikMod_RegisterDriver ( &drv_hp ); */
/*    MikMod_RegisterDriver ( &drv_sam9407 ); */
/*    MikMod_RegisterDriver ( &drv_sgi ); */
/*    MikMod_RegisterDriver ( &drv_sun ); */
/*    MikMod_RegisterDriver ( &drv_ultra ); */
/*    MikMod_RegisterDriver ( &drv_stdout ); */
/*    MikMod_RegisterDriver ( &drv_nos ); */
  
  MikMod_RegisterAllLoaders();
  md_mode = DMODE_SOFT_MUSIC | DMODE_16BITS | DMODE_SOFT_SNDFX;
  md_reverb = 0;
  MikMod_Init("");
  md_mode = DMODE_SOFT_MUSIC | DMODE_16BITS | DMODE_SOFT_SNDFX;
  md_reverb = 0;
  _module = Player_Load( filename, channels, 0);
  if (!_module)
    return -1;
  _module->wrap = 1;
#else
  gettimeofday(&_start_time,NULL);
#endif /* HAVE_MIKMOD */
  return 0;
}

void
crap_mod_start_playing ()
{
#ifdef HAVE_MIKMOD
  Player_Start(_module);
#else
  gettimeofday(&_start_time,NULL);
#endif /* HAVE_MIKMOD */
}

void
crap_mod_fake_pattern_lengths ( int n_patterns, int* pattern_lengths )
{
  int i;
  
  _fake_pattern_lengths = malloc ( sizeof(int) * n_patterns );
  _fake_patterns = n_patterns;
  
  for ( i = 0; i < n_patterns; i++ )
    {
      _fake_pattern_lengths [ i ] = pattern_lengths [ i ];
    }
}

void
crap_mod_done ()
{
#ifdef HAVE_MIKMOD
  MikMod_Exit();
#endif /* HAVE_MIKMOD */
}

int
crap_mod_get_songpos ()
{
#ifdef HAVE_MIKMOD
  return _module->sngpos;
#else
  /* oh well - this is incorrect, but it's way too boring to handle it
     correctly.  you go ahead and code it the right way (taking
     fake_pattern_lengths into account.) */
  return ( get_msec_passed () / PATTERN_DURATION );
#endif /* HAVE_MIKMOD */
}

int
crap_mod_get_patpos ()
{
#ifndef HAVE_MIKMOD
  int pattern, pattern_length;
#endif
  
#ifdef HAVE_MIKMOD
  return _module->patpos;
#else
  /* oh well - this is incorrect, but it's way too boring to handle it
     correctly.  you go ahead and code it the right way (taking
     fake_pattern_lengths into account.) */
  pattern = crap_mod_get_songpos ();
  if ( _fake_patterns > pattern )
    pattern_length = _fake_pattern_lengths [ pattern ];
  else
    pattern_length = 64;
  return ( ( get_msec_passed() * pattern_length / PATTERN_DURATION ) % pattern_length );
#endif /* HAVE_MIKMOD */
}

void
crap_mod_set_volume ( int volume )
{
#ifdef HAVE_MIKMOD
  Player_SetVolume ( volume );
#endif /* HAVE_MIKMOD */
}
