#include "init.h"
#include "poni.h"

int frames=0;
int music;
int oldtimer;

bitmap *laalaa;
bitmap *jippu;

object *poni;

unsigned char *blurlookup;
unsigned char *wave1,*wave2,*wave3,*wave4,*plasmpal;

void init_jippu() {
    int i,j;
    blurlookup=(unsigned char *)halloc(9*256);
    for(i=0;i<9*256;i++) {
        j=i/9;
        if(j>255) j=255;
        blurlookup[i]=i/9;
    }
    wave1=(uchar *)halloc(256);
    wave2=(uchar *)halloc(256);
    wave3=(uchar *)halloc(256);
    wave4=(uchar *)halloc(256);
    for(i=0;i<256;i++) { // numerot on hatusta... no ei ihan, mut melkein
        wave1[i]=sin(3.1415*2*i/256)*32;
        wave2[i]=cos(3.1415*2*i/128)*32;
        wave3[i]=sin(3.1415*2*i/64)*64;
        wave4[i]=cos(3.1415*2*i/128)*64;
    }
    plasmpal=(uchar *)halloc(256);
    i=0;
    for(j=0;j<128;j++) {
        plasmpal[i++]=j*2;
    }
    for(j=0;j<128;j++) {
        plasmpal[i++]=255-j*2;
    }
    music=load_module("rapdance.xm");
    laalaa=load_raw_bitmap("laalaa.raw",188,400);
    poni=load_3d_object(poni_vertices,poni_faces);
    //laalaa=load_pcx_bitmap("laalaa.pcx"); // t bugaa
    jippu=load_raw_bitmap("jippu.raw",191,45);
    do_bitmap_mask(laalaa,0x00ff00ff);
}

void part0() {
    int x,y,xx,yy,i=0,t,fade=0,l=0;
    unsigned char j=0;
    blurstart=320+4;
    blursize=320*200-blurstart-320-4;
    clear(0);
    while(!kbhit()) {
        while(timer>oldtimer) {
            i++;
            j++;
            fade++;
            oldtimer++;
            if(kbhit()) break;
        }
        if(i>=638) break;
        while(fade>0) {
            l+=9; /* Juu, no ei jaksanu teh tt efektii asmille, kun t
                     oli vaikeeta teh jo c kielel (no mulle t oli!) */
                  /* Niin, ideahan on siin et on textuuri, joka ts
                     tapaukses on toi jippuponi teksti ja ruudulla menevt
                     x ja y koordinaatit menee 1 askelissa, mut tekstuurin
                     x ja y meneekin sinin ja kosinin mukaan niin et text_x on
                     cos(alotus + scr_x) ja text_y on sin(alotus+scr_y) tai
                     jotenkin tollein se menee, kato tosta alhaalta */
            for(y=0;y<200;y++) {
                yy=(y-70)+(sintab[(l+y)&255]>>12);
                if(yy>jippu->h-1) break;
                if(yy<0) continue;                
                for(x=0;x<320;x++) {
                    xx=(x-70)+(costab[(l+x)&255]>>12);
                    if(xx>jippu->w-1) break;
                    if(xx<0) continue;

                    t=screen[y*320+x];
                    t=t+jippu->data[yy*jippu->w+xx];
                    if(t>255) t=255;
                    screen[y*320+x]=t;
                }
            }
            //lilluva(l);
            blur();
            fade=fade-6;
            if(i<128) fadetoblack(255-(i*2));
            else if(i>510) fadetoblack((i-510)*2);
            else fadetoblack(30);
        }
        flip_screen();
        frames++;
    }    
}

void part1() {
    int i=0,blurs=0;
    clear(0);
    blurstart=40*320;
    blursize=(320*200)-blurstart-40*320;
    while(!kbhit()) {
        while(timer>oldtimer) {
            i++;
            blurs++;
            oldtimer++;
            if(kbhit()) break;
        }
        if(i>778) break;
        while(blurs>0) {
            if(i>0 && i<150) draw_string(whitefont,65,80,"KOOLI JA KLAFFA");
            if(i>125 && i<225) draw_string(redfont,135,100,"HIPPO");
            if(i>200 && i<300) draw_string(whitefont,115,80,"MUFIIKKI");
            if(i>275 && i<425) draw_string(redfont,40,100,"GABRIEL CENTAURION");
            if(i>550 && i<600) draw_string(whitefont,154,91,"3");
            if(i>600 && i<650) draw_string(whitefont,154,91,"2");
            if(i>650 && i<700) draw_string(whitefont,154,91,"1");
            if(i>700 && i<750) draw_string(whitefont,154,91,"0");

            fadetoblack(5);
            blur();
            blurs=blurs-10;
        }
        flip_screen();
        frames++;
    }
}

void part2() { // Laalaa
    int i=0,k=0;
    unsigned char j=0,a=0,b=0,l=0,m=0,t=0;
    while(!kbhit()) {
        while(timer>oldtimer) {
            i++;
            a++;
            b+=2;
            m++;
            if(k==0) j+=2;
            else j-=2;
            if(j>=253) k=1; /* Tll tavalla saadaan et ne pallot rauhottuu */
            if(j<=2) k=0;   /* ja sitten alkaa yhtkki riehumaan */
            oldtimer++;
            if(i>512) {
                l++;
            }
            t=b+j;
            if(kbhit()) break;
        }
        if(i>=767) break;
        cirkkeli(costab[t]>>8,0,j,
                 0,costab[t]>>8,j,
                 costab[b]>>8,sintab[b]>>8,j);
        draw_bitmap(laalaa,66+(costab[a]>>10),(sintab[b]>>8)-80);
        if(m>50 && i<512) {
            fadetowhite(192);
            if(m>60) m-=60;
        }
        if(i>=512) {
            fadetoblack(l);
        }
        flip_screen();
        frames++;
    }
}

void part3() {
    int i=0,j=0;
    blurstart=40*320;
    blursize=320*200-blurstart-40*320;
    while(!kbhit()) {
        while(timer>oldtimer) {
            i+=2;
            j++;
            oldtimer++;
            if(kbhit()) break;
        }
        if(i>=628) break;
        while(j>0) {
            /* plazma korvaa sinisen svyn "plasmalla" */
            if(i>125 && i<225) draw_string(whitefont,125,65,"KERMA");
            if(i>225 && i<325) draw_string(whitefont,145,90,"ON");
            if(i>325 && i<425) draw_string(whitefont,125,115,"HYV");
            blur();
            j=j-3;
        }
        plazma(i);
        if(i<128) fadetoblack(255-(i*2));
        else if(i>500) fadetoblack((i-500)*2);
        flip_screen();
        frames++;
    }
}

void part4() {
    int i=0,j=0;
    blurstart=320+4;
    blursize=320*200-blurstart-320-4;
    clear(0);
    while(!kbhit()) {
        while(timer>oldtimer) {
            i++;
            j++;
            oldtimer++;
            if(kbhit()) break;
        }
        if(i>=978) break;
        while(j>0) {
            if(i>125 && i<225) draw_string(greenfont,125,25,"MISS ON");
            if(i>225 && i<325) draw_string(greenfont,80,50,"UPEET GRAFFUT?");
            if(i>425 && i<525) draw_string(whitefont,10,75,"KUULEN YLEISN KYSYVN");
            if(i>625 && i<800) draw_string(redfont,80,125,"EI NIIT OLE");
            blur();
            j=j-4;
        }
        if(i<128) fadetoblack(255-(i*2));
        else if(i>850) fadetoblack((i-850)*2);
        flip_screen();
        frames++;
    }
}

void part5() {
    int i=0,j=0;
    blurstart=320+4;
    blursize=320*200-blurstart-320-4;
    clear(0);
    while(!kbhit()) {
        while(timer>oldtimer) {
            i++;
            j++;
            oldtimer++;
            if(kbhit()) break;
        }
        if(i>=528) break;
        while(j>0) {
            if(kbhit()) break;
            show_object(poni,160,100,20,i);
            draw_string(whitefont,10,170,"HIPPO 14 VEE");
            j=j-5;
            //blur(); /* Nytt paljon hienommalta ja paljon hitaampikin */
            if(i<128) fadetoblack(255-(i*2));
            else if(i>400) fadetoblack((i-400)*2);
            else fadetoblack(9);
        }
        flip_screen();
        frames++;
    }    
}

void part6() {
    int i=0,j=0;
    blurstart=320+4;
    blursize=320*200-blurstart-320-4;
    clear(0);
    while(!kbhit()) {
        while(timer>oldtimer) {
            i++;
            j++;
            oldtimer++;
            if(kbhit()) break;
        }
        if(i>=800) break;
        while(j>0) {
            if(i<150) draw_string(whitefont,60,10,"KREDUT JA MUUTA");
            if(i>100 && i<300) draw_string(greenfont,45,35,"SUUNNITTELUA HIPON");
            if(i>100 && i<300) draw_string(greenfont,15,55,"LISKS TEKI MYS SRKI");

            if(i>300 && i<500) draw_string(greenfont,20,75,"NIIN, NE KREDUT");
            if(i>450 && i<500) draw_string(redfont,150,100,"JAARU");
            if(i>475 && i<525) draw_string(whitefont,50,130,"WESGU");
            if(i>500 && i<550) draw_string(greenfont,90,110,"CHEESE");
            if(i>525 && i<575) draw_string(redfont,160,170,"HOKKANEN");
            if(i>550 && i<600) draw_string(whitefont,10,160,"HENZI");
            if(i>575 && i<625) draw_string(redfont,220,100,"KATI");
            if(i>600 && i<650) draw_string(greenfont,40,100,"DIPE");
            if(i>625 && i<675) draw_string(whitefont,150,80,"UT");
            if(i>650 && i<700) draw_string(redfont,150,120,"CN");
            if(i>675 && i<725) draw_string(greenfont,20,170,"IHMEMIEKKONE");
            if(i>700 && i<750) draw_string(whitefont,160,140,"HOMONOMIT");
            if(i>725 && i<775) draw_string(redfont,130,20,"PWP");
            if(i>750 && i<800) draw_string(whitefont,10,10,"MIN");
            if(i>775 && i<825) draw_string(greenfont,100,10,"SIN");
            blur();
            j=j-10;
            fadetoblack(2);
            if(i<128) fadetoblack(255-(i*2));
        }
        flip_screen();
        frames++;
    }    
}

void part7() {
    int i=0,j=0,x,y1,y2,t;
    unsigned char *buf=(char *)screen;
    stop_module(music);
    y1=1;
    y2=198;
    while(!kbhit()) {
        while(timer>oldtimer) {
            i++;
            j+=4;
            oldtimer++;
            if(kbhit()) break;
        }
        while(j>0) { /* Ei huvita teh assyl */
            if(y1<100) {
                for(x=0;x<320*4-1;x++) {
                    t=(int)buf[y1*320*4+x]+(int)buf[(y1-1)*320*4+x];
                    t+=5;
                    if(t>255) buf[y1*320*4+x]=255;
                    else buf[y1*320*4+x]=t;
                    buf[(y1-1)*320*4+x]=0;
                }
            }
            if(y2>100) {
                for(x=0;x<320*4-1;x++) {
                    t=(int)buf[y2*320*4+x]+(int)buf[(y2+1)*320*4+x];
                    t+=5;
                    if(t>255) buf[y2*320*4+x]=255;
                    else buf[y2*320*4+x]=t;
                    buf[(y2+1)*320*4+x]=0;
                }
            }
            y1++;
            y2--;
            j--;
        }
        if(i>=100/4) break;
        flip_screen();
        frames++;
    }    
}
