#include "init.h"

dword dosbuffer;
dword dosselector;
dword vesalfb_linear;
s_dword vesalfb_segment;
vesa_information *vesainfo;
vesa_mode_information modeinfo;

unsigned int scrsize=0,bpp=0,unused_bytes=0,scrw=320,scrh=200;
unsigned int *screen=0;
void (*flip_screen)();
void (*deinit_gfx)();

int vesa_inited=0;

void muumipeikko(){}

void init_gfx() {
    flip_screen=muumipeikko;
    deinit_gfx=muumipeikko;
}

void deinit_vesa() {
    __dpmi_free_dos_memory(dosselector);
    textmode(0x03);
    vesa_unmap_physical(&vesalfb_linear,&vesalfb_segment);
}

void set_gfx_mode() {
    vesa_init();
    if(bpp==0) {
        if(vesa_search_and_set_mode(320,200,32))
        if(vesa_search_and_set_mode(320,200,24))
        if(vesa_search_and_set_mode(320,200,16))
        if(set_vga_mode()) {        
            error(VESA_ERROR,"Can't set 320x200 (with 32/24/16/8 bpp) mode!\n");
        }
    } else if(bpp==8) { if(set_vga_mode()) error(VESA_ERROR,"Can't set 320x200x8 mode!\n"); }
    else if(bpp==16) { if(vesa_search_and_set_mode(320,200,16)) error(VESA_ERROR,"Can't set 320x200x16 mode!\n"); }
    else if(bpp==24) { if(vesa_search_and_set_mode(320,200,24)) error(VESA_ERROR,"Can't set 320x200x24 mode!\n"); }
    else if(bpp==32) { if(vesa_search_and_set_mode(320,200,32)) error(VESA_ERROR,"Can't set 320x200x32 mode!\n"); }
}

int vesa_int(byte function,__dpmi_regs *regs) {
    regs->h.ah=0x4F;
    regs->h.al=function;
    __dpmi_int(0x10, regs);
    if(regs->h.al != 0x4F) {
        return -1;
    }
    switch(regs->h.ah) {
        case 0: break;
        case 1: return 1;
        case 2: return 2;
        case 3: return 3;
        default: return 4;
    }
    return 0;
}

int vesa_init() {
    __dpmi_regs regs;
    if(!vesa_inited) {
        dosbuffer=(dword)__dpmi_allocate_dos_memory(64, (int *)&dosselector);
        if(dosbuffer==-1) return 1;
        dosbuffer*=16;
        vesainfo=(vesa_information *)malloc(sizeof(vesa_information));
        memcpy(vesainfo->sign,"VBE2",4);
        dosmemput(vesainfo, sizeof(vesa_information), dosbuffer);
        regs.x.es=dosbuffer/16;
        regs.x.di=0;
        if(vesa_int(0x00,&regs)) return 1;
        dosmemget(dosbuffer, sizeof(vesa_information), vesainfo);
        if(strnicmp(vesainfo->sign,"VESA",4)!=0||vesainfo->version<0x0200) return 1;
        vesa_inited=1;
    }
    return 0;
}

int vesa_map_physical(dword *linear,s_dword *segment,dword physaddr,dword size) {
    __dpmi_meminfo meminfo;
    meminfo.address=physaddr;
    meminfo.size=size;
    if(__dpmi_physical_address_mapping(&meminfo)!=0) return 1;
    linear[0]=meminfo.address;
    __dpmi_lock_linear_region(&meminfo);
    segment[0]=__dpmi_allocate_ldt_descriptors(1);
    if(segment[0]<0) {
        segment[0]=0;
        __dpmi_free_physical_address_mapping(&meminfo);
        return 1;
    }
    __dpmi_set_segment_base_address(segment[0], linear[0]);
    __dpmi_set_segment_limit(segment[0], size-1);
    return 0;
}


void vesa_unmap_physical(dword *linear, s_dword *segment) {
    __dpmi_meminfo meminfo;
    if(segment[0]) {
        __dpmi_free_ldt_descriptor(segment[0]);
        segment[0]=0;
    }
    if(linear[0]) {
        meminfo.address=linear[0];
        __dpmi_free_physical_address_mapping(&meminfo);
        linear[0]=0;
    }
}

int vesa_get_modeinfo(word mode) {
    __dpmi_regs regs;
    regs.x.cx=mode;
    regs.x.es=dosbuffer>>4;
    regs.x.di=0;
    if(vesa_int(0x01, &regs)) return 1;
    dosmemget(dosbuffer,sizeof(modeinfo),&modeinfo);
    return 0;
}

int vesa_set_mode(int mode) {
    __dpmi_regs regs;
    // Maxin takii tuli nyt tehty tollanen unused_bytes juttukin
    if(modeinfo.bpp==32) {
        flip_screen=vesa_flip_screen_32;
        unused_bytes=modeinfo.bpl-4*320;
    } else if(modeinfo.bpp==24) {
        flip_screen=vesa_flip_screen_24;
        unused_bytes=modeinfo.bpl-3*320;
    } else if(modeinfo.bpp==16) {
        flip_screen=vesa_flip_screen_16;
        unused_bytes=modeinfo.bpl-2*320;
    } else return 1;
    scrsize=320*200;
    screen=(unsigned int *)halloc(320*200*4);
    deinit_gfx=deinit_vesa;
    regs.x.bx=mode|MODEFLAG_LINEAR|MODEFLAG_CLEAR;
    if(vesa_int(0x02,&regs)) return 1;
    if(vesa_map_physical(&vesalfb_linear,&vesalfb_segment,modeinfo.physicalbaseptr,
                         modeinfo.bpl*modeinfo.height)) return 1;
    return 0;
}

int vesa_search_mode(int w,int h,int d) {
    s_word mode=0;    
    dword addr=LINEAR(vesainfo->videomodeptr);
    while(mode!=-1) {
        dosmemget(addr, 2, &mode);
        addr+=2;
        if(mode!=-1) {
            if(vesa_get_modeinfo(mode)) continue;
            if(modeinfo.linearavailable &&
               modeinfo.width==w &&
               modeinfo.height==h &&
               modeinfo.bpp==d) {
                return mode;
            }
        }
    }
    return -1;
}

int vesa_search_and_set_mode(int w,int h,int d) {
    int m;
    vesa_init();
    m=vesa_search_mode(w,h,d);
    if(m==-1) return 1;
    if(vesa_set_mode(m)) return 1;
    return 0;
}
