#include "init.h"

char *palette;
unsigned short dosds;

void init_vga() {
    if(palette==0) palette=(unsigned char *)halloc(768);
    dosds=_dos_ds;
}

int set_vga_mode() {
    int r,g,b,i=0;
    init_vga();
    screen=halloc(320*200*4);
    scrsize=320*200;
    for(r=0;r<8;r++) {
        for(g=0;g<8;g++) {
            for(b=0;b<4;b++) {
                palette[i++]=(unsigned char)(r/7.0f*63.0f);
                palette[i++]=(unsigned char)(g/7.0f*63.0f);
                palette[i++]=(unsigned char)(b/3.0f*63.0f);
            }
        }
    }
    textmode(0x13);
    set_vga_palette();
    deinit_gfx=deinit_vga;
    flip_screen=vga_flip_screen;
    return 0;
}

void deinit_vga() {
    textmode(0x3);
}

void set_vga_palette() {
    int i;
    outportb(0x3c8,0);
    for(i=0;i<768;i++) outportb(0x3c9,palette[i]);
}

void get_vga_palette() {
    int i;
    outportb(0x3c8,0);
    for(i=0;i<768;i++) palette[i]=inportb(0x3c7);
}
