/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import org.komplex.demo.GLObject;
import org.komplex.opengl.GL;
import org.komplex.opengl.GLJDirect;

public class OBJMesh
extends GLObject {
    BufferedReader br;
    Vector v = new Vector();
    Vector vt = new Vector();
    Vector vn = new Vector();
    Vector faces = new Vector();
    Vector3f[] vertices;
    float scale = 1.0f;
    Hashtable edges = new Hashtable();
    int s0 = 0;
    int s1 = 0;
    static final float PI2 = 1.5707964f;

    public void makeShadowVolume(GL gl, Vector3f light, float f2) {
        GLJDirect.glBegin(7);
        Enumeration e2 = this.edges.keys();
        while (e2.hasMoreElements()) {
            Edge d2 = (Edge)e2.nextElement();
            Vector3f v1 = d2.va;
            Vector3f v2 = d2.vb;
            GLJDirect.glColor4f(0.5f, 0.4f, 0.3f, f2);
            GL.glVertex3f(v2);
            GL.glVertex3f(v1);
            GLJDirect.glColor4f(0.4f, 0.2f, 0.17f, 0.0f);
            GL.glVertex3f(this.extend(light, v1, 1.5f));
            GL.glVertex3f(this.extend(light, v2, 1.5f));
        }
        GLJDirect.glEnd();
    }

    public void parse(InputStream is) throws IOException {
        this.parse(new BufferedReader(new InputStreamReader(is)));
    }

    public void parse(BufferedReader br) throws IOException {
        this.hoax();
        String line = null;
        block5: while ((line = br.readLine()) != null) {
            if (line.length() == 0) continue;
            StringTokenizer st = new StringTokenizer(line, " /");
            String key = st.nextToken();
            switch (key.charAt(0)) {
                case 'v': {
                    Vector3f a2 = this.readVector3f(st);
                    if (key.equals("v")) {
                        a2.scale(this.scale);
                        this.v.addElement(a2);
                        break;
                    }
                    if (key.equals("vt")) {
                        a2.y = 1.0f - a2.y;
                        this.vt.addElement(a2);
                        break;
                    }
                    if (!key.equals("vn")) continue block5;
                    this.vn.addElement(a2);
                    break;
                }
                case 'f': {
                    int i2 = 0;
                    while (i2 < 3) {
                        int fv = Integer.parseInt(st.nextToken());
                        int ft = Integer.parseInt(st.nextToken());
                        int fn = Integer.parseInt(st.nextToken());
                        int[] idx = new int[]{fv - 1, ft - 1, fn - 1};
                        this.faces.addElement(idx);
                        ++i2;
                    }
                    continue block5;
                }
                case '#': {
                    break;
                }
            }
        }
        this.vertices = new Vector3f[this.v.size()];
        this.v.copyInto(this.vertices);
        this.hoax();
        this.makeEdges();
        this.hoax();
    }

    Vector3f readVector3f(StringTokenizer st) {
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        int i2 = 0;
        x = Float.valueOf(st.nextToken()).floatValue();
        ++i2;
        y = Float.valueOf(st.nextToken()).floatValue();
        ++i2;
        if (st.hasMoreTokens()) {
            z = Float.valueOf(st.nextToken()).floatValue();
            ++i2;
        }
        return new Vector3f(x, y, z);
    }

    public void buildHalo(GL gl) {
    }

    public void addFace(Vector3f fn, int[][] eds) {
        int i2 = 0;
        while (i2 < eds.length) {
            Edge e2 = new Edge(eds[i2][0], eds[i2][1]);
            Edge e22 = (Edge)this.edges.get(e2);
            if (e22 != null) {
                e22.n2 = fn;
                ++this.s1;
            } else {
                e2.n = fn;
                e2.n2 = fn;
                this.edges.put(e2, e2);
                ++this.s0;
            }
            ++i2;
        }
    }

    public static void main(String[] args) throws Exception {
        OBJMesh obj = new OBJMesh();
        obj.parse(new BufferedInputStream(new FileInputStream("kuvrpa.obj")));
    }

    Vector3f extend(Vector3f light, Vector3f vertex, float t) {
        Vector3f delta = new Vector3f(vertex);
        delta.sub(light);
        delta.scale(t);
        delta.add(light);
        return delta;
    }

    void makeEdges() {
        boolean off = false;
        int i2 = 0;
        while (i2 < this.faces.size()) {
            int i1 = ((int[])this.faces.elementAt(i2))[0];
            int i22 = ((int[])this.faces.elementAt(i2 + 1))[0];
            int i3 = ((int[])this.faces.elementAt(i2 + 2))[0];
            Vector3f a2 = this.vertices[i1];
            Vector3f b2 = this.vertices[i22];
            Vector3f c2 = this.vertices[i3];
            Vector3f fn = new Vector3f(0.0f, 0.0f, 0.0f);
            fn.x = (b2.y - a2.y) * (c2.z - a2.z) - (c2.y - a2.y) * (b2.z - a2.z);
            fn.y = -((b2.x - a2.x) * (c2.z - a2.z) - (c2.x - a2.x) * (b2.z - a2.z));
            fn.z = (b2.x - a2.x) * (c2.y - a2.y) - (c2.x - a2.x) * (b2.y - a2.y);
            fn.normalize();
            int[][] eds = new int[][]{{i1, i22}, {i22, i3}, {i3, i1}};
            this.addFace(fn, eds);
            i2 += 3;
        }
        this.hoax();
        Enumeration e2 = this.edges.elements();
        while (e2.hasMoreElements()) {
            Edge d2 = (Edge)e2.nextElement();
            d2.va = this.vertices[d2.a];
            d2.vb = this.vertices[d2.b];
        }
    }

    public void buildObject(GL gl) {
        GLJDirect.glBegin(4);
        int i2 = 0;
        while (i2 < this.faces.size()) {
            int[] idx = (int[])this.faces.elementAt(i2);
            Vector3f av = (Vector3f)this.v.elementAt(idx[0]);
            Vector3f at = (Vector3f)this.vt.elementAt(idx[1]);
            Vector3f an = (Vector3f)this.vn.elementAt(idx[2]);
            GL.glNormal3f(an);
            if (at != null) {
                GLJDirect.glTexCoord2f(at.x, at.y);
            }
            GL.glVertex3f(av);
            ++i2;
        }
        GLJDirect.glEnd();
    }

    public void resetParse() {
        this.v = new Vector();
        this.vt = new Vector();
        this.vn = new Vector();
        this.faces = new Vector();
    }

    public void hoax() {
    }

    public void makeShadowVolume(GL gl, float f2) {
        float[] mat = new float[16];
        GLJDirect.glGetFloatv(2982, mat);
        Matrix4f m2 = new Matrix4f(mat);
        Vector3f light = new Vector3f(0.0f, 0.0f, -10.0f);
        m2.transform(light);
        this.makeShadowVolume(gl, light, f2);
    }

    class Edge {
        int a;
        int b;
        Vector3f n;
        Vector3f n2;
        Vector3f va;
        Vector3f vb;

        public Edge(int a2, int b2) {
            OBJMesh.this.getClass();
            if (a2 < b2) {
                this.a = a2;
                this.b = b2;
            } else {
                this.a = b2;
                this.b = a2;
            }
        }

        public int hashCode() {
            return this.a << 16 | this.b;
        }

        public boolean equals(Object o2) {
            return o2 instanceof Edge && o2.hashCode() == this.hashCode();
        }
    }
}

