/*
 * Decompiled with CFR 0.152.
 */
package org.komplex.audio;

import codecLib.mpa.Decoder;
import codecLib.mpa.FrameInfo;
import codecLib.mpa.MPAException;
import java.io.IOException;
import java.io.InputStream;
import org.komplex.audio.PullAudioSource;

public class MP3Decoder
implements PullAudioSource {
    static final int MAXPENDINGLEN = 5120;
    private int pendingLen;
    private static final int OUTSIZE = 16384;
    private byte[] pendingData;
    private Decoder decoder;
    private FrameInfo info;
    float[][] fsamp;
    int[] fsampOffset;
    int outFrameSize;
    int[] outBuf = new int[16384];
    int outOff = 0;
    int outLen = 0;
    InputStream is;
    Thread thread;

    public synchronized void close() {
        if (this.decoder != null) {
            this.decoder = null;
        }
        if (this.info != null) {
            this.info = null;
        }
    }

    public synchronized void reset() {
        if (this.decoder != null) {
            this.close();
            try {
                this.init();
            }
            catch (IOException rue) {
                System.err.println("MP3 Decoder: " + rue);
            }
        }
    }

    public void setInputStream(InputStream is) throws IOException, MPAException {
        this.is = is;
        this.decodeBuffers();
    }

    public MP3Decoder() throws IOException, MPAException {
        this.pendingData = new byte[4096];
        this.fsamp = new float[12][1152];
        this.fsampOffset = new int[12];
        this.init();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read(int[] buf, int off, int len) {
        int[] nArray = this.outBuf;
        synchronized (this.outBuf) {
            if (this.outLen < len) {
                System.out.println("*** underrun " + this.outOff + " " + this.outLen + " " + this.outBuf.length + " " + buf.length + ":" + off + " l " + len + " x" + this.is + "x");
                try {
                    this.outBuf.wait(50L);
                    return 0;
                }
                catch (InterruptedException e2) {
                    // empty catch block
                }
                return 0;
            }
            System.arraycopy(this.outBuf, this.outOff, buf, off, len);
            this.outOff += len;
            return len;
        }
    }

    public static void convert(int[] buf, int off, float[] left, int lo, float[] right, int ro, int len) {
        int i2 = 0;
        while (i2 < len) {
            int l2;
            l2 = (l2 = (int)left[lo++]) < Short.MAX_VALUE ? (l2 > Short.MIN_VALUE ? l2 : Short.MIN_VALUE) : Short.MAX_VALUE;
            int r2 = (int)right[ro++];
            r2 = r2 < Short.MAX_VALUE ? (r2 > Short.MIN_VALUE ? r2 : Short.MIN_VALUE) : Short.MAX_VALUE;
            buf[off++] = l2 & 0xFFFF | r2 << 16;
            ++i2;
        }
    }

    public static void main(String[] args) throws Exception {
    }

    public void start() {
        this.startDecodingThread();
    }

    public void fillBuffer(InputStream is) throws IOException {
        if (this.pendingLen > 5120) {
            return;
        }
        int c2 = is.read(this.pendingData, this.pendingLen, this.pendingData.length - this.pendingLen);
        if (c2 == -1) {
            is.close();
            is = null;
            return;
        }
        this.pendingLen += c2;
    }

    public int decodeBlock(int[] block, int offset) throws MPAException, IOException {
        if (this.pendingLen < 1024) {
            return 0;
        }
        int len = offset;
        int pendingOff = 0;
        int byteCount = 0;
        this.info = new FrameInfo();
        this.decoder.getNextFrameInfo(this.info, this.pendingData, pendingOff, this.pendingLen);
        byteCount = this.decoder.decode(this.fsamp, this.fsampOffset, this.pendingData, pendingOff, this.pendingLen);
        MP3Decoder.convert(block, len, this.fsamp[0], this.fsampOffset[0], this.fsamp[1], this.fsampOffset[1], this.info.getNumberOfSamples());
        len += this.info.getNumberOfSamples();
        this.pendingLen -= byteCount;
        if ((pendingOff += byteCount) != 0) {
            System.arraycopy(this.pendingData, pendingOff, this.pendingData, 0, this.pendingLen);
        }
        return len - offset;
    }

    public void init() throws IOException {
        try {
            this.decoder = new Decoder();
            this.pendingLen = 0;
            this.outLen = 0;
            this.outOff = 0;
            return;
        }
        catch (Throwable e2) {
            System.out.println("mpa mpa: open " + e2);
            throw new IOException("could not open " + this);
        }
    }

    private void startDecodingThread() {
        if (this.thread == null) {
            this.thread = new Thread(){
                {
                    MP3Decoder.this.getClass();
                }

                public void run() {
                    System.out.println("thread.run");
                    try {
                        while (MP3Decoder.this.is != null) {
                            MP3Decoder.this.decodeBuffers();
                            Thread.sleep(5L);
                        }
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    MP3Decoder.this.thread = null;
                }
            };
            this.thread.start();
            this.thread.setPriority(8);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void decodeBuffers() throws IOException, MPAException {
        int[] nArray = this.outBuf;
        synchronized (this.outBuf) {
            if (this.outOff != 0) {
                this.outLen -= this.outOff;
                if (this.outLen <= 0) {
                    this.outLen = 0;
                } else {
                    System.arraycopy(this.outBuf, this.outOff, this.outBuf, 0, this.outLen);
                }
                this.outOff = 0;
            }
            while (this.outLen < 8192) {
                int c2;
                if (this.is != null) {
                    this.fillBuffer(this.is);
                }
                if ((c2 = this.decodeBlock(this.outBuf, this.outLen)) <= 0) return;
                this.outLen += c2;
            }
            return;
        }
    }
}

