/*
 * Decompiled with CFR 0.152.
 */
package org.komplex.audio.device;

import com.ms.directX.DSBufferDesc;
import com.ms.directX.DSCaps;
import com.ms.directX.DSCursors;
import com.ms.directX.DirectSound;
import com.ms.directX.DirectSoundBuffer;
import com.ms.directX.DirectXConstants;
import com.ms.directX.WaveFormatEx;
import com.ms.win32.User32;
import java.awt.Component;
import java.awt.Frame;
import java.util.Dictionary;
import org.komplex.audio.AudioDataConverter;
import org.komplex.audio.AudioException;
import org.komplex.audio.AudioOutDevice;
import org.komplex.audio.BaseDevice;

public class DirectSoundDevice
extends BaseDevice
implements Runnable,
DirectXConstants,
AudioOutDevice {
    static final int BUFSIZE = 8192;
    Thread mixer = null;
    AudioDataConverter ac;
    private DirectSound ds;
    private DirectSoundBuffer dsBuffer;
    private DirectSoundBuffer dsBuffer_primary;
    private DSCaps dsCaps;
    DSCursors dsc = new DSCursors();
    int len = 8192 / this.splitAm;
    int splitAm = 8;
    int[] buffer;
    int[] bufferEmpty;
    byte[] buffer8;
    int lag = 40;
    Component component;
    int hWnd;

    public void stop() {
        this.mixer = null;
    }

    public void stopPlay() {
        if (this.dsBuffer_primary != null) {
            this.dsBuffer_primary.stop();
        }
        if (this.dsBuffer != null) {
            this.dsBuffer.stop();
        }
    }

    public void initDS() throws AudioException {
        this.ds = new DirectSound();
        int hWnd = this.getHWnd();
        if (hWnd != 0) {
            this.ds.setCooperativeLevel(hWnd, 2);
        } else {
            this.ds.setCooperativeLevel(this.getComponent(), 2);
        }
        WaveFormatEx wf = this.getWaveFormatEx();
        DSBufferDesc m_dsBufferDesc = null;
        try {
            m_dsBufferDesc = new DSBufferDesc();
            m_dsBufferDesc.flags = 1;
            m_dsBufferDesc.bufferBytes = 0;
            this.dsBuffer_primary = this.ds.createSoundBuffer(m_dsBufferDesc, null);
            this.dsBuffer_primary.setFormat(wf);
            this.dsCaps = new DSCaps();
            this.ds.getCaps(this.dsCaps);
            m_dsBufferDesc = new DSBufferDesc();
            m_dsBufferDesc.flags = 16384;
            m_dsBufferDesc.bufferBytes = this.buffer8.length;
            this.dsBuffer = this.ds.createSoundBuffer(m_dsBufferDesc, wf);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new AudioException("Primary buffer create/setFormat failed");
        }
    }

    public String toString() {
        return "DirectSound Audio Out";
    }

    public DirectSoundDevice() {
        this.setFormat(3696);
    }

    public int getHWnd() {
        if (this.hWnd != 0) {
            return this.hWnd;
        }
        try {
            int hWnd = User32.GetForegroundWindow();
            if (hWnd == 0) {
                hWnd = User32.GetDesktopWindow();
            }
            return hWnd;
        }
        catch (Exception e2) {
            return 0;
        }
    }

    public void copyBuffer(int pos) {
        int bytesPerSample = this.getSampleSize();
        this.dsBuffer.writeBuffer(pos * bytesPerSample * this.buffer.length, this.buffer.length * bytesPerSample, this.buffer8, 0);
    }

    public int getCurrentPosition() {
        this.dsBuffer.getCurrentPosition(this.dsc);
        return this.dsc.play;
    }

    public void play() {
        if (this.dsBuffer_primary != null) {
            this.dsBuffer_primary.play(1);
        }
        this.dsBuffer.play(1);
    }

    protected WaveFormatEx getWaveFormatEx() {
        WaveFormatEx wf = new WaveFormatEx();
        wf.bitsPerSample = this.getBits();
        wf.channels = this.getChannels();
        wf.blockAlign = this.getSampleSize();
        wf.samplesPerSec = this.getSampleRate();
        wf.avgBytesPerSec = this.getSampleRate() * this.getSampleSize();
        wf.formatTag = 1;
        wf.extra = null;
        wf.size = 0;
        return wf;
    }

    public Component getComponent() {
        if (this.component != null) {
            return this.component;
        }
        Frame cc = new Frame();
        ((Component)cc).setSize(64, 64);
        ((Component)cc).setVisible(true);
        ((Component)cc).validate();
        return cc;
    }

    void initMixingBuffers() {
        this.buffer = new int[this.len];
        this.bufferEmpty = new int[this.len];
        this.buffer8 = new byte[this.len * this.getSampleSize() * this.splitAm];
    }

    public void start() throws AudioException {
        if (this.mixer == null) {
            this.mixer = new Thread((Runnable)this, "Muhmu DirectSound device");
            this.mixer.start();
            this.mixer.setPriority(10);
        }
    }

    public void setProperties(Dictionary properties) {
        if (properties == null) {
            return;
        }
        Object o2 = properties.get("component");
        if (o2 instanceof Component) {
            this.component = (Component)o2;
        }
        if ((o2 = properties.get("hwnd")) instanceof Integer) {
            this.hWnd = (Integer)o2;
        }
    }

    public void run() {
        try {
            this.play();
            int bytesPerSample = this.getSampleSize();
            while (this.mixer != null) {
                int i2 = 0;
                while (i2 < this.splitAm) {
                    if (this.source != null) {
                        this.source.read(this.buffer, 0, this.buffer.length);
                        this.ac.convert(this.buffer, 0, this.buffer8, i2 * this.buffer.length * bytesPerSample, this.buffer.length);
                    }
                    int bufferPos = i2 * this.len;
                    int nextPos = (i2 + 1) * this.len;
                    while (this.mixer != null) {
                        int playPos = this.getCurrentPosition();
                        if (playPos > nextPos * bytesPerSample || playPos < bufferPos * bytesPerSample) break;
                        int time = (nextPos - playPos / bytesPerSample) * 1000 / this.getSampleRate();
                        if ((time += 5) < 5) {
                            time = 5;
                        }
                        Thread.sleep(time);
                    }
                    this.copyBuffer(i2);
                    ++i2;
                }
            }
            this.stopPlay();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void init(int n2) throws AudioException {
        try {
            this.setFormat(n2);
            this.initMixingBuffers();
            this.initDS();
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new AudioException(e2.toString());
        }
        this.ac = AudioDataConverter.getConverter(this.getFormat());
    }
}

