/*
 * Decompiled with CFR 0.152.
 */
package org.komplex.audio.device;

import java.io.InputStream;
import org.komplex.audio.AudioDataConverter;
import org.komplex.audio.AudioException;
import org.komplex.audio.BaseDevice;
import org.komplex.audio.PullAudioSource;
import sun.audio.AudioPlayer;

public class SunAudioDevice
extends BaseDevice {
    protected PullAudioSource source;
    AudioDataConverter ac;
    Input input = new Input();

    public void stop() {
        AudioPlayer.player.stop((InputStream)this.input);
    }

    public String toString() {
        return "JDK 1.1 sun.audio, Audio Out";
    }

    public int setFormat(int n2) {
        return super.setFormat(3731);
    }

    public void start() throws AudioException {
        if (this.source == null) {
            throw new AudioException("no audio source");
        }
        AudioPlayer.player.start((InputStream)this.input);
        AudioPlayer.player.setPriority(10);
    }

    public void init(int n2) throws AudioException {
        this.setFormat(n2);
        this.ac = AudioDataConverter.getConverter(this.getFormat());
    }

    public void setPullSource(PullAudioSource p2) {
        this.source = p2;
    }

    class Input
    extends InputStream {
        int[] buffer;

        Input() {
            SunAudioDevice.this.getClass();
        }

        public int read() {
            return 255;
        }

        public int read(byte[] buf, int off, int len) {
            if (SunAudioDevice.this.source == null) {
                return len;
            }
            if (this.buffer == null || this.buffer.length < len) {
                this.buffer = new int[len];
            }
            int total = 0;
            while (total < len) {
                int i2 = SunAudioDevice.this.source.read(this.buffer, 0, len - total);
                if (i2 <= 0) {
                    return i2;
                }
                SunAudioDevice.this.ac.convert(this.buffer, 0, buf, total + off, i2);
                total += i2;
            }
            return total;
        }
    }
}

