/*
 * Decompiled with CFR 0.152.
 */
package org.komplex.demo;

import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import org.komplex.demo.DemoPart;
import org.komplex.demo.DemoPartManager;
import org.komplex.jdirect.HiresTimer;
import org.komplex.opengl.GL;
import org.komplex.opengl.GLConstants;
import org.komplex.opengl.GLImage;
import org.komplex.opengl.GLJDirect;
import org.komplex.opengl.GLU;

public class GLPart
extends DemoPart
implements GLConstants {
    protected GL gl;
    protected GLU glu;
    protected DemoPartManager man;
    protected HiresTimer timer;

    public void getTexture(int id, String name, boolean wrap) {
        GLImage img0 = new GLImage(name);
        img0.waitForImage();
        GLJDirect.glBindTexture(3553, id);
        GLJDirect.glTexParameteri(3553, 10241, 9729);
        GLJDirect.glTexParameteri(3553, 10240, 9729);
        GLJDirect.glTexImage2D(3553, 0, 4, img0.getWidth(), img0.getHeight(), 0, img0.getFormat(), 5121, img0.getData());
        GLJDirect.glTexParameteri(3553, 10242, 10496);
        GLJDirect.glTexParameteri(3553, 10243, 10496);
        if (wrap) {
            GLJDirect.glTexParameteri(3553, 10242, 10497);
            GLJDirect.glTexParameteri(3553, 10243, 10497);
        }
    }

    public URL getResource(String name) {
        return this.getClass().getResource(name);
    }

    public void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void prepare(Hashtable hash) {
        this.gl = (GL)hash.get("gl");
        this.glu = (GLU)hash.get("glu");
        this.timer = (HiresTimer)hash.get("timer");
        this.man = (DemoPartManager)hash.get("manager");
        super.prepare(hash);
    }

    public InputStream getStream(String name) {
        return this.getClass().getResourceAsStream(name);
    }

    public void setProjMatrix(float fov) {
        int[] viewport = new int[4];
        GLJDirect.glMatrixMode(5889);
        GLJDirect.glLoadIdentity();
        GLJDirect.glGetIntegerv(2978, viewport);
        int x = viewport[0];
        int y = viewport[1];
        int w = viewport[2];
        int h2 = viewport[3];
        this.glu.gluPerspective(fov, 1.0 * (double)w / (double)h2, 0.3, 100.0);
        GLJDirect.glMatrixMode(5888);
    }

    public float since(double time, double tt) {
        return Math.max((float)time - (float)tt, 0.0f);
    }

    public void build2DMipmap(GLImage img) {
        GLJDirect.glTexImage2D(3553, 0, 4, img.getWidth(), img.getHeight(), 0, img.getFormat(), 5121, img.getData());
        int i2 = 1;
        while (i2 < 11) {
            if (img.getWidth() >> i2 > 0) {
                GLImage mip = img.createMipmap(i2);
                GLJDirect.glTexImage2D(3553, i2, 4, mip.getWidth(), mip.getHeight(), 0, mip.getFormat(), 5121, mip.getData());
            }
            ++i2;
        }
    }

    GLImage getTex(Hashtable hash, String n2) {
        GLImage tex0 = null;
        int[] pix = (int[])hash.get(n2);
        if (pix != null) {
            tex0 = new GLImage(512, 256, pix);
        }
        return tex0;
    }

    public boolean render(float t) {
        GLJDirect.glRotatef(10.0f, 1.0f, 0.0f, 0.0f);
        return true;
    }

    public float clamp1(double a2) {
        return Math.min(Math.max((float)a2, 0.0f), 1.0f);
    }

    void setTexScale(float x, float y) {
        GLJDirect.glMatrixMode(5890);
        GLJDirect.glLoadIdentity();
        GLJDirect.glScalef(x, y, 1.0f);
        GLJDirect.glMatrixMode(5888);
    }

    public void getTexture(int id, String name) {
        this.getTexture(id, name, false);
    }
}

