// AlphaLayer.h: interface for the CAlphaLayer class.
// coded by keus juin 2000
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_ALPHALAYER_H__EDF37F40_3972_11D4_B313_D404E6B7C271__INCLUDED_)
#define AFX_ALPHALAYER_H__EDF37F40_3972_11D4_B313_D404E6B7C271__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "export.h"

class CAlphaLayer  
{
	FILE *hFile;
	char debug[50];
	D3DVECTOR* ExploParam;
	D3DVERTEX* Exploded;

private:

	D3DVERTEX* FakeVertexBuffer;	
	D3DMATRIX  matRotate;


public:

	D3DVERTEX* Obj;
	char TextureFileName[260];

	int m_NbObjVertex;
	int m_NbObjFaces;
	LPDIRECT3DVERTEXBUFFER7 VertexBuffer;

// weird
	HRESULT ApplySphereMapToObject(LPDIRECT3DDEVICE7 pd3dDevice, D3DVERTEX* pvVertices, DWORD dwNumVertices );
	HRESULT ApplyMapToObject(LPDIRECT3DDEVICE7 pd3dDevice ,D3DVERTEX* pvVertices, DWORD dwNumVertices );



	CAlphaLayer();
	void Init(LPDIRECT3DDEVICE7 pd3dDevice,char *filename,bool VB);
	void MultiInit(LPDIRECT3DDEVICE7 pd3dDevice,char *filename,int num,bool VB);

	void LoadObject(char *name);
	void LoadObjectO(LPDIRECT3DDEVICE7 pd3dDevice,FILE* phFile, char *name);

	void Scale(float x,float y,float z);
	void SetRotate(float x,float y , float z);
	void SetRotateBuffer(float x,float y , float z);
	void SetTranslate(float x,float y , float z);

	void SRender(LPDIRECT3DDEVICE7 pd3dDevice);
	void Render(LPDIRECT3DDEVICE7 pd3dDevice, bool Alpha);
	void RenderVB(LPDIRECT3DDEVICE7 pd3dDevice, bool Alpha);
	void RenderVBRO(LPDIRECT3DDEVICE7 pd3dDevice, bool Alpha);

	HRESULT CreateVertexBuffer(LPDIRECT3DDEVICE7 pd3dDevice);
	void UpdateFVB(D3DVERTEX* Prout);
	void UpdateVB(D3DVERTEX* Prout);

	void InitExplosion();
	void DoExplosion(float fTimeKey, bool sens);

	void ApplyDisplacement(LPDIRECT3DDEVICE7 pd3dDevice, char* Filename);
	
	//void FrameMove();
	void Release();
	virtual ~CAlphaLayer();

};

#endif // !defined(AFX_ALPHALAYER_H__EDF37F40_3972_11D4_B313_D404E6B7C271__INCLUDED_)
