// LoadTLD.h: interface for the CLoadTLD class.
// coded by keus juin 2000
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_LOADTLD_H__1AC8F5E0_4F76_11D4_B313_B6A37AD01C72__INCLUDED_)
#define AFX_LOADTLD_H__1AC8F5E0_4F76_11D4_B313_B6A37AD01C72__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "export.h"
#include "texture.h"
#include "camera.h"
#include "TLDutils.h"
//#include "d3dtextr.h"
#include <tchar.h>
#include <stdio.h>

struct MatDef
{
	char name[20];
	char TextureFilename[260];
	bool Displacement;
	char DisplacementFilename[260];
};

struct Material
{
	char name[20];
	LPDIRECTDRAWSURFACE7 m_lpText;
	D3DMATERIAL7 m_mtrl;
	bool Alpha;
	bool Envmap;
};

class CLoadTLD
{
	FILE* mtrlFile;
	FILE* TextureFile;
	FILE* hFile;
public:
	CLoadTLD();
	virtual ~CLoadTLD();

	float fTimeDebut;
	float delta;
	CCamera Camera;
	bool CameraLoaded;
	bool Pause;
	int NbObj;

	Material* SceneMtrl;
	CAlphaLayer Scene[300];


	HRESULT Render( LPDIRECT3DDEVICE7 pd3dDevice );
	bool FrameMove(LPDIRECT3DDEVICE7 pd3dDevice, FLOAT fTimeKey);
	HRESULT Init(LPDIRECT3DDEVICE7 pd3dDevice, char* TLDFileName);
	void ReInit(LPDIRECT3DDEVICE7 pd3dDevice);
	void Release();

private:
	void LoadObjects(LPDIRECT3DDEVICE7 pd3dDevice,char *TLDFileName);
	void LoadMat(FILE* hFile,MatDef& Mat);

};


#endif // !defined(AFX_LOADTLD_H__1AC8F5E0_4F76_11D4_B313_B6A37AD01C72__INCLUDED_)
