// LogoTLD.cpp: implementation of the CLogoTLD class.
// coded by keus  & captainfr 09/07/2000 at party place
//////////////////////////////////////////////////////////////////////

#include "LogoTLD.h"
#include "Sprite3d.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CLogoTLD::CLogoTLD()
{

}

CLogoTLD::~CLogoTLD()
{

}


HRESULT CLogoTLD::Init(LPDIRECT3DDEVICE7 pd3dDevice)
{
	AnimLogo.Init(pd3dDevice,"logo_tld.tld");

	AnimLogo.Scene[6].InitExplosion();

	
	return S_OK;
}

bool CLogoTLD::FrameMove(LPDIRECT3DDEVICE7 pd3dDevice, float fTimeKey)
{

	delta = fTimeKey - fFirstTimeKey;


	AnimLogo.FrameMove(pd3dDevice,fTimeKey);


	if(delta > 20.0f)
		return TRUE;

	return FALSE;
}

HRESULT CLogoTLD::Render(LPDIRECT3DDEVICE7 pd3dDevice)
{
	if(delta < 19)
		AnimLogo.Render(pd3dDevice);
	
	return S_OK;
}

void CLogoTLD::ReInit(LPDIRECT3DDEVICE7 pd3dDevice)
{
    // Turn on fog
    FLOAT fFogStart =  700.0f;
    FLOAT fFogEnd   = 1000.0f;
    pd3dDevice->SetRenderState( D3DRENDERSTATE_FOGENABLE,    TRUE );
    pd3dDevice->SetRenderState( D3DRENDERSTATE_FOGCOLOR, D3DRGB(0.4f,0.4f,0.9f));
    pd3dDevice->SetRenderState( D3DRENDERSTATE_FOGTABLEMODE, D3DFOG_NONE );
    pd3dDevice->SetRenderState( D3DRENDERSTATE_FOGVERTEXMODE,  D3DFOG_LINEAR );
    pd3dDevice->SetRenderState( D3DRENDERSTATE_FOGSTART, *((DWORD *)(&fFogStart)) );
    pd3dDevice->SetRenderState( D3DRENDERSTATE_FOGEND,   *((DWORD *)(&fFogEnd)) );

	AnimLogo.ReInit(pd3dDevice);
	fFirstTimeKey = timeGetTime() * 0.001f;
	D3DMATRIX matProj;
	D3DUtil_SetProjectionMatrix(matProj, float(43.4558*(3.1415/180)), 800/600, 1.01f, 200000.0f);
    pd3dDevice->SetTransform( D3DTRANSFORMSTATE_PROJECTION, &matProj );

}