//-------------------------------------------------------------------------------
// Winmain.cpp
// main file of the prog, window initialisation, DDRAW & D3D init
// most of the D3D init code was ripped on Microsoft's DirectX SDK
//-------------------------------------------------------------------------------

#define STRICT
#include <windows.h>
#include <mmsystem.h>
#include <stdio.h>
#include <d3d.h>
#include "resource.h"
#include "export.h"

#include "easybass.h"
#pragma comment(lib,"bass.lib")


LPDIRECTDRAW7        g_pDD            = NULL;
LPDIRECTDRAWSURFACE7 g_pddsPrimary    = NULL;
LPDIRECTDRAWSURFACE7 g_pddsBackBuffer = NULL;
LPDIRECTDRAWSURFACE7 g_pddsZBuffer    = NULL;
LPDIRECT3D7          g_pD3D           = NULL;
LPDIRECT3DDEVICE7    g_pd3dDevice     = NULL;
RECT                 g_rcScreenRect;
HWND                 g_hWnd;
bool Quitter = FALSE;

int Width,Height;


float fTemps1,fTemps,delta;

//-----------------------------------------------------------------------------
// Globals var rulez !!
//-----------------------------------------------------------------------------
BOOL g_bActive   = FALSE; // Whether the app is active (not minimized)
BOOL g_bReady    = FALSE; // Whether the app is ready to render frames
BOOL g_bWindowed = TRUE;


HRESULT CALLBACK WndProc( HWND, UINT, WPARAM, LPARAM );
HRESULT Initialize3DEnvironment( HWND );
HRESULT Cleanup3DEnvironment();
HRESULT Render3DEnvironment();
VOID    OnMove( INT, INT );
HRESULT ShowFrame();
HRESULT RestoreSurfaces();


//-----------------------------------------------------------------------------
// External function-prototypes
//-----------------------------------------------------------------------------
VOID    App_DeleteDeviceObjects( LPDIRECT3DDEVICE7 );
void    App_FinalCleanUp();
HRESULT App_InitDeviceObjects( LPDIRECT3DDEVICE7);
HRESULT App_FrameMove( LPDIRECT3DDEVICE7, FLOAT );
HRESULT App_Render( LPDIRECT3DDEVICE7 );

int DrawText(char *text, int x,int y,int color, LPDIRECTDRAWSURFACE7 lpdds);

// klang framerate func
void InitFrameCount();
void IncFrameCount();
char *GetFrameRate();


//-----------------------------------------------------------------------------
// Name: WinMain()
// Desc: Entry point to the program. Initializes everything, and goes into a
//       message-processing loop. Idle time is used to render the scene.
//-----------------------------------------------------------------------------
INT WINAPI WinMain( HINSTANCE hInst, HINSTANCE, LPSTR strCmdLine, INT )
{
	
	// Register the window class
    WNDCLASS wndClass = { CS_HREDRAW | CS_VREDRAW, WndProc, 0, 0, hInst,
                          LoadIcon( hInst, MAKEINTRESOURCE(IDI_MAIN_ICON)),
                          LoadCursor(NULL, IDC_ARROW), 
                          (HBRUSH)GetStockObject(WHITE_BRUSH), NULL,
                          TEXT("Render Window") };
    RegisterClass( &wndClass );

    g_hWnd = CreateWindow( TEXT("Render Window"),
	                       TEXT("FIRST DREAM"),
                           NULL,//WS_OVERLAPPEDWINDOW, 
						   CW_USEDEFAULT,
                           CW_USEDEFAULT, 400, 400, 0L, 0L, hInst, 0L );

    // Load keyboard accelerators
    HACCEL hAccel = LoadAccelerators( hInst, MAKEINTRESOURCE(IDR_MAIN_ACCEL) );

	if( -1 == UserDlgSelectDriver( g_hWnd ) )
		return 0;

    ShowWindow( g_hWnd, SW_SHOWNORMAL );
    UpdateWindow( g_hWnd );

	
	if (Quitter == FALSE )
	{
		if( FAILED( Initialize3DEnvironment( g_hWnd ) ) )
		    return 0;
	}

	fTemps1 = timeGetTime() * 0.001f;

	BOOL bGotMsg;
	MSG  msg;
	PeekMessage( &msg, NULL, 0U, 0U, PM_NOREMOVE );
	g_bReady = TRUE;

    while( WM_QUIT != msg.message  )
    {

		fTemps = timeGetTime() * 0.001f;
		delta = fTemps - fTemps1;
		if (delta > 180)
			Quitter = TRUE;

		if (Touche(VK_ESCAPE))
			Quitter = TRUE;
		
		if (Quitter == TRUE)
		{
			Cleanup3DEnvironment();
			DestroyWindow( g_hWnd );
		}

		// Use PeekMessage() if the app is active, so we can use idle time to
		// render the scene. Else, use GetMessage() to avoid eating CPU time.
		if( g_bActive )
			bGotMsg = PeekMessage( &msg, NULL, 0U, 0U, PM_REMOVE );
		else
			bGotMsg = GetMessage( &msg, NULL, 0U, 0U );

		if( bGotMsg )
        {
			// Translate and dispatch the message
            if( 0 == TranslateAccelerator( g_hWnd, hAccel, &msg ) )
			{
				TranslateMessage( &msg );
				DispatchMessage( &msg );
			}
        }
		else
		{
			// Render a frame during idle time (no messages are waiting)
			if( g_bActive && g_bReady )
				Render3DEnvironment();
		}
    }
	return msg.wParam;
}



LRESULT CALLBACK WndProc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam )
{
    switch( uMsg )
    {
        case WM_PAINT:
			ShowFrame();
            break;

        case WM_MOVE:
            if( g_bActive && g_bReady )
				OnMove( (SHORT)LOWORD(lParam), (SHORT)HIWORD(lParam) );
            break;

        case WM_SIZE:
            if( SIZE_MAXHIDE==wParam || SIZE_MINIMIZED==wParam )
                g_bActive = FALSE;
			else g_bActive = TRUE;

            if( g_bActive && g_bReady )
			{
				g_bReady = FALSE;

				//if( FAILED( Cleanup3DEnvironment() ) )
				//	DestroyWindow( hWnd );

				//if( FAILED( Initialize3DEnvironment( hWnd) ) )
				//	DestroyWindow( hWnd );
				
				g_bReady = TRUE;
			}
            break;

		case WM_GETMINMAXINFO:
			((MINMAXINFO*)lParam)->ptMinTrackSize.x = 100;
			((MINMAXINFO*)lParam)->ptMinTrackSize.y = 100;
			break;

        case WM_SETCURSOR:
			// We turn the cursor off for fullscreen modes
            if( g_bActive && g_bReady && (!g_bWindowed) )
            {
                SetCursor(NULL);
                return TRUE;
            }
            break;

        case WM_CLOSE:
			Cleanup3DEnvironment();
            DestroyWindow( hWnd );
            return 0;
        
        case WM_DESTROY:
            Cleanup3DEnvironment();
            PostQuitMessage(0);
            return 0L;
    }

    return DefWindowProc( hWnd, uMsg, wParam, lParam );
}
            

//-----------------------------------------------------------------------------
// Name: EnumZBufferCallback()
// Desc: Enumeration function to report valid pixel formats for z-buffers.
//-----------------------------------------------------------------------------
static HRESULT WINAPI EnumZBufferCallback( DDPIXELFORMAT* pddpf,
                                           VOID* pddpfDesired )
{
	// For this tutorial, we are only interested in z-buffers, so ignore any
	// other formats (e.g. DDPF_STENCILBUFFER) that get enumerated. An app
	// could also check the depth of the z-buffer (16-bit, etc,) and make a
	// choice based on that, as well. For this tutorial, we'll take the first
	// one we get.
    if( pddpf->dwFlags == DDPF_ZBUFFER )
    {
        memcpy( pddpfDesired, pddpf, sizeof(DDPIXELFORMAT) );

        // Return with D3DENUMRET_CANCEL to end the search.
		return D3DENUMRET_CANCEL;
    }

    // Return with D3DENUMRET_OK to continue the search.
    return D3DENUMRET_OK;
}




//-----------------------------------------------------------------------------
// Name: Initialize3DEnvironment()
// Desc: This function initializes all the DirectDraw/Direct3D objects used for
//       3D-rendering.
//-----------------------------------------------------------------------------
HRESULT Initialize3DEnvironment( HWND hWnd )
{
	HRESULT hr;

	// Get info about the currently selected driver and device. This info is
	// from driver/device/mode enumeration.
	GUID*           pDriverGUID;
	GUID*           pDeviceGUID;
	DDSURFACEDESC2* pMode;
	BOOL            bUsing3DHardware;
	GetSelectedDriver( &pDriverGUID, &pDeviceGUID, &pMode, &g_bWindowed,
		               &bUsing3DHardware );

	// Create the IDirectDraw interface. The first parameter is the GUID,
	// which is allowed to be NULL. If there are more than one DirectDraw
	// drivers on the system, a NULL guid requests the primary driver. For 
	// non-GDI hardware cards like the 3DFX and PowerVR, the guid would need
	// to be explicity specified . (Note: these guids are normally obtained
	// from enumeration, which is convered in a subsequent tutorial.)
	hr = DirectDrawCreateEx( pDriverGUID, (VOID**)&g_pDD, IID_IDirectDraw7, 
		                     NULL );
	if( FAILED( hr ) )
		return hr;

    // Query DirectDraw for access to Direct3D
    g_pDD->QueryInterface( IID_IDirect3D7, (VOID**)&g_pD3D );
    if( FAILED( hr) )
		return hr;


    // Set the Windows cooperative level. This is where we tell the system
	// whether wew will be rendering in fullscreen mode or in a window. Note
	// that some hardware (non-GDI) may not be able to render into a window.
	// The flag DDSCL_NORMAL specifies windowed mode. Using fullscreen mode
	// is the topic of a subsequent tutorial. The DDSCL_FPUSETUP flag is a 
	// hint to DirectX to optomize floating points calculations. See the docs
	// for more info on this. Note: this call could fail if another application
	// already controls a fullscreen, exclusive mode.
	if( g_bWindowed )
		hr = g_pDD->SetCooperativeLevel( hWnd, DDSCL_NORMAL );
	else
		hr = g_pDD->SetCooperativeLevel( hWnd, DDSCL_FULLSCREEN|DDSCL_EXCLUSIVE );
	if( FAILED( hr ) )
		return hr;

	// If fullscreen, we need to set the display mode
	if( FALSE == g_bWindowed )
	{
		hr = g_pDD->SetDisplayMode( pMode->dwWidth, pMode->dwHeight,
			                        pMode->ddpfPixelFormat.dwRGBBitCount,
								    pMode->dwRefreshRate, 0L );
		if( FAILED( hr ) )
			return hr;
	}
    
	if (pMode->dwWidth == 0 ) Width = 300;

	// Initialize a surface description structure for the primary surface. The
	// primary surface represents the entire display, with dimensions and a
	// pixel format of the display. Therefore, none of that information needs
	// to be specified in order to create the primary surface.
	DDSURFACEDESC2 ddsd;
	ZeroMemory( &ddsd, sizeof(DDSURFACEDESC2) );
	ddsd.dwSize = sizeof(DDSURFACEDESC2);

	if( g_bWindowed )
	{
		ddsd.dwFlags        = DDSD_CAPS;
		ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE;
	}
	else
	{
		ddsd.dwFlags           = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
		ddsd.ddsCaps.dwCaps    = DDSCAPS_PRIMARYSURFACE | DDSCAPS_FLIP | 
			                     DDSCAPS_COMPLEX | DDSCAPS_3DDEVICE;
		ddsd.dwBackBufferCount = 1;
	}

	// Create the primary surface.
	hr = g_pDD->CreateSurface( &ddsd, &g_pddsPrimary, NULL );
	if( FAILED( hr ) )
		return hr;

	if( g_bWindowed )
	{
		// Create a clipper object which handles all our clipping for cases when
		// our window is partially obscured by other windows. This is not needed
		// for apps running in fullscreen mode.
		LPDIRECTDRAWCLIPPER pcClipper;
		hr = g_pDD->CreateClipper( 0, &pcClipper, NULL );
		if( FAILED( hr ) )
			return hr;

		// Associate the clipper with our window. Note that, afterwards, the
		// clipper is internally referenced by the primary surface, so it is safe
		// to release our local reference to it.
		pcClipper->SetHWnd( 0, hWnd );
		g_pddsPrimary->SetClipper( pcClipper );
		pcClipper->Release();
	}

	if( g_bWindowed )
	{
		// Setup a surface description to create a backbuffer. This is an
		// offscreen plain surface with dimensions equal to our window size.
		// The DDSCAPS_3DDEVICE is needed so we can later query this surface
		// for an IDirect3DDevice interface.
		ddsd.dwFlags        = DDSD_WIDTH | DDSD_HEIGHT | DDSD_CAPS;
		ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN | DDSCAPS_3DDEVICE;

		// Set the dimensions of the backbuffer. Note that if our window changes
		// size, we need to destroy this surface and create a new one.
		GetClientRect( hWnd, &g_rcScreenRect );
		ClientToScreen( hWnd, (POINT*)&g_rcScreenRect.left );
		ClientToScreen( hWnd, (POINT*)&g_rcScreenRect.right );
		ddsd.dwWidth  = g_rcScreenRect.right - g_rcScreenRect.left;
		ddsd.dwHeight = g_rcScreenRect.bottom - g_rcScreenRect.top;

		// Create the backbuffer. The most likely reason for failure is running
		// out of video memory. (A more sophisticated app should handle this.)
		hr = g_pDD->CreateSurface( &ddsd, &g_pddsBackBuffer, NULL );
		if( FAILED( hr ) )
			return hr;
	}
	else
	{
		SetRect( &g_rcScreenRect, 0, 0, pMode->dwWidth, pMode->dwHeight );

		// Get a ptr to the back buffer, which will be our render target
	    DDSCAPS2 ddscaps = { DDSCAPS_BACKBUFFER, 0, 0, 0 };
		hr = g_pddsPrimary->GetAttachedSurface( &ddscaps, &g_pddsBackBuffer );
		if( FAILED( hr ) )
			return hr;
	}

	// Enumerate possible formats for the z-buffer
	DDPIXELFORMAT ddpfZBuffer;
	g_pD3D->EnumZBufferFormats( *pDeviceGUID, EnumZBufferCallback, 
		                        (VOID*)&ddpfZBuffer );

	// If we found a good zbuffer format, then the dwSize field will be
	// properly set during enumeration. Else, we have a problem and will exit.
    if( sizeof(DDPIXELFORMAT) != ddpfZBuffer.dwSize )
        return E_FAIL;

    // Get z-buffer dimensions from the render target
    // Setup the surface desc for the z-buffer.
    ddsd.dwFlags        = DDSD_CAPS|DDSD_WIDTH|DDSD_HEIGHT|DDSD_PIXELFORMAT;
    ddsd.ddsCaps.dwCaps = DDSCAPS_ZBUFFER;
	ddsd.dwWidth        = g_rcScreenRect.right - g_rcScreenRect.left;
	ddsd.dwHeight       = g_rcScreenRect.bottom - g_rcScreenRect.top;
    memcpy( &ddsd.ddpfPixelFormat, &ddpfZBuffer, sizeof(DDPIXELFORMAT) );

	// For hardware devices, the z-buffer should be in video memory. For
	// software device, create the z-buffer in system memory
	/*if( IsEqualIID( *pDeviceGUID, IID_IDirect3DHALDevice ) )
		ddsd.ddsCaps.dwCaps |= DDSCAPS_VIDEOMEMORY;
	if( IsEqualIID( *pDeviceGUID, IID_IDirect3DTnLHalDevice) )
		ddsd.ddsCaps.dwCaps |= DDSCAPS_VIDEOMEMORY;
	else
		ddsd.ddsCaps.dwCaps |= DDSCAPS_SYSTEMMEMORY;*/
	if (!bUsing3DHardware)
		ddsd.ddsCaps.dwCaps |= DDSCAPS_SYSTEMMEMORY;

    // Create and attach a z-buffer. Real apps should be able to handle an
	// error here (DDERR_OUTOFVIDEOMEMORY may be encountered). For this 
	// tutorial, though, we are simply going to exit ungracefully.
    if( FAILED( hr = g_pDD->CreateSurface( &ddsd, &g_pddsZBuffer, NULL ) ) )
		return hr;

	// Attach the z-buffer to the back buffer.
    if( FAILED( hr = g_pddsBackBuffer->AddAttachedSurface( g_pddsZBuffer ) ) )
		return hr;

	// Before creating the device, check that we are NOT in a palettized
	// display. That case will cause CreateDevice() to fail, since this simple 
	// tutorial does not bother with palettes.
	ddsd.dwSize = sizeof(DDSURFACEDESC2);
	g_pDD->GetDisplayMode( &ddsd );
	if( ddsd.ddpfPixelFormat.dwRGBBitCount <= 8 )
		return DDERR_INVALIDMODE;

	// Create the device. The device is created off of our back buffer, which
	// becomes the render target for the newly created device. Note that the
	// z-buffer must be created BEFORE the device
    if( FAILED( hr = g_pD3D->CreateDevice( *pDeviceGUID,
		                                   g_pddsBackBuffer,
                                           &g_pd3dDevice ) ) )
	{
		// This call could fail for many reasons. The most likely cause is
		// that we specifically requested a hardware device, without knowing
		// whether there is even a 3D card installed in the system. Another
		// possibility is the hardware is incompatible with the current display
		// mode (the correct implementation would use enumeration for this.)
		return hr;
	}
		
    // Create the viewport
	DWORD dwRenderWidth  = g_rcScreenRect.right - g_rcScreenRect.left;
	DWORD dwRenderHeight = g_rcScreenRect.bottom - g_rcScreenRect.top;
	D3DVIEWPORT7 vp = { 0, 0, dwRenderWidth, dwRenderHeight, 0.0f, 1.0f };
    hr = g_pd3dDevice->SetViewport( &vp );
	if( FAILED( hr ) )
		return hr;

	// Finish by setting up our scene
	InitFrameCount();
	return App_InitDeviceObjects( g_pd3dDevice );
}




//-----------------------------------------------------------------------------
// Name: Cleanup3DEnvironment()
// Desc: Releases all the resources used by the app. Note the check for
//       reference counts when releasing the D3DDevice and DDraw objects. If
//       these ref counts are non-zero, then something was not cleaned up
//       correctly.
//-----------------------------------------------------------------------------
HRESULT Cleanup3DEnvironment()
{
	// Cleanup any objects created for the scene
	App_DeleteDeviceObjects( g_pd3dDevice );
	App_FinalCleanUp();

	// Release the DDraw and D3D objects used by the app. Note: if the app
	// was sloppy, and didn't release all references to an object, then
	// unpredictable results may follow.
    if( g_pddsZBuffer )    g_pddsZBuffer->Release();
    if( g_pd3dDevice )     g_pd3dDevice->Release();
	if( g_pddsBackBuffer ) g_pddsBackBuffer->Release();
	if( g_pddsPrimary )    g_pddsPrimary->Release();
	if( g_pD3D )           g_pD3D->Release();
	if( g_pDD )            g_pDD->Release();

    g_pddsZBuffer    = NULL;
	g_pd3dDevice     = NULL;
	g_pD3D           = NULL;
	g_pddsBackBuffer = NULL;
	g_pddsPrimary    = NULL;
	g_pDD            = NULL;

	return S_OK;
}




//-----------------------------------------------------------------------------
// Name: Render3DEnvironment()
// Desc: Draws the scene. There are three steps here:
//       (1) Animate the scene
//       (2) Render the scene
//       (3) Show the frame (copy backbuffer contents to the primary).
//-----------------------------------------------------------------------------
HRESULT Render3DEnvironment()
{
	// Call the app specific function to framemove (animate) the scene
	// Check the cooperative level before rendering
	if( FAILED( g_pDD->TestCooperativeLevel() ) )
		return S_OK;

	// FrameMove (animate) the scene
	if( FAILED( App_FrameMove( g_pd3dDevice, timeGetTime() * 0.001f ) ) )
		return E_FAIL;

    // Call the app specific function to render the scene
    App_Render( g_pd3dDevice  );

	IncFrameCount();

    // Show the frame on the primary surface. Note: this is the best place to
	// check for "lost" surfaces. Surfaces can be lost if something caused
	// them to temporary lose their video memory. "Lost" surfaces simply
	// need to be restored before continuing.
    if( DDERR_SURFACELOST == ShowFrame() )
		RestoreSurfaces();

    return S_OK;
}




//-----------------------------------------------------------------------------
// Name: ShowFrame()
// Desc: Show the frame on the primary surface
//-----------------------------------------------------------------------------
HRESULT ShowFrame()
{
	if( NULL == g_pddsPrimary )
		return E_FAIL;
	
	//char *fps;
	//fps = GetFrameRate();
	//DrawText(fps,1,1,0,g_pddsBackBuffer);
	//delete [] fps;
	
    // If we are in windowed mode, so perform a blit from the backbuffer to the
	// correct position on the primary surface
    if( g_bWindowed )
	{
        g_pDD->WaitForVerticalBlank(DDWAITVB_BLOCKEND , NULL);
	    return g_pddsPrimary->Blt( &g_rcScreenRect, g_pddsBackBuffer, 
                                   NULL, DDBLT_WAIT, NULL );
	}

    // Else, we are in fullscreen mode perform a flip.
    //return g_pddsPrimary->Flip( NULL, DDFLIP_WAIT );
	return g_pddsPrimary->Flip( NULL, DDFLIP_DONOTWAIT );//DDFLIP_NOVSYNC
}




//-----------------------------------------------------------------------------
// Name: RestoreSurfaces()
// Desc: Checks for lost surfaces and restores them if lost.
//-----------------------------------------------------------------------------
HRESULT RestoreSurfaces()
{
    // Check/restore the primary surface
    if( g_pddsPrimary )
        if( g_pddsPrimary->IsLost() )
            g_pddsPrimary->Restore();
    
    // Check/restore the back buffer
    if( g_pddsBackBuffer )
        if( g_pddsBackBuffer->IsLost() )
            g_pddsBackBuffer->Restore();

    // Check/restore the z-buffer
    if( g_pddsZBuffer )
        if( g_pddsZBuffer->IsLost() )
            g_pddsZBuffer->Restore();

    return S_OK;
}




//-----------------------------------------------------------------------------
// Name: OnMove()
// Desc: Moves the screen rect for windowed renderers
//-----------------------------------------------------------------------------
VOID OnMove( INT x, INT y )
{
	DWORD dwWidth  = g_rcScreenRect.right - g_rcScreenRect.left;
	DWORD dwHeight = g_rcScreenRect.bottom - g_rcScreenRect.top;
    SetRect( &g_rcScreenRect, x, y, x + dwWidth, y + dwHeight );
}



///////////////////
// write text for fps
int DrawText(char *text, int x,int y,int color, LPDIRECTDRAWSURFACE7 lpdds)
{
	HDC xdc; // the working dc
	HRESULT hRet;
	hRet = lpdds->GetDC(&xdc);
	if (hRet != DD_OK)
		return(0);
	SetTextColor(xdc,RGB(255,255,255));
	SetBkMode(xdc, TRANSPARENT);
	TextOut(xdc,x,y,text,strlen(text));
	lpdds->ReleaseDC(xdc);

	return(1);
}


