// Volcanic.h: interface for the CVolcanic class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_VOLCANIC_H__5AFD9321_807E_11D5_AD0F_206457C12026__INCLUDED_)
#define AFX_VOLCANIC_H__5AFD9321_807E_11D5_AD0F_206457C12026__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CVolcanic : public CEfx  
{
private:
	
	he3d_CScene				scene;

	CParticleSystem			m_psSystem;
	CPointEmiter			m_peEmiter[20];		

	CParticleSystem			m_psSmokeSystem;
	CPointEmiter			m_peSmokeEmiter[5];

	CParticleSystem			m_psMeteorSystem;
	CPointEmiter			m_peMeteorEmiter[5];		

	PDIRECT3DVERTEXBUFFER8	m_pvbSky;

	FLOAT					m_fSkyMovement;	

	CSimpleMesh				m_mMeteor;
	he3d_CMatrix			m_mtxMeteor;
	he3d_CVector			m_vPrevPos;

	PDIRECT3DVERTEXBUFFER8	m_pvbMeteorHalo;

	CBlobSystem				m_bsLava;
	CBlob3D					m_b3dLava[7];
	he3d_CVector			m_vBlobs[7];

	CSimpleMesh				m_mSphere;
	FLOAT					m_fSphereScale;
	BOOL					m_bRenderSphere;

	CImageQuad*				m_piqFade;
	BOOL					m_bRenderFade;

	CImageQuad*				m_piqExplodeFlare;
	BOOL					m_bRenderExplode;	

public:

	CVolcanic( PDIRECT3DDEVICE8 pDevice );
	virtual ~CVolcanic();

	virtual BOOL InitEfx();
	virtual BOOL FinishEfx();
	virtual BOOL UpdateFrame( FLOAT fTime );
	virtual BOOL RenderEfx();

};

#endif // !defined(AFX_VOLCANIC_H__5AFD9321_807E_11D5_AD0F_206457C12026__INCLUDED_)
