#version unofficial MegaPov 0.7;
global_settings { 
  max_trace_level 15
  assumed_gamma 1.25
  #if(Rad=on)
    #if(high_quality)// High Quality - slow rendering      
      ini_option "+QR"   
      radiosity{
        pretrace_start 0.08
        pretrace_end   0.02
        count 75            // CHANGE range from 20 to 150
        nearest_count 8     // CHANGE range from 3 to 10
        error_bound 1       // CHANGE - range from 1 to 3 - should correspond with pretrace_end
                            //   1 : pretrace_end = 0.02
                            //   3 : pretrace_end = 0.08
                            //   use pretrace_start = 0.08
                            // you can go lower than 1, but then you probably will want to set
                            // pretrace_end to 0.01, which is really slow
        recursion_limit 3    // CHANGE       
        low_error_factor .5  // leave this
        gray_threshold 0.5   // leave this
        minimum_reuse 0.015  // leave this
        brightness RadBr     // leave this used to be 1, makes radiosity brighter       
        adc_bailout 0.01/2   // CHANGE - use adc_bailout = 0.01 / brightest_ambient_object //was 0.01/2
      }     
    #else// Medium Quality - works for most scenes      
      ini_option "+QR"      
      radiosity{
        pretrace_start 0.08
        pretrace_end   0.04
        count 35             // CHANGE range from 20 to 150
        nearest_count 4      // CHANGE range from 3 to 10
        error_bound 1.25     // CHANGE - range from 1 to 3
        recursion_limit 2    // CHANGE        
        low_error_factor .5  // leave this
        gray_threshold 0.15  // leave this
        minimum_reuse 0.015  // leave this
        brightness RadBr     // leave this. used to be 1, makes radiosity brighter
        adc_bailout 0.01/1.2 // CHANGE - use adc_bailout = 0.01 / brightest_ambient_object //was 0.01/2
      }
    #end
  #else
  #end
  
  post_process{   
    soft_glow {0.95, 2.250*Rez} 
//    exponent {rgb <1.25,1.125,1.0> }
    exponent {rgb <1.35,1.35,1.35> }        
    curves {
    all
    spline {
      linear_spline
      0, 0
      0.29698, 0.25529//was 0.13fff
      0.70134, 0.76815//was 0.87fff
      1, 1
    }
  }
  }
  
}

