#include <stdio.h>
#include <stdlib.h>
#include <math.h>

int pixwidth=128;
int pixheight=96;
unsigned char origpixdata[1024*128][3];
unsigned char finalpixdata[64][128];

int rasthrestab[4] = { 64,192,128,255 }; 

#define RASTHRES2(x,y) rasthrestab[((x)^(y))&3]
#define RASTHRES(x,y) (rand()&255)
#define PIXEL(x,y) origpixdata[(y)*128+(x)]

unsigned char vic2rgb[16][3] =
{
   0x00,0x00,0x00,
   0xf0,0xf0,0xf0,
   0xd0,0x00,0x20,
   0x00,0xf0,0xd0,
   0xf0,0x00,0xd0,
   0x00,0xf0,0x00,
   0x00,0x00,0xd0,
   0xe0,0xe0,0x00,

   0xe0,0x60,0x00,
   0xe0,0xc0,0xa0,
   0xf0,0xc0,0xc0,
   0xc0,0xf0,0xf0,
   0xf0,0xc0,0xf0,
   0xc0,0xf0,0xc0,
   0xc0,0xc0,0xf0,
   0xf0,0xf0,0xc0
};

void convpic_4col_asm()
{
   int x0,y0;
   int pixfreq[4]={0,0,0,0};
   for(x0=8;x0<pixwidth+8;x0+=8)
   {
   printf(".byt ");
   for(y0=0;y0<pixheight;y0++)
   {
      int byte=0,x=0;
      for(x=0;x<8;x+=2)
      {
         int r=PIXEL((x0+x)%pixwidth,y0)[0],
             g=PIXEL((x0+x)%pixwidth,y0)[1],
             b=PIXEL((x0+x)%pixwidth,y0)[2];
         int pix;
         int brite=(3*r+6*g+b)/10;

         if(brite<0x80)pix=1;else
         if(brite<0xc0)pix=2;else
         if(brite<0xf0)pix=3;else pix=0;

/* 2 1 0 3

   bg    white
   aux   lgrn
   fore  grn
   bord  black 
*/

         pixfreq[pix]++;
         byte|=((64>>x)*pix);
      }
      printf("$%x",byte);
      if(y0!=pixheight-1)printf(",");
   }
   printf("\n\n");
   }
   fprintf(stderr,"Amt of pixels: %d %d %d %d\n",
           pixfreq[0],pixfreq[1],pixfreq[2],pixfreq[3]);
}

void loadpic()
{
   int width,height;

   int x,y=0,c,xzoomfac,yzoomfac;
   char buf[160];

   fgets(buf,160,stdin); /* P6 */
//   fgets(buf,160,stdin); /* infoline */
   fscanf(stdin,"%d %d",&width,&height);

   xzoomfac=(pixwidth*256)/width;
   yzoomfac=(pixheight*256)/height;

   while(y<height)
   {
   fprintf(stderr,"loadpic: line %d/%d\n",y,height);

   for(x=0;x<width;x++)
   {
      int x1=(xzoomfac*x)>>8,
          y1=(yzoomfac*y)>>8;
/*
      PIXEL(x1,y1)[0] = PIXEL(x1+1,y1)[0] = fgetc(stdin);
      PIXEL(x1,y1)[1] = PIXEL(x1+1,y1)[1] = fgetc(stdin);
      PIXEL(x1,y1)[2] = PIXEL(x1+1,y1)[2] = fgetc(stdin);
*/
      PIXEL(x1,y1)[0] = PIXEL(x1+1,y1)[0] = 
      PIXEL(x1,y1)[1] = PIXEL(x1+1,y1)[1] =
      PIXEL(x1,y1)[2] = PIXEL(x1+1,y1)[2] = fgetc(stdin);
   }
   y++;
   }
}

unsigned char final0data[64][128];

void dumppic()
{
   int x,y;

   printf("P6\n%d %d\n255\n",pixwidth,pixheight);

   for(y=0;y<pixheight;y++){
   for(x=0;x<pixwidth;x++)
       printf("%c%c%c",
       (vic2rgb[final0data  [y][x]][0]+
        vic2rgb[finalpixdata[y][x]][0])>>1,

       (vic2rgb[final0data  [y][x]][1]+
        vic2rgb[finalpixdata[y][x]][1])>>1,

       (vic2rgb[final0data  [y][x]][2]+
        vic2rgb[finalpixdata[y][x]][2])>>1);
   }
}

int main(int argc,char**argv)
{
   if(argc>1)
   {
      pixheight=atoi(argv[1]);
   }

   loadpic();
   convpic_4col_asm();

   return 0;
}


