; THX to Adam Seychell for this program

segment code32 use32

%define DMA 0
%include "raw32.inc"
%include "dma.inc"
;----------------------------------------------------------------------------
DMA_setup:
; AL  = mode register (bits 0-1 ignored)
; AH  = channel (0-7)
; EBX = physical base address (0-0FFFFFh)
; ECX = bytes to transfer (1-10000h)

; destroys EAX,EDX,ECX

; AL (mode register) bits are:
; 0-1.  DMA channel
; 2-3.  00: verify
;       01: write
;       10: read
;       11: forbidden
; 4.    autoinit  (1 - enabled)
; 5.    direction (0 - forward)
; 6-7.  00: demand transfer mode
;       01: singled transfer mode
;       10: block transfer mode
;       11: cascade
;----------------------------------------------------------------------------
                     xor     edx,edx
                     and     ah,7
                     mov     [DMA_channel],ah
                     and     al,11111100b
                     mov     [mode],al
; set channel mask register
                     movzx   edi,byte [DMA_channel]
                     mov     eax,edi
                     shr     edi,2
                     and     al,0011b
                     or      al,0100b
                     mov     dl,[DMA_SNGL+edi]  ; 0Ah=Canal DMA+4
                     out     dx,al
;  set mode register
                     and     al,03h
                     or      al,[mode]
                     mov     dl,[DMA_MODE+edi]
                     out     dx,al
; clear MSB/LSB flip flop
                     mov     dl,[DMA_CLRFF+edi]
                     out     dx,al
; set byte count register
                     movzx   edi,byte [DMA_channel]
                     mov     eax,ecx
                     mov     ecx,edi
                     shr     ecx,2
                     shr     eax,cl                ; divide count address by 2 for DMA # 2
                     dec     eax                   ; count - 1
                     mov     dl,[DMA_CNT+edi]      ; bits 0..7
                     out     dx,al

                     shr     eax,8
                     out     dx,al                 ; bits 8..15
; set channel base address
                     shr     ebx,cl                ; divide base address by 2 for DMA # 2
                     mov     al,bl                       ; set bits 0..7
                     mov     dl,[DMA_ADDR+edi]
                     out     dx,al

                     mov     al,bh                       ; set bits 8..15
                     out     dx,al

                     shr     ebx,15           ; divide base address by 8000h for DMA # 2
                     xor     cl,1
                     shr     ebx,cl           ; divide base address by 10000h for DMA # 1
                     mov     al,bl            ; set bits 16..23 ( in LSB page register )
                     mov     dl,[DMA_PAGE+edi]
                     out     dx,al
; clear channel (mask register)
                     mov     eax,edi
                     shr     edi,2
                     and     al,03h
                     mov     dl,[DMA_SNGL+edi]
                     out     dx,al
                     ret

mode            DB  0
DMA_channel     DB  0

; 1st & 2nd DMA Controler's ports

  DMA_STAT   db 008h,0D0h        ; read status register
  DMA_CMD    db 008h,0D0h        ; write command register
  DMA_REQ    db 009h,0D2h        ; write request register
  DMA_SNGL   db 00Ah,0D4h        ; write single bit register
  DMA_MODE   db 00Bh,0D6h        ; write mode register
  DMA_CLRFF  db 00Ch,0D8h        ; clear byte ptr flip;flop
  DMA_MCLR   db 00Dh,0DAh        ; master clear register
  DMA_CLRM   db 00Eh,0DCh        ; clear mask register
  DMA_WRTALL db 00Fh,0DEh        ; write all mask register

; ports for 8 channels

DMA_PAGE        db 087h,083h,081h,082h,08Fh,08Bh,089h,08Ah ; page register
DMA_ADDR        db 000h,002h,004h,006h,0C0h,0C4h,0C8h,0CCh ; base adddress
DMA_CNT         db 001h,003h,005h,007h,0C2h,0C6h,0CAh,0CEh ; base count

;----------------------------------------------------------------------------