; IT loader, preparer, etc...

segment code32 use32

%define ITENGINE 0

%include "nasmmacr.inc"
%include "raw32.inc"
%include "files.inc"
%include "procs.inc"

%include "ITengine.inc"
%include "ITplayer.inc"
%include "sbdrv.inc"

;----------------------------------------------------------------------------
get.DMA_buffer:
                     mov ebx,[lomembase] ; looking for good DMA address

                     mov edx,ebx
                     call bit32to16 ; edx -> dx:ax
                     and edx,0FFFFh
                     and eax,0FFFFh
                     shl edx,4      ;
                     add edx,eax    ; edx = physical addr
                     mov ax,0       ; calc lost bytes
                     sub ax,dx
                     and eax,0FFFFh ; eax = +add (lost bytes)

                     mov ebx,eax
                     add eax,65536
                     call getlomem
                     add eax,ebx
                     mov [DMA_buffer],eax
                     ret
;----------------------------------------------------------------------------
get.MIX_buffer:
                     mov eax,65536
                     call gethimem
                     mov [mixbuffer],eax

                     mov edi,[DMA_buffer]
                     mov ecx,65536/4
                     xor eax,eax
                     repz stosd
                     ret
;----------------------------------------------------------------------------
IT.prepare:
                     movzx eax,word [SBfreq]
                     mov [mixing_freq],eax

                     mov ebx,65536
                     mov ecx,32768
                     mov esi,[mixbuffer]   ; mix   buffer
                     mov edi,[DMA_buffer]  ; final buffer
                     call prepare_IT_module
                     ret
;----------------------------------------------------------------------------
IT.play:
                     mov esi,MAIN_procedure   ; IT main procedure
                     call SB_startoutput      ; start SB output
                     ret
;----------------------------------------------------------------------------
IT.stop:
                     call  SB_stopoutput
                     ret
;----------------------------------------------------------------------------
IT.load:
                     Fopen module_name,0,0,[hndl]
                     jc    .loaderr
                     mov   bx,ax
                     call  Fget_size
                     mov   [module_size],eax
                     Fclose [hndl]

                     mov   eax,[module_size]
                     call  gethimem
                     jc    .memerr
                     mov   [module_OFS],eax

                     Fopen module_name,0,0,[hndl]
                     jc    .loaderr
                     Flongread 0,[hndl],[module_size],[module_OFS]
                     Fclose [hndl]
                     ret
;----------------------------------------------------------------------------
.loaderr:
                     dosprint IT.loaderrmsg
                     jmp   exit
;----------------------------------------------------------------------------
.memerr:
                     dosprint IT.memerrmsg
                     jmp   exit
;----------------------------------------------------------------------------
SC.detect:
                     call  SB_detect
                     jc    .SB_err
                     ret
.SB_err:
                     dosprint SB.errmsg
                     call waitakey
;                     jmp   exit
                     stc
                     ret
;----------------------------------------------------------------------------
hndl           dw 0
IT.loaderrmsg  db "IT module not found.$"
IT.memerrmsg   db "not enough memory to load IT module.$"
SB.errmsg      db "SB not found.$"
;----------------------------------------------------------------------------
module_name   db "test.it",0
module_size   dd 0
;----------------------------------------------------------------------------
mixbuffer     dd 0
;----------------------------------------------------------------------------








