import java.lang.System;
import java.awt.*;
import java.awt.image.*;

import FrameGrafico;

/**
 * @author Unai Landa{@link unai_landa@eresmas.com}
 * @since 23/05/2000
 * @version .99a
 */
public class EfectoAlgo  implements Efecto
{
    ////  Gestin
    boolean  bOk;

    //////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////
    /**
     *  Constructor de EfectoAlgo
     */
    public EfectoAlgo()
    {
        bOk = false;
    }

    /**
     *  Mtodo de inicializacin.
     */
    public void init()
    {
        end();
        //  variables
        bOk = true;
    }

    /**
     *  Destruccion del objeto
     */
    public void end()
    {
        if(isOk())
        {
            bOk = false;
        }
    }

    /**
     *  Destruccion del objeto
     */
    public void finalize()  throws Throwable
    {
        end();
        super.finalize();
    }

    /**
     *  Test de inicializacin.
     */
    public final boolean isOk()
    {
        return(bOk);
    }

    //////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////
    /**
     *  interfaz Efecto
     */
    public boolean  inicio()
    {
        return(isOk());
    }

    public boolean  fin()
    {
        return(isOk());
    }

    public boolean  run(FrameGrafico _frameDest, int _iTick)
    {
        boolean bRet = true;
        ////  Combrobamos integridad y bloqueamos el Backbuffer
        if(isOk() && _frameDest.isOk() && _frameDest.lock())
        {
            ////  Acceso a los datos del backbuffer
            WritableRaster wRasterBuffer = _frameDest.imgBackBuffer.getRaster();
            DataBuffer     dbBackBuffer  = wRasterBuffer.getDataBuffer();
            int            iTamBuffer    = dbBackBuffer.getSize();
            short[]        aDatosBuffer  = ((DataBufferUShort)dbBackBuffer).getData();

            ////  Ejecucion
            ////  Ejecucion

            ////  Desbloqueamos el BackBuffer
            _frameDest.unLock();
        }
        else
        bRet = false;

        return(isOk());
    }
}

