import java.lang.System;
import java.awt.*;
import java.awt.image.*;

import java.lang.Math;

import FrameGrafico;

/**
 * @author jare & una-i
 * @since 23/05/2000
 * @version .99a
 */
public class Roto  implements Efecto
{	
    BufferedImage imgTextura;

    ////  Gestin
    boolean  bOk;

    //////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////
    /**
     *  Constructor de EfectoAlgo
     */
    public Roto()
    {
        bOk = false;
    }

    /**
     *  Mtodo de inicializacin.
     */
    public void init()
    {
        end();
        //  variables
        bOk = true;
        imgTextura = new BufferedImage(256, 256, BufferedImage.TYPE_USHORT_565_RGB);
        
        Graphics2D grfTextura = imgTextura.createGraphics();
        grfTextura.setColor(new Color(0,0,0));
        grfTextura.fillRect(0,0,128,128);
        grfTextura.setColor(new Color(255,0,0));
        grfTextura.fillRect(128,0,128,128);
        grfTextura.setColor(new Color(0,255,0));
        grfTextura.fillRect(0,128,128,128);
        grfTextura.setColor(new Color(0,0,255));
        grfTextura.fillRect(128,128,128,128);
    }

    /**
     *  Destruccion del objeto
     */
    public void end()
    {
        if(isOk())
        {
            bOk = false;
        }
    }

    /**
     *  Destruccion del objeto
     */
    public void finalize()  throws Throwable
    {
        end();
        super.finalize();
    }

    /**
     *  Test de inicializacin.
     */
    public final boolean isOk()
    {
        return(bOk);
    }

    //////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////
    /**
     *  interfaz Efecto
     */
    public boolean  inicio()
    {
        return(isOk());
    }

    public boolean  fin()
    {
        return(isOk());
    }

    public boolean  run(FrameGrafico _frameDest, int _iTick)
    {
        boolean bRet = true;
        ////  Combrobamos integridad y bloqueamos el Backbuffer
        if(isOk() && _frameDest.isOk() && _frameDest.lock())
        {
            ////  Acceso a los datos del backbuffer
            WritableRaster wRasterBuffer = _frameDest.imgBackBuffer.getRaster();
            DataBuffer     dbBackBuffer  = wRasterBuffer.getDataBuffer();
            int            iTamBuffer    = dbBackBuffer.getSize();
            short[]        aDatosBuffer  = ((DataBufferUShort)dbBackBuffer).getData();

            ////  Acceso a los datos del textura
            WritableRaster wRasterTextura= imgTextura.getRaster();
            DataBuffer     dbTextura     = wRasterTextura.getDataBuffer();
            int            iTamText      = dbTextura.getSize();
            short[]        aDatosText    = ((DataBufferUShort)dbTextura).getData();
            
            float fAng = _iTick/100.0f;
            
            float fZoom = 65536.f*(float)(Math.sin(fAng*3.7f) + 1.2);
            
            int delta_Ux = (int)(Math.cos(fAng) * fZoom);
            int delta_Vx = (int)(Math.sin(fAng) * fZoom);
            
            int delta_Uy =(int)(-Math.sin(fAng) * fZoom);
            int delta_Vy =(int)( Math.cos(fAng) * fZoom);
            
            int  Tu = -240 * delta_Uy - 320 * delta_Ux;
            int  Tv = -240 * delta_Vy - 320 * delta_Ux;

            int  tabla[][] = new int[640][2];
            
            
            for (int i = 0; i < 640; i++)
            {
                tabla[i][0] = (int)(Math.cos((fAng+(float)i)*4.3)*65536*(17*Math.sin(fAng)));
                tabla[i][1] = (int)(Math.sin((fAng+(float)i)*5.3)*65536*(23*Math.sin(fAng)));
            }
            ////  Ejecucion
            int base = 0;
            for(int alto  = 0; alto<480; alto+=1)
            {
              Tu += delta_Uy;
              Tv += delta_Vy;
              
              int in_Tu = Tu + (int)(Math.cos((fAng+(float)alto)*7.3)*65536*(34*Math.cos(fAng)));
              int in_Tv = Tv + (int)(Math.sin((fAng+(float)alto)*9.2)*65536*(27*Math.cos(fAng)));
              
              for(int ancho = 0; ancho<640; ancho+=1)
              {
                aDatosBuffer[base++] = aDatosText[ (((in_Tv+tabla[ancho&0xFF][0])&0xff0000)>>8) + (((in_Tu+tabla[ancho&0xFF][1])&0xff0000)>>16)];
                in_Tu += delta_Ux;
                in_Tv += delta_Vx;
              }
           }
                      
            ////  Ejecucion

            ////  Desbloqueamos el BackBuffer
            _frameDest.unLock();
        }
        else
        bRet = false;

        return(isOk());
    }
}

