/* mekka intro               */
/* c a l o d o x   2 0 0 1   */

#include "main.h"
#include "cubes.h"
#include "lcdlogo.icl"
#include <math.h>


/* draw a cube centered on the 2D coord (posx,posy) with a depth of posz (-posz actually) */


inline GLvoid Cube_Matrix_Plot(GLfloat	posx, GLfloat posy, GLfloat fov, GLfloat size, 
						FLOATcolor *c, GLfloat intensity, GLfloat factdist)
{		
	
	GLfloat nposx, nposy, nposz;
	GLfloat n1,n2,n3,n4;
	GLfloat dist;

	glLoadIdentity();										// reset the view
	glTranslatef(0.0f,0.0f,OGL_ZFOV);

	nposx=posx-(size*0.5);									// center the thing
	nposy=posy-(size*0.5);
	nposz=-10.0;


	dist=(1.53-sqrt(posx*posx+posy*posy)-1);	
	dist=1.0+dist*factdist;
	

	//GLfloat fov=0.8+sin((t+posx*8)*3.14/32.0)*0.1 + cos((t+posy*4)*3.14/128.0)*0.1;
	//GLfloat rayfov=fov-0.1;

	n1=nposx*5.1;		n2=(nposx+size)*5.1;
	n3=nposy*5.1;		n4=(nposy+size)*5.1;


	glColor3f(c->r*dist,c->g*dist,c->b*dist);	

	glBegin(GL_QUADS);

		glVertex3f(n1, n3, nposz*fov);	
		glVertex3f(n2, n3, nposz*fov);
		glVertex3f(n2,n4, nposz*fov);
		glVertex3f(n1,n4, nposz*fov);

	glEnd();



	if (nposx>=0.0)
	{
	glColor3f(c->r*0.2*dist,c->g*0.2*dist,c->b*0.2*dist);		// face ouest
	
	glBegin(GL_QUADS);
		glVertex3f(n1, n3, nposz);	
		glVertex3f(n1,n4, nposz);
		glVertex3f(n1,n4, nposz*fov);
		glVertex3f(n1,n3, nposz*fov);
	glEnd();
	}



	if (nposx<0.0)
	{
	glColor3f(c->r*0.5*dist,c->g*0.5*dist,c->b*0.5*dist);		// face est

	glBegin(GL_QUADS);
		glVertex3f(n2,n3, nposz*fov);
		glVertex3f(n2,n4, nposz*fov);
		glVertex3f(n2,n4, nposz);
		glVertex3f(n2, n3, nposz);	
	glEnd();
	}


	if (nposy>0.0)
	{
	glColor3f(c->r*0.4*dist,c->g*0.4*dist,c->b*0.4*dist);		// face sud

	glBegin(GL_QUADS);
		glVertex3f(n1,n3, nposz);
		glVertex3f(n2,n3, nposz);
		glVertex3f(n2,n3, nposz*fov);
		glVertex3f(n1, n3, nposz*fov);	
	glEnd();
	}

	if (nposy<0.0)
	{
	glColor3f(c->r*0.8*dist,c->g*0.8*dist,c->b*0.8*dist);		// face nord

	glBegin(GL_QUADS);
		glVertex3f(n1,n4, nposz);
		glVertex3f(n2,n4, nposz);
		glVertex3f(n2,n4, nposz*fov);
		glVertex3f(n1, n4, nposz*fov);	
	glEnd();
	}

}


inline GLvoid Cube_Light_Matrix_Plot(GLfloat	posx, GLfloat posy, GLfloat fov, GLfloat size, 
						FLOATcolor *c, GLfloat intensity, GLfloat factdist)
{		
	
	GLfloat nposx, nposy, nposz;
	GLfloat n1,n2,n3,n4;

	glLoadIdentity();										// reset the view
	glTranslatef(0.0f,0.0f,OGL_ZFOV);

	nposx=posx-(size*0.5);									// center the thing
	nposy=posy-(size*0.5);
	nposz=-10.0;



	

	n1=nposx*5.1;		n2=(nposx+size)*5.1;
	n3=nposy*5.1;		n4=(nposy+size)*5.1;

	float stochastic=((random(255))/255.0)*0.1;
	float stochastic2=((random(255))/255.0)*0.05;




		glBlendFunc(GL_ONE,GL_ONE);	// Blending Function For Translucency Based On Source Alpha Value

		glEnable(GL_BLEND);					// Turn Blending On
		glDisable(GL_DEPTH_TEST);				// Turn Depth Testing Off


	glBegin(GL_QUADS);
		glColor4f(intensity,intensity,intensity,1);
		glVertex3f(n1-size,n4, nposz);
		glVertex3f(n2-size,n4+stochastic2, nposz);
		glColor4f(0,0,0,1);
		glVertex3f(n2,n4, nposz*fov*(0.7 + stochastic));
		glVertex3f(n1, n4, nposz*fov*(0.8 + stochastic2));	
	glEnd();


	glBegin(GL_QUADS);
		glColor4f(0,0,0,1);
		glVertex3f(n2+stochastic,n3, nposz*fov*(0.7 + stochastic));
		glVertex3f(n2+stochastic2,n4, nposz*fov*(0.6 + stochastic2));	
		glColor4f(intensity,intensity,intensity,1);
		glVertex3f(n2-size,n4+stochastic2, nposz);
		glVertex3f(n2-size, n3, nposz);	
	glEnd();

	glBegin(GL_QUADS);
		glColor4f(intensity,intensity,intensity,1);
		glVertex3f(n1-size,n3, nposz);
		glVertex3f(n2-size,n3, nposz);
		glColor4f(0,0,0,1);
		glVertex3f(n2,n3, nposz*fov*(0.8 + stochastic));
		glVertex3f(n1, n3, nposz*fov*(0.6 + stochastic2));	
	glEnd();



		glBegin(GL_QUADS);

		glColor4f(intensity,intensity,intensity,intensity);
		glVertex3f(n1, n3, nposz);	
		glVertex3f(n1,n4, nposz);
		glColor4f(0,0,0,1);
		glVertex3f(n1,n4, nposz*fov*0.9);
		glVertex3f(n1,n3, nposz*fov*0.9);
	glEnd();
	


	glDisable(GL_BLEND);					// Turn Blending On
	glEnable(GL_DEPTH_TEST);				// Turn Depth Testing Off


}



inline GLvoid Cube_Draw_Square(GLfloat x, GLfloat y, GLfloat size, FLOATcolor *c)
{
	glColor3f(c->r,c->g,c->b);	

	GLfloat n1,n2,n3,n4;

	n1=x-size*0.5;
	n2=x+size*0.5;
	n3=y-size*0.5;
	n4=y+size*0.5;


	glBegin(GL_QUADS);

		glVertex2f(n1, n3);	
		glVertex2f(n2, n3);
		glVertex2f(n2,n4);
		glVertex2f(n1,n4);

	glEnd();
}


float Cube_Matrix_Height[163*52];
float Cube_Matrix_Height_Light[163*52];
float Cube_Matrix_Height_Light_Alpha[163*52];

GLvoid Cube_Matrix_Plot_LCD (int nbx, int nby, GLfloat fov, GLfloat size, 
							 FLOATcolor *c1, FLOATcolor *c2, GLfloat intensity, GLfloat fdist, unsigned char *bf)
{
	int i=0;
	GLfloat stepx=(OGL_MAXX-OGL_MINX - (size*nbx))/(nbx);
	stepx+=size;

	
	FLOATcolor ccolor={1.0, 1.0, 1.0};

	glDisable(GL_TEXTURE_2D);

	for (int yy=0;yy<nby;yy++)
	{

		for (int xx=0;xx<nbx;xx++)
		{
		
			if (bf[i]==0)
			{
			Cube_Matrix_Plot(stepx*0.5+stepx*(xx-(nbx*0.5)), stepx*(yy-(nby*0.5)), 1.0, size, c1, 0, 0);	
			}
			else
			{
			Cube_Matrix_Plot(stepx*0.5+stepx*(xx-(nbx*0.5)), stepx*(yy-(nby*0.5)), fov, size, c2, intensity, fdist);
			}
		i++;
		}
	}



		glEnable(GL_TEXTURE_2D);
}





GLvoid Cube_Matrix_Plot_LCD_V2(int nbx, int nby, GLfloat fov, GLfloat size, 
							 FLOATcolor *c1, FLOATcolor *c2, GLfloat intensity, GLfloat fdist, unsigned char *bf)
{
	int i=0;
	GLfloat stepx=(OGL_MAXX-OGL_MINX - (size*nbx))/(nbx);
	stepx+=size;

	
	FLOATcolor ccolor={1.0, 1.0, 1.0};

	glDisable(GL_TEXTURE_2D);

	for (int yy=0;yy<nby;yy++)
	{

		for (int xx=0;xx<nbx;xx++)
		{
		
			if (bf[i]==0)
			{
			Cube_Matrix_Plot(stepx*0.5+stepx*(xx-(nbx*0.5)), stepx*(yy-(nby*0.5)), Cube_Matrix_Height[i], size, c1, 0, 0);	
			}
			else
			{
			Cube_Matrix_Plot(stepx*0.5+stepx*(xx-(nbx*0.5)), stepx*(yy-(nby*0.5)), Cube_Matrix_Height[i], size, c2, intensity, fdist);
			}
		i++;
		}
	}


		glEnable(GL_TEXTURE_2D);
}


GLvoid Cube_Matrix_Plot_LCD_V3(int nbx, int nby, GLfloat size, 
							 FLOATcolor *c1, FLOATcolor *c2, GLfloat intensity,
							 unsigned char *bf)
{
	int i=0;
	GLfloat stepx=(OGL_MAXX-OGL_MINX - (size*nbx))/(nbx);
	stepx+=size;

	
	FLOATcolor ccolor={1.0, 1.0, 1.0};

	glDisable(GL_TEXTURE_2D);

	for (int yy=0;yy<nby;yy++)
	{

		for (int xx=0;xx<nbx;xx++)
		{
		
			if (bf[i]==0)
			{
			Cube_Matrix_Plot(stepx*0.5+stepx*(xx-(nbx*0.5)), stepx*(yy-(nby*0.5)), Cube_Matrix_Height[i], size, c1, 0, 0);	
			}
			else
			{
			Cube_Matrix_Plot(stepx*0.5+stepx*(xx-(nbx*0.5)), stepx*(yy-(nby*0.5)), Cube_Matrix_Height[i], size, c2, 0.0, 0);
			}
		i++;
		}
	}



	//int starting=0;
	i=0;

	for (yy=0;yy<nby;yy++)
	{


		for (int xx=0;xx<nbx;xx++)
		{
			Cube_Light_Matrix_Plot(stepx*0.5+stepx*(xx-(nbx*0.5)), stepx*(yy-(nby*0.5)), Cube_Matrix_Height_Light[i], 
								    size, c2, Cube_Matrix_Height_Light_Alpha[i], 0.0);
		i++;
		}

	}

		glEnable(GL_TEXTURE_2D);
}
