#include "main.h"

#include "ADPCM_samples/sample1.inc"
#include "ADPCM_samples/sample2.inc"
#include "ADPCM_samples/sample3.inc"
#include "ADPCM_samples/sample4.inc"
#include "ADPCM_samples/sample5.inc"
#include "ADPCM_samples/sample6.inc"
#include "ADPCM_samples/sample7.inc"
#include "ADPCM_samples/sample8.inc"
#include "ADPCM_samples/sample9.inc"
#include "ADPCM_samples/sample10.inc"
#include "ADPCM_samples/sample11.inc"
#include "ADPCM_samples/sample12.inc"


static long indexTable[16] = {
    -1, -1, -1, -1, 2, 4, 6, 8,
    -1, -1, -1, -1, 2, 4, 6, 8,
};

static long stepsizeTable[89] = {
    7, 8, 9, 10, 11, 12, 13, 14, 16, 17,
    19, 21, 23, 25, 28, 31, 34, 37, 41, 45,
    50, 55, 60, 66, 73, 80, 88, 97, 107, 118,
    130, 143, 157, 173, 190, 209, 230, 253, 279, 307,
    337, 371, 408, 449, 494, 544, 598, 658, 724, 796,
    876, 963, 1060, 1166, 1282, 1411, 1552, 1707, 1878, 2066,
    2272, 2499, 2749, 3024, 3327, 3660, 4026, 4428, 4871, 5358,
    5894, 6484, 7132, 7845, 8630, 9493, 10442, 11487, 12635, 13899,
    15289, 16818, 18500, 20350, 22385, 24623, 27086, 29794, 32767
};


void adpcm_unpack_nibbles(char *indata, char *outdata, int size)
{
	int j=0;

	for (int i=0;i<size;i++)
	{
	 outdata[j]=(indata[i]&0x0f);
	 outdata[j+1]=(indata[i]>>4);
	 j+=2;	
	}
}

void CONVERT_16sign_to_8sign(short *source, char *dest, int size)
{

	for (int i=0;i<size;i++)
	{
	dest[i]=(source[i])>>8;
	}
}

void adpcm_decoder(char *indata, short *outdata, int len)
{

    long sign;                  /* Current adpcm sign bit */
    long delta;                 /* Current adpcm output value */
    long step_l=1;                /* Stepsize */
    long valprev_l=0;             /* virtual previous output value */
    long vpdiff;                        /* Current change to valprev */
    long index_l=0;               /* Current step change index */
    long inputbuffer;           /* place to keep next 4-bit value */
	int index=0;

    for ( ; len > 0 ; len-- )
    {
      
       /* Step 1 - get the delta value and compute next index */
       inputbuffer = indata[index];
       delta = inputbuffer & 0xf;

        /* Step 2 - Find new index value (for later) */
        index_l += indexTable[delta];
        if ( index_l < 0 )
        {
            index_l = 0;
        }
        else if ( index_l > 88 )
        {
            index_l = 88;
        }

       /* Step 3 - Separate sign and magnitude */
       sign = delta & 8;
       delta = delta & 7;

        vpdiff = (delta*step_l) >> 2;

       if ( sign )
         valprev_l -= vpdiff;
       else
         valprev_l += vpdiff;

       /* Step 5 - clamp output value */
       if ( valprev_l > 32767 )
         valprev_l = 32767;
       else if ( valprev_l < -32768 )
         valprev_l = -32768;

       /* Step 6 - Update step value */
       step_l = stepsizeTable[index_l];

       /* Step 7 - Output value */
       outdata[index]= (short) valprev_l;

	   index++;
    }

}





char *decompressed_samples;
char *ADPCM_step1;
short *ADPCM_step2;


void DECOMPRESS_samples()
{
	
	decompressed_samples=(char*) malloc(20000);		//20000 bytes per sample..way enough
	ADPCM_step1=(char*) malloc(24000);
	ADPCM_step2=(short*) malloc(24000);
	memset(decompressed_samples,0,20000);

	adpcm_unpack_nibbles(ADPCMsample1, ADPCM_step1, 3110);
	adpcm_decoder(ADPCM_step1, ADPCM_step2, 3110);
	CONVERT_16sign_to_8sign(ADPCM_step2, decompressed_samples, 3110);
	memcpy(genox_mxm+27520, decompressed_samples,  3110);

	adpcm_unpack_nibbles(ADPCMsample2, ADPCM_step1, 1694);
	adpcm_decoder(ADPCM_step1, ADPCM_step2, 1694);
	CONVERT_16sign_to_8sign(ADPCM_step2, decompressed_samples, 1694);
	memcpy(genox_mxm+30631, decompressed_samples,  1694);

	adpcm_unpack_nibbles(ADPCMsample3, ADPCM_step1, 1368);
	adpcm_decoder(ADPCM_step1, ADPCM_step2, 1368);
	CONVERT_16sign_to_8sign(ADPCM_step2, decompressed_samples, 1368);
	memcpy(genox_mxm+32326, decompressed_samples,  1368);

	adpcm_unpack_nibbles(ADPCMsample4, ADPCM_step1, 1155);
	adpcm_decoder(ADPCM_step1, ADPCM_step2, 1155);
	CONVERT_16sign_to_8sign(ADPCM_step2, decompressed_samples, 1155);
	memcpy(genox_mxm+33695, decompressed_samples,  1155);

	adpcm_unpack_nibbles(ADPCMsample5, ADPCM_step1, 1628);
	adpcm_decoder(ADPCM_step1, ADPCM_step2, 1628);
	CONVERT_16sign_to_8sign(ADPCM_step2, decompressed_samples, 1628);
	memcpy(genox_mxm+34851, decompressed_samples,  1628);

	adpcm_unpack_nibbles(ADPCMsample6, ADPCM_step1, 1722);
	adpcm_decoder(ADPCM_step1, ADPCM_step2, 1722);
	CONVERT_16sign_to_8sign(ADPCM_step2, decompressed_samples, 1722);
	memcpy(genox_mxm+36480, decompressed_samples,  1722);

	adpcm_unpack_nibbles(ADPCMsample7, ADPCM_step1, 1828);
	adpcm_decoder(ADPCM_step1, ADPCM_step2, 1828);
	CONVERT_16sign_to_8sign(ADPCM_step2, decompressed_samples, 1828);
	memcpy(genox_mxm+38203, decompressed_samples,  1828);

	adpcm_unpack_nibbles(ADPCMsample8, ADPCM_step1, 2477);
	adpcm_decoder(ADPCM_step1, ADPCM_step2, 2477);
	CONVERT_16sign_to_8sign(ADPCM_step2, decompressed_samples, 2477);
	memcpy(genox_mxm+40032, decompressed_samples,  2477);

	adpcm_unpack_nibbles(ADPCMsample9, ADPCM_step1, 2725);
	adpcm_decoder(ADPCM_step1, ADPCM_step2, 2725);
	CONVERT_16sign_to_8sign(ADPCM_step2, decompressed_samples, 2725);
	memcpy(genox_mxm+42510, decompressed_samples,  2725);

	adpcm_unpack_nibbles(ADPCMsample10, ADPCM_step1, 2260);
	adpcm_decoder(ADPCM_step1, ADPCM_step2, 2260);
	CONVERT_16sign_to_8sign(ADPCM_step2, decompressed_samples,2260);
	memcpy(genox_mxm+45235, decompressed_samples,  2260);

	adpcm_unpack_nibbles(ADPCMsample11, ADPCM_step1, 11652);
	adpcm_decoder(ADPCM_step1, ADPCM_step2, 11652);
	CONVERT_16sign_to_8sign(ADPCM_step2, decompressed_samples, 11652);
	memcpy(genox_mxm+47496, decompressed_samples,  11652);

	adpcm_unpack_nibbles(ADPCMsample12, ADPCM_step1, 6136);
	adpcm_decoder(ADPCM_step1, ADPCM_step2, 6136);
	CONVERT_16sign_to_8sign(ADPCM_step2, decompressed_samples, 6136);
	memcpy(genox_mxm+59149, decompressed_samples,  6136);

}