/* mekka intro               */
/* c a l o d o x   2 0 0 1   */


#include "main.h"
#include <math.h>



void TEXTURE_scale_greyscale_128x128_to_256x256(unsigned char *src, unsigned char *dest)
{
	int i=0;

	for (int y=0;y<256;y++)
	{
		for (int x=0;x<256;x++)
		{
			int ix,iy;

			ix=x>>1;
			iy=y>>1;

			dest[i]=src[ix+(iy<<7)];
			i++;
		}
	}
}


void TEXTURE_blur_greyscale_256x256(unsigned char *buffer)
{

	for (int y=1;y<255;y++)				//leave 1 pixel border around the buffer
	{
		for (int x=1;x<255;x++)
		{

			int u=x+(y<<8);

			int c=buffer[u+1]+buffer[u-1];
			    c+=buffer[u-256]+buffer[u-257]+buffer[u-255];
				c+=buffer[u+256]+buffer[u+257]+buffer[u+255];
			c>>=3;

			buffer[u]=c;
		}

	}
}

void TEXTURE_greyscale_clip_whiteblack(unsigned char *src, unsigned char *dest, unsigned char thresold)
{

	for (int i=0;i<256*256;i++)
	{

	

		if (src[i]<thresold)
		{
		 dest[i]=0;
		}
		else
		{
			dest[i]=0xFF;
		}

	}

}


void TEXTURE_greyscale_invert(unsigned char *src, int size)
{
	for (int i=0;i<size;i++)
	{
		src[i]=0xFF-src[i];
	}
}

void TEXTURE_greyscale_to_RGBA(unsigned char *src, unsigned char *dest, int size)
{

	for (int i=0;i<size<<2;i++)
	{
		dest[i]=src[i>>2];
	}
}


void TEXTURE_halo(unsigned char *dest)		//!! 32 bits !!
{

	int i=0;

	for (int y=0;y<256;y++)
	{
		for (int x=0;x<256;x++)
		{
	
			float fx=float(x);
			float fy=float(y);

			float dist=sqrt((fx-128.0)*(fx-128.0)+(fy-128.0)*(fy-128.0));


			dist/=182.0;

			dist=1.0-dist;
			dist=exp(dist);
			dist-=1.7;
			if (dist<0.0) dist=0.0;
			if (dist>1.0) dist=1.0;

			dest[i]=dest[i+1]=dest[i+2]=dist*255.0;
		//	dest[i+3]=0xFF;

			i+=3;

		}


	}

}