/* Funslower demo by SoopaDoopa */
/* Released at the TRSAC AUTUMN 2001 demo party */
/* in Copenhagen Octorber 2001 */
/* The credits:
Code:		Druckluft
Gfx:		Gibson
SoundTrack:	Gibson
*/

/* SoopaDoopa 2001 */

/*
3min28sec
=
10400 frames
*/

#include "dma.h"
#include "gif.h"
#include "types.h"
#include "matrix.h"
#include "texture.h"
#include "math.h"

#include "eks1.h"
#include "eks2.h"
#include "eks3.h"
#include "eks4.h"
#include "eks5.h"
#include "eks7.h"

void FlushCache(int);
void Init_GS(void);

static int128	list[40];		//temp dma-gif-area

static int128 dmamem[1024*20*8*2+1024];	//large dma-area

int PAL;

#define __LOGO_START 		0
#define __LOGO_END 		700
#define __TEXTWRITE0_START 	510
#define __TEXTWRITE0_END 	1400
#define __TEXTWRITE1_START 	1700
#define __TEXTWRITE1_END 	2600
#define __SUPER_START 		2600
#define __SUPER_END 		3800
#define __TEXTWRITE2_START 	3800
#define __TEXTWRITE2_END 	(4300+80)
#define __PLASMA_START 		4200
#define __PLASMA_END 		7085
#define __TEXTWRITE3_START 	7085
#define __TEXTWRITE3_END 	7985
#define __TETRA_START 		7985
#define __TETRA_END 		8585
#define __TEXTWRITE4_START 	8585
#define __TEXTWRITE4_END 	9085
#define __TEXTWRITE5_START 	9085
#define __TEXTWRITE5_END 	9640
#define __CREDITS_START 	9640
#define __CREDITS_END 		10800
#define __END 			10800
#define __SEJ_START __TEXTWRITE4_START
#define __SEJ_END 10800

#define __START 0

void clearscreen()
{
	gif_env;
	
	//We must clear the screen without using the dma_begingp()
	//since that would clear the image generated by the vectorunit
	
//	dma_begingp();
	gif_begin(list);
	

	gif_tag(0xe,1,0,0,0);
	gSCISSOR_1(wwd(hhw(0,639),hhw(0,255)));	// x1,y1,x2,y2 - scissor window
	gPRMODECONT(1);				// refer to prim attributes
	gCOLCLAMP(1);
	gDTHE(0);				// Dither off
	gTEST_1(0x70000);
	gTEST_1(0x30000);
	gPRIM(6);
	gRGBAQ(0x3F80000000000000);		// Background RGBA
//	gRGBAQ(0x3F80000000000000+rgb(77,74,71));		// Background RGBA
	gXYZ2(hhw(32000+0*16,32000));
	gXYZ2(hhw(32000+16*640,32000+16*256));

	gif_endfinal();

	//...and send without dma_endgp()
//	dma_endgp();
	FlushCache(0);
	dma02_wait();
	dma02_send(list,gif_length,0x101);
	dma02_wait();
}

static int screenzbuf;
static int screen[2];

static void allocscreen()
{
	texture_allocinit(0);
	screen[0]=texture_allocvideomem(256*640*4);
	screen[1]=texture_allocvideomem(256*640*4);
	screenzbuf=texture_allocvideomem(256*640*4);
}

static void flipscreen()
{
	gif_env;
	int interlaceframe;
		
	interlaceframe=GIF_[0x40*2]&(1<<13);
	if(interlaceframe)interlaceframe=1;	

	GIF_[0]=0x000000000000FF62;
	GIF_[4]=0x0000000000000002;


	if(PAL)
	{
		GIF_[18]=0x0000000000001400+screen[interlaceframe]/2048/4;
		GIF_[20]=0x000ff9FF01824290;
	}
	else
	{
		GIF_[18]=0x0000000000001400+screen[interlaceframe]/2048/4+10;
		GIF_[20]=0x000c79FF01824290;
	}

	interlaceframe=1-interlaceframe;

	gif_begin(list);
	gif_tag(0xe,1,0,0,0);
	gFRAME_1(0x00A0000+screen[interlaceframe]/2048/4);	// framebuffer width = 640/64
	gFRAME_2(0x00A0000+screen[interlaceframe]/2048/4);	// framebuffer width = 640/64
	gZBUF_1(screenzbuf/2048/4);				// 0-8 Zbuffer base, 24-27 Z format (32bit)
	gZBUF_2(screenzbuf/2048/4);				// 0-8 Zbuffer base, 24-27 Z format (32bit)
	gXYOFFSET_1(wwd(32000,32008-1*interlaceframe*8));	// X,Y offset
	gXYOFFSET_2(wwd(32000,32008-1*interlaceframe*8));	// X,Y offset
	gSCISSOR_1(wwd(hhw(0,639),hhw(0,255)));			// x1,y1,x2,y2 - scissor window
	gSCISSOR_2(wwd(hhw(0,639),hhw(0,255)));			// x1,y1,x2,y2 - scissor window
	gPRMODECONT(1);						// refer to prim attributes
	gCOLCLAMP(1);
	gDTHE(0);						// Dither off
	gTEST_1(0x30000);
	gTEST_2(0x70000);
	gif_endfinal();

	FlushCache(0);
	dma02_wait();
	dma02_send(list,gif_length,0x101);
	dma02_wait();
}

static void showvideoram()
{
	int y=0;

	while(1)
	{
		int t;
		for(t=0;t<15;t++)
		vsync();
		GIF_[0]=0x000000000000FF62;
		GIF_[4]=0x0000000000000002;
		GIF_[18]=0x0000000000001400+((y));
		GIF_[20]=0x000ff9FF01824290;

		y+=5*2;
		if(y>511)y=0;
	}
}


#define NTSCPAL *((char*)0x1fc80000-0xae)

/*                lui     $2,0x1fc8
                lb      $2,-0xae($2)
                li      $3,'E'
*/

int main()
{
	float frames=__START;

	if(NTSCPAL!='E')
		PAL=0;
	else
		PAL=1;//1;

	Init_GS();

	allocscreen();
	dma_reset();
	math_init();

//	texture_cleartexturemem(0xff00ff);	//fill texturemem with ugly color
	texture_cleartexturemem(0x0);		//clear texturemem


	eks1_init();
	eks1_init2();
	eks2_init();
	eks2_init2();
	eks3_init();
	eks3_init2();
	eks4_init();
	eks4_init2();
	eks5_init();
	eks5_init2();
	eks7_init();
	eks7_init2();

//	showvideoram();				//to check if everything is located right

	while(frames<__END)
	{
//		setbgcolor(RGB(100,100,50));
		vsync();
		setbgcolor(RGB(0,0,0));
//		setbgcolor(RGB(85,132,145));

		// init dmachain
		dma_beginchain(dmamem);


		flipscreen();
		clearscreen();

		
		if((frames>=__SEJ_START)&&(frames<__SEJ_END))
		{
			eks2_frame2(frames-(__CREDITS_START),min(min(10*(frames-__SEJ_START),2000),-10*(frames-__SEJ_END)));
		}
			
		if((frames>=__TEXTWRITE0_START)&&(frames<__TEXTWRITE0_END+300))
		{
			if(frames>(__TEXTWRITE0_START)-700)
				eks2_frame(frames-(__TEXTWRITE0_START),10*(frames-(__TEXTWRITE0_START)-650));
	//		eks1_frame2(min(frames-(__TEXTWRITE0_START)-400,__TEXTWRITE0_END-100-frames));
			eks1_frame2(min(frames-(__TEXTWRITE0_START)-500,__TEXTWRITE0_END-100-frames));
		}
	
		if((frames>=__TEXTWRITE1_START)&&(frames<__TEXTWRITE1_END))
		{
			eks2_frame(frames-(__TEXTWRITE0_START),(-frames+__TEXTWRITE1_END)*10);
		}
		
	
	
	
	
		if((frames>=__LOGO_START)&&(frames<__LOGO_END))
		{
			eks1_frame(frames-__LOGO_START);
		}
		else
		{
			if((frames>=__SUPER_START)&&(frames<__SUPER_END))
				eks1_drawlogo(50,0);
			else if((frames>=__PLASMA_START+100)&&(frames<__PLASMA_END))
				eks1_drawlogo(50,0);
			else if((frames>=__TETRA_START)&&(frames<__TETRA_END-50))
				eks1_drawlogo(50,0);
			else if((frames>__END-50))
				eks1_drawlogo(50,1);
			else
				eks1_drawlogo(0,0);
		}
	
		if((frames>=__TEXTWRITE0_START)&&(frames<__TEXTWRITE0_END))
		{
			eks4_frame(frames-(__TEXTWRITE0_START),0,400,150);
		}
		if((frames>=__TEXTWRITE1_START)&&(frames<__TEXTWRITE1_END))
		{
			eks4_frame(frames-(__TEXTWRITE1_START),1,550,400);
		}
	
		if((frames>=__SUPER_START)&&(frames<__SUPER_END))
		{
			eks5_frame((frames-(__SUPER_START))*2);
		}
	
		if((frames>=__TEXTWRITE2_START)&&(frames<__TEXTWRITE2_END))
		{
			eks4_frame(frames-(__TEXTWRITE2_START),2,400,250);
		}
	
		if((frames>=__PLASMA_START)&&(frames<__PLASMA_END))
		{
			eks3_frame((frames-(__PLASMA_START)));
		}
	
		if((frames>=__TEXTWRITE3_START)&&(frames<__TEXTWRITE3_END))
		{
			eks4_frame(frames-(__TEXTWRITE3_START),3,550,400);
		}
	
		if((frames>=__TETRA_START)&&(frames<__TETRA_END))
		{
			eks7_frame((frames-(__TETRA_START)));
		}
	
		if((frames>=__TEXTWRITE4_START)&&(frames<__TEXTWRITE4_END))
		{
			eks4_frame(frames-(__TEXTWRITE4_START)+80,4,400,250);
		}
	
		if((frames>=__TEXTWRITE5_START)&&(frames<__TEXTWRITE5_END))
		{
			eks4_frame(frames-(__TEXTWRITE5_START)+30,5,400,250);
		}
	
		if((frames>=__CREDITS_START)&&(frames<__CREDITS_END))
		{
			eks1_frame3(frames-(__CREDITS_START));
		}




		// send dmachain
		dma_endchain();
		FlushCache(0);
		dma02_wait();
		dma_sendchain();
		dma02_wait();

		frames+=1.0;
//		if(frames==__START+4)showvideoram();
	}

	eks7_deinit();
	eks5_deinit();
	eks4_deinit();
	eks3_deinit();
	eks2_deinit();
	eks1_deinit();

	return 0;
}
