/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.image.MemoryImageSource;
import java.util.Vector;

public class Particles
extends Applet
implements Runnable {
    Vector active_particles = new Vector();
    Vector inactive_particles = new Vector();
    Image offScrImage;
    Graphics offScrGr;
    MemoryImageSource imageSource;
    int[] pixels;
    Image image;
    int width;
    int height;
    private double theta = 2.356194490192345;
    private final int x = 0;
    private final int y = 1;
    private final int z = 2;
    private final int vx = 3;
    private final int vy = 4;
    private final int vz = 5;
    private final int red = 6;
    private final int green = 7;
    private final int blue = 8;
    private volatile boolean running = true;

    public void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 506) {
            int n = mouseEvent.getY();
            this.theta = Math.PI * ((double)n / (double)this.height - 0.5);
        }
    }

    public void start() {
        this.running = true;
        new Thread(this).start();
    }

    public void run() {
        Dimension dimension = this.getSize();
        this.offScrImage = this.createImage(dimension.width, dimension.height);
        this.offScrGr = this.offScrImage.getGraphics();
        this.width = dimension.width;
        this.height = dimension.height;
        int n = 0;
        while (n < 2000) {
            float[] fArray = new float[9];
            if (n > 100) {
                this.inactive_particles.addElement(fArray);
            } else {
                fArray[8] = 0.5f;
                fArray[7] = 0.5f;
                fArray[6] = 0.5f;
                double d = Math.random() - 0.5;
                double d2 = Math.random() - 0.5;
                double d3 = Math.random() - 0.5;
                double d4 = Math.sqrt(d2 * d2 + d3 * d3);
                fArray[0] = (float)((double)this.width * d);
                fArray[1] = (float)((double)this.width * d2 / d4);
                fArray[2] = (float)((double)this.width * d3 / d4);
                this.active_particles.addElement(fArray);
            }
            ++n;
        }
        this.pixels = new int[dimension.width * dimension.height];
        this.imageSource = new MemoryImageSource(dimension.width, dimension.height, this.pixels, 0, this.width);
        this.imageSource.setAnimated(true);
        this.imageSource.setFullBufferUpdates(true);
        this.image = this.createImage(this.imageSource);
        this.enableEvents(32L);
        Thread.currentThread().setPriority(1);
        while (this.running) {
            long l = System.currentTimeMillis();
            int n2 = this.inactive_particles.size();
            while (n2 > 0 && Math.random() < 0.7) {
                float[] fArray = (float[])this.inactive_particles.elementAt(--n2);
                this.inactive_particles.removeElementAt(n2);
                fArray[1] = (float)((0.5 - Math.random()) * 3.0);
                fArray[2] = (float)((0.5 - Math.random()) * 3.0);
                fArray[3] = (float)((0.5 - Math.random()) * 3.0);
                fArray[5] = (float)((0.5 - Math.random()) * 3.0);
                double d = Math.random();
                if (d < 0.5) {
                    fArray[0] = (float)(0.5 - Math.random() + (double)(3 * this.width / 8));
                    fArray[4] = (float)(0.5 - Math.random() + 10.0);
                } else {
                    fArray[0] = (float)(0.5 - Math.random() - (double)(3 * this.width / 8));
                    fArray[4] = (float)(0.5 - Math.random() - 10.0);
                }
                int n3 = 6;
                while (n3 <= 8) {
                    fArray[n3] = 0.2f + (float)((double)0.1f * Math.random());
                    ++n3;
                }
                if (Math.random() < 0.7) {
                    fArray[8] = (float)((double)fArray[8] + 0.15);
                } else {
                    fArray[6] = (float)((double)fArray[6] + 0.3);
                    fArray[7] = (float)((double)fArray[7] + 0.2);
                }
                this.active_particles.addElement(fArray);
            }
            int n4 = 0;
            while (n4 < this.pixels.length) {
                this.pixels[n4] = -16777216;
                ++n4;
            }
            float f = (float)Math.sin(this.theta);
            float f2 = (float)Math.cos(this.theta);
            double d = 0.1f;
            int n5 = this.active_particles.size() - 1;
            while (n5 >= 0) {
                float f3;
                int n6;
                float[] fArray = (float[])this.active_particles.elementAt(n5);
                if (n5 > 100) {
                    double d5 = 0.0;
                    n6 = 0;
                    while (n6 < 3) {
                        float f4 = fArray[n6 + 3];
                        int n7 = n6;
                        fArray[n7] = (float)((double)fArray[n7] + d * (double)f4);
                        d5 += (double)(fArray[n6] * fArray[n6]);
                        ++n6;
                    }
                    double d6 = Math.sqrt(d5);
                    double d7 = -10000.0 / d5;
                    double d8 = 0.0;
                    int n8 = 0;
                    while (n8 < 3) {
                        f3 = fArray[n8 + 3];
                        fArray[n8 + 3] = (float)((double)f3 + d * d7 * (double)fArray[n8] / d6) * 0.999f;
                        d8 += (double)(f3 * f3);
                        ++n8;
                    }
                    if (d5 < 100.0 || d5 > 1000000.0 || d8 > 2500.0) {
                        this.active_particles.removeElementAt(n5);
                        this.inactive_particles.addElement(fArray);
                    }
                }
                float f5 = fArray[1] * f2 + fArray[2] * f;
                float f6 = fArray[0];
                f6 += 0.5f * (float)this.width;
                f5 += 0.5f * (float)this.height;
                if (f6 >= 0.0f && f5 >= 0.0f) {
                    n6 = (int)f6;
                    int n9 = (int)f5;
                    int n10 = n6 + 1;
                    int n11 = n9 + 1;
                    if (n10 < this.width && n11 < this.height) {
                        float f7 = f6 - (float)n6;
                        float f8 = f5 - (float)n9;
                        float f9 = 1.0f - f7;
                        float f10 = 1.0f - f8;
                        f3 = f9 * f10;
                        float f11 = f7 * f10;
                        float f12 = f9 * f8;
                        float f13 = f7 * f8;
                        float f14 = 255.0f * fArray[6];
                        float f15 = 255.0f * fArray[7];
                        float f16 = 255.0f * fArray[8];
                        this.plotPixel(f3 * f14, f3 * f15, f3 * f16, n6, n9);
                        this.plotPixel(f11 * f14, f11 * f15, f11 * f16, n10, n9);
                        this.plotPixel(f12 * f14, f12 * f15, f12 * f16, n6, n11);
                        this.plotPixel(f13 * f14, f13 * f15, f13 * f16, n10, n11);
                    }
                }
                --n5;
            }
            long l2 = System.currentTimeMillis();
            this.image.flush();
            this.offScrGr.drawImage(this.image, 0, 0, this);
            this.repaint();
            long l3 = l + 40L - l2;
            if (l3 <= 0L) continue;
            try {
                Thread.sleep(l3);
            }
            catch (Exception exception) {}
        }
    }

    public void stop() {
        this.running = false;
    }

    private void plotPixel(float f, float f2, float f3, int n, int n2) {
        int n3 = n2 * this.width + n;
        int n4 = this.pixels[n3];
        int n5 = ((n4 & 0xFF0000) >> 16) + (int)f;
        n5 = n5 > 255 ? 255 : n5;
        int n6 = ((n4 & 0xFF00) >> 8) + (int)f2;
        n6 = n6 > 255 ? 255 : n6;
        int n7 = (n4 & 0xFF) + (int)f3;
        n7 = n7 > 255 ? 255 : n7;
        this.pixels[n3] = 0xFF000000 | n5 << 16 | n6 << 8 | n7;
    }

    public void update(Graphics graphics) {
        if (this.offScrImage == null) {
            return;
        }
        graphics.drawImage(this.offScrImage, 0, 0, this);
    }
}

