/* add.c
 *
 * Copyright 2001-2002 Vesa Halttunen (Vesuri/dA JoRMaS)
 *
 * This file is part of JRm-core.
 *
 * JRm-core is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * JRm-core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JRm-core; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdlib.h>
#include "effect.h"
#include "add.h"

#define getalpha(data) ((((data)&0xff000000)>>24)+1)
#define addpass1(data1, data2) (((data2)&0xfefefe)+((data1)&0xfefefe))
#define addpass2(temp) ((((temp)|((((((temp)&0x01010100)|0x80808000)-0x01010100)^0xffffffff)>>7))&0x00ffffff)|0xff000000)

void add_run(void *d, long time) {
  add_data *data=(add_data *)d;

  /* Get local copies of the parameters */
  unsigned long *dest=data->dest->data+((data->y)*data->dest->width+data->x);
  unsigned long color=data->color;
  int alpha=getalpha(color);
  unsigned long addcolor=
    ((((color&0xff0000)*(alpha))>>8)&0xff0000)|
    ((((color&0xff00)*(alpha))>>8)&0xff00)|
    ((((color&0xff)*(alpha))>>8)&0xff);
  int width=data->width, height=data->height;
  int dx=data->dest->width-width, x, y;
  
  for(y=0; y<height; y++) {
    for(x=0; x<width; x++) {
      unsigned long temp=addpass1(addcolor, *dest);
      *dest++=addpass2(temp);
    }
    dest+=dx;
  }
}

void add_free(effect *effect) {
  free(effect->data);
}

void add_new(effect *effect) {
  effect->run=add_run;
  effect->new=add_new;
  effect->parameters=NULL;
  effect->freee=add_free;
  effect->data=(add_data *)calloc(sizeof(add_data), 1);
}
