/* assembly2002demo.h
 *
 * Copyright 2001-2002 dA JoRMaS
 *
 * This file is part of JRm-core.
 *
 * JRm-core is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * JRm-core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JRm-core; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef WINDOWS
#define M_PI 3.14159265358979323846
#endif

/* Song information */
#define PATTERNLENGTH 64
#define BPM 120

/* Include everything that is needed by all parts */
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "production.h"
#include "effect.h"
#include "copy.h"
#include "horizontalstretch.h"
#include "verticalstretch.h"
#include "add.h"
#include "horizontalstripes.h"
#include "verticalstripes.h"
#include "horizontalblur.h"
#include "verticalblur.h"

/* External definitions needed by all parts */
extern effectlistentry *effectlist;
extern buffer screenbuffer, **pictures;
extern int renderwidth, renderheight, screenwidth, screenheight;

/* Offsets to the picture table */
#define ASSEMBLY 0
#define COLON ASSEMBLY+1
#define Y2K COLON+1
#define HELSINKI Y2K+1
#define SHIPYARD1 HELSINKI+1
#define DA SHIPYARD1+1
#define JORMAS DA+1
#define PRESENT JORMAS+1
#define FACTORY1 PRESENT+1
#define FACTORY1OUTLINE FACTORY1+1
#define DESIGN1 FACTORY1OUTLINE+1
#define DESIGN2 DESIGN1+1
#define CROSSPLATFORM DESIGN2+1
#define DEMO CROSSPLATFORM+1
#define HATA DEMO+1
#define TRAFFIC1 HATA+1
#define TRAFFIC2 TRAFFIC1+1
#define TRAFFIC3 TRAFFIC2+1
#define TRAFFIC4 TRAFFIC3+1
#define TRAFFIC5 TRAFFIC4+1
#define TRAFFIC6 TRAFFIC5+1
#define TRAFFIC7 TRAFFIC6+1
#define TRAFFIC8 TRAFFIC7+1
#define TRAFFIC TRAFFIC8+1
#define JAM TRAFFIC+1
#define INSTANT JAM+1
#define MOBILITY INSTANT+1
#define TRAFFICBULLSHIT1 MOBILITY+1
#define TRAFFICBULLSHIT2 TRAFFICBULLSHIT1+1
#define BULLSHITWHITE TRAFFICBULLSHIT2+1
#define BULLSHITBLACK BULLSHITWHITE+1
#define TRAINBG BULLSHITBLACK+1
#define TRAIN TRAINBG+1
#define STRAIGHTELECTRIC TRAIN+1
#define LOCOMOTIVES STRAIGHTELECTRIC+1
#define TAKE LOCOMOTIVES+1
#define YOU TAKE+1
#define THERE YOU+1
#define BUT THERE+1
#define WHERE BUT+1
#define FACTORY2 WHERE+1
#define FACTORY2SMALL1 FACTORY2+1
#define FACTORY2SMALL2 FACTORY2SMALL1+1
#define FACTORY2SMALL3 FACTORY2SMALL2+1
#define ENERGY FACTORY2SMALL3+1
#define CRANE1 ENERGY+1
#define CRANE1SMALL1 CRANE1+1
#define CRANE1SMALL2 CRANE1SMALL1+1
#define CRANE1SMALL3 CRANE1SMALL2+1
#define MACHINERY CRANE1SMALL3+1
#define FACTORY3 MACHINERY+1
#define FACTORY3SMALL1 FACTORY3+1
#define FACTORY3SMALL2 FACTORY3SMALL1+1
#define FACTORY3SMALL3 FACTORY3SMALL2+1
#define ELECTRICITY FACTORY3SMALL3+1
#define TRAFFIC9 ELECTRICITY+1
#define TRAFFIC9SMALL1 TRAFFIC9+1
#define TRAFFIC9SMALL2 TRAFFIC9SMALL1+1
#define TRAFFIC9SMALL3 TRAFFIC9SMALL2+1
#define TECHNOLOGY TRAFFIC9SMALL3+1
#define LAPTOP1 TECHNOLOGY+1
#define LAPTOP2 LAPTOP1+1
#define LAPTOP3 LAPTOP2+1
#define LAPTOP4 LAPTOP3+1
#define LAPTOP5 LAPTOP4+1
#define LAPTOP6 LAPTOP5+1
#define LAPTOP7 LAPTOP6+1
#define LAPTOP8 LAPTOP7+1
#define LAPTOP9 LAPTOP8+1
#define LAPTOP10 LAPTOP9+1
#define LAPTOP11 LAPTOP10+1
#define LAPTOP12 LAPTOP11+1
#define LAPTOP13 LAPTOP12+1
#define LAPTOP14 LAPTOP13+1
#define LAPTOP15 LAPTOP14+1
#define LAPTOP16 LAPTOP15+1
#define MOTHERBOARD LAPTOP16+1
#define MOBILE MOTHERBOARD+1
#define COMPUTING MOBILE+1
#define WHENEVER COMPUTING+1
#define WHEREEVER WHENEVER+1
#define PHONE WHEREEVER+1
#define PHONEBOX PHONE+1
#define GLOBALCOVERAGE PHONEBOX+1
#define FACTORY4 GLOBALCOVERAGE+1
#define FACTORY4SMALL1 FACTORY4+1
#define FACTORY4SMALL2 FACTORY4SMALL1+1
#define FACTORY4SMALL3 FACTORY4SMALL2+1
#define CRANE2 FACTORY4SMALL3+1
#define CRANE2SMALL1 CRANE2+1
#define CRANE2SMALL2 CRANE2SMALL1+1
#define CRANE2SMALL3 CRANE2SMALL2+1
#define POWERSTATION CRANE2SMALL3+1
#define POWERSTATIONSMALL1 POWERSTATION+1
#define POWERSTATIONSMALL2 POWERSTATIONSMALL1+1
#define POWERSTATIONSMALL3 POWERSTATIONSMALL2+1
#define TRAFFIC10 POWERSTATIONSMALL3+1
#define TRAFFIC10SMALL1 TRAFFIC10+1
#define TRAFFIC10SMALL2 TRAFFIC10SMALL1+1
#define TRAFFIC10SMALL3 TRAFFIC10SMALL2+1
#define FUEL1 TRAFFIC10SMALL3+1
#define FUEL2 FUEL1+1
#define FUEL3 FUEL2+1
#define FUEL4 FUEL3+1
#define FUEL5 FUEL4+1
#define FUEL6 FUEL5+1
#define FUEL7 FUEL6+1
#define FUEL8 FUEL7+1
#define FUEL9 FUEL8+1
#define TECHNOLOGY2 FUEL9+1
#define POSSIBILITY TECHNOLOGY2+1
#define ANSWER POSSIBILITY+1
#define PROBLEMS ANSWER+1
#define BINARY PROBLEMS+1
#define EYE BINARY+1
#define WHAT EYE+1
#define ABOUT WHAT+1
#define THE ABOUT+1
#define PROBLEMS2 THE+1
#define OFTHE PROBLEMS2+1
#define MIND OFTHE+1
#define STAIRS1 MIND+1
#define STAIRS2 STAIRS1+1
#define STAIRS3 STAIRS2+1
#define STAIRS4 STAIRS3+1
#define STAIRS5 STAIRS4+1
#define STAIRS6 STAIRS5+1
#define STAIRS7 STAIRS6+1
#define STAIRS8 STAIRS7+1
#define STAIRS9 STAIRS8+1
#define STAIRS10 STAIRS9+1
#define STAIRS11 STAIRS10+1
#define STAIRS12 STAIRS11+1
#define STAIRS13 STAIRS12+1
#define STAIRS14 STAIRS13+1
#define STAIRS15 STAIRS14+1
#define FEAR STAIRS15+1
#define INSECURITY FEAR+1
#define LONELINESS INSECURITY+1
#define INSANITY LONELINESS+1
#define BASEMENT1 INSANITY+1
#define BASEMENT2 BASEMENT1+1
#define BASEMENT3 BASEMENT2+1
#define BASEMENT4 BASEMENT3+1
#define BASEMENT5 BASEMENT4+1
#define BASEMENT6 BASEMENT5+1
#define BASEMENT7 BASEMENT6+1
#define BASEMENT8 BASEMENT7+1
#define BASEMENT9 BASEMENT8+1
#define BASEMENT10 BASEMENT9+1
#define BASEMENT11 BASEMENT10+1
#define BASEMENT12 BASEMENT11+1
#define BASEMENT13 BASEMENT12+1
#define BASEMENT14 BASEMENT13+1
#define BASEMENT15 BASEMENT14+1
#define ELEVATOR1 BASEMENT15+1
#define ELEVATOR2 ELEVATOR1+1
#define ELEVATOR3 ELEVATOR2+1
#define ELEVATOR4 ELEVATOR3+1
#define ELEVATOR5 ELEVATOR4+1
#define ELEVATOR6 ELEVATOR5+1
#define ELEVATOR7 ELEVATOR6+1
#define ELEVATOR8 ELEVATOR7+1
#define ELEVATOR9 ELEVATOR8+1
#define VESURI1 ELEVATOR9+1
#define VESURI2 VESURI1+1
#define VESURI3 VESURI2+1
#define VESURI4 VESURI3+1
#define VESURI5 VESURI4+1
#define VESURI6 VESURI5+1
#define VESURI7 VESURI6+1
#define VESURI8 VESURI7+1
#define LAPINKULTA VESURI8+1
#define LAPINKULTASMALL1 LAPINKULTA+1
#define LAPINKULTASMALL2 LAPINKULTASMALL1+1
#define LAPINKULTASMALL3 LAPINKULTASMALL2+1
#define LAPINKULTASMALL4 LAPINKULTASMALL3+1
#define LAPINKULTASMALL5 LAPINKULTASMALL4+1
#define LAPINKULTASMALL6 LAPINKULTASMALL5+1
#define LAPINKULTASMALL7 LAPINKULTASMALL6+1
#define LAPINKULTASMALL8 LAPINKULTASMALL7+1
#define LAPINKULTASMALL9 LAPINKULTASMALL8+1
#define LAPINKULTASMALL10 LAPINKULTASMALL9+1
#define LAPINKULTASMALL11 LAPINKULTASMALL10+1
#define LAPINKULTASMALL12 LAPINKULTASMALL11+1
#define BEER LAPINKULTASMALL12+1
#define WATER1 BEER+1
#define WATER2 WATER1+1
#define WATER3 WATER2+1
#define WATER4 WATER3+1
#define PEACEOFMIND WATER4+1
#define ESCAPINGREALITY PEACEOFMIND+1
#define HELP1 ESCAPINGREALITY+1
#define HELP2 HELP1+1
#define HELP3 HELP2+1
#define HELP4 HELP3+1
#define CREDITS HELP4+1
#define KODE CREDITS+1
#define GFX KODE+1
#define MUSIK GFX+1
#define DESIGN MUSIK+1
#define VESURI DESIGN+1
#define THANKS VESURI+1
#define INSPIRATION THANKS+1
#define GMUNK INSPIRATION+1
#define LIEVONEN GMUNK+1
#define SUPPORT LIEVONEN+1
#define VIRNES SUPPORT+1
#define JRM VIRNES+1
#define DESIGN3 JRM+1
#define DESIGN4 DESIGN3+1
#define DESIGN5 DESIGN4+1
#define DESIGN6 DESIGN5+1
#define DESIGN7 DESIGN6+1
#define DESIGN8 DESIGN7+1
#define SYMBOL DESIGN8+1
#define MIXER1 SYMBOL+1
#define MIXER2 MIXER1+1
#define MIXER3 MIXER2+1
#define MIXER4 MIXER3+1
#define EPS MIXER4+1
#define X51 EPS+1
#define X52 X51+1
#define ENDSCREEN X52+1
#define TEMP ENDSCREEN+1

/* Part starting times */
#define PART_01_START SONGPOSTOTIME(1, 0)
#define PART_03_START SONGPOSTOTIME(3, 0)
#define PART_05_START SONGPOSTOTIME(5, 0)
#define PART_07_START SONGPOSTOTIME(6, 56)
#define PART_09_START SONGPOSTOTIME(9, 0)
#define PART_11_START SONGPOSTOTIME(11, 0)
#define PART_13_START SONGPOSTOTIME(13, 0)
#define PART_14_START SONGPOSTOTIME(14, 0)
#define PART_15_START SONGPOSTOTIME(15, 0)
#define PART_16_START SONGPOSTOTIME(16, 0)
#define PART_17_START SONGPOSTOTIME(17, 0)
#define PART_19_START SONGPOSTOTIME(19, 0)
#define PART_21_START SONGPOSTOTIME(21, 0)
#define PART_22_START SONGPOSTOTIME(22, 0)
#define PART_23_START SONGPOSTOTIME(23, 0)
#define PART_24_START SONGPOSTOTIME(24, 0)
#define PART_25_START SONGPOSTOTIME(25, 0)
#define PART_27_START SONGPOSTOTIME(27, 0)
#define PART_29_START SONGPOSTOTIME(29, 0)
#define PART_31_START SONGPOSTOTIME(31, 0)
#define PART_33_START SONGPOSTOTIME(33, 0)
#define PART_35_START SONGPOSTOTIME(35, 0)
#define PART_37_START SONGPOSTOTIME(37, 0)
#define PART_41_START SONGPOSTOTIME(41, 0)
#define PART_45_START SONGPOSTOTIME(45, 0)
#define PART_END SONGPOSTOTIME(47, 6)

/* Part function definitions */
extern void part_01();
extern void part_03();
extern void part_05();
extern void part_07();
extern void part_09();
extern void part_11();
extern void part_13();
extern void part_14();
extern void part_15();
extern void part_16();
extern void part_17();
extern void part_19();
extern void part_21();
extern void part_22();
extern void part_23();
extern void part_24();
extern void part_25();
extern void part_27();
extern void part_29();
extern void part_31();
extern void part_33();
extern void part_35();
extern void part_37();
extern void part_41();
extern void part_45();
