/* assembly2002demo01.c
 *
 * Copyright 2001-2002 Vesa Halttunen (Vesuri/dA JoRMaS)
 *
 * This file is part of JRm-core.
 *
 * JRm-core is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * JRm-core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JRm-core; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* Design */
#include "assembly2002demo.h"

static int rand_01=0;

static void params_01_copy_assembly(void *d, long time) {
  copy_data *data=(copy_data *)d;

  if(time<0)
    time=0;

  if(time/16>255)
    data->alpha=192;
  else
    data->alpha=time/24;

  if(time>SONGPOSTOTIME(2, 54)) {
    rand_01=rand()%100;
    data->desty=rand_01+130;
  }

  if(time<SONGPOSTOTIME(1, 48))
    data->destx=158-150*sqrt(sin((double)time*M_PI/2/SONGPOSTOTIME(1, 48)));
  else
    data->destx=8;
}

static void params_01_copy_colon(void *d, long time) {
  copy_data *data=(copy_data *)d;
  if(time<0)
    time=0;

  if(time/16>255)
    data->alpha=96;
  else
    data->alpha=time/48;

  if(time>SONGPOSTOTIME(2, 54))
    data->desty=rand_01+130;
}

static void params_01_copy_y2k(void *d, long time) {
  copy_data *data=(copy_data *)d;

  if(time<500)
    time=500;

  if((time-500)/16>255)
    data->alpha=128;
  else
    data->alpha=(time-500)/16/2;

  if(time>SONGPOSTOTIME(2, 54))
    data->desty=rand_01+130;

  if(time<SONGPOSTOTIME(2, 0))
    data->destx=8+132*sqrt(sin((double)time*M_PI/2/SONGPOSTOTIME(2, 0)));
  else
    data->destx=140;
}

static void params_01_copy_helsinki(void *d, long time) {
  copy_data *data=(copy_data *)d;

  if(time<1000)
    time=1000;

  if((time-1000)/16>255)
    data->alpha=170;
  else
    data->alpha=(time-1000)/8/3;

  if(time>SONGPOSTOTIME(2, 54))
    data->desty=rand_01+150;

  if(time<SONGPOSTOTIME(2, 32))
    data->destx=92+250*sqrt(sin((double)time*M_PI/2/SONGPOSTOTIME(2, 32)));
  else
    data->destx=342;
}

static void params_01_verticalblur(void *d, long time) {
  verticalblur_data *data=(verticalblur_data *)d;

  if(time<=SONGPOSTOTIME(2, 54))
    data->amount=1;
  else
    data->amount=rand()%((time-SONGPOSTOTIME(2, 54))/8+1)+1;
}

static void params_01_add_top(void *d, long time) {
  add_data *data=(add_data *)d;
  time-=PART_01_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(1, 56))
    data->y=45+60*sqrt(sin((double)time*M_PI/2/SONGPOSTOTIME(1, 56)));
  else
    data->y=105;
}

static void params_01_add_bottom(void *d, long time) {
  add_data *data=(add_data *)d;
  time-=PART_01_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(1, 56))
    data->y=240-60*sqrt(sin((double)time*M_PI/2/SONGPOSTOTIME(1, 56)));
  else
    data->y=180;
}

static void params_01_add_middle(void *d, long time) {
  add_data *data=(add_data *)d;
  time-=PART_01_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(1, 56)) {
    data->y=46+60*sqrt(sin((double)time*M_PI/2/SONGPOSTOTIME(1, 56)));
    data->height=240-60*sqrt(sin((double)time*M_PI/2/SONGPOSTOTIME(1, 56)))-data->y;
  } else {
    data->y=106;
    data->height=180-data->y;
  }
}

void part_01() {
  copy_data *copydata;
  verticalblur_data *vbdata;
  add_data *adddata;

  if(effectlist)
    effectlist_free(effectlist);

  effectlist=NULL;

  /* 9. Blur it */
  effectlist=effectlistentry_new(effect_new(verticalblur_new,
					    params_01_verticalblur),
				 effectlist);
  vbdata=(verticalblur_data *)effectlist->effect->data;
  vbdata->source=pictures[TEMP];
  vbdata->dest=&screenbuffer;
  vbdata->amount=1;

  /* 8. Add middle */
  effectlist=effectlistentry_new(effect_new(add_new, params_01_add_middle),
				 effectlist);
  adddata=(add_data *)effectlist->effect->data;
  adddata->dest=pictures[TEMP];
  adddata->color=0xff494335;
  adddata->x=0;
  adddata->y=101;
  adddata->width=pictures[TEMP]->width;
  adddata->height=84;

  /* 7. Add bottom line */
  effectlist=effectlistentry_new(effect_new(add_new, params_01_add_bottom),
				 effectlist);
  adddata=(add_data *)effectlist->effect->data;
  adddata->dest=pictures[TEMP];
  adddata->color=0xfffcf8ec;
  adddata->x=0;
  adddata->y=185;
  adddata->width=pictures[TEMP]->width;
  adddata->height=1;

  /* 6. Add top line */
  effectlist=effectlistentry_new(effect_new(add_new, params_01_add_top),
				 effectlist);
  adddata=(add_data *)effectlist->effect->data;
  adddata->dest=pictures[TEMP];
  adddata->color=0xfffcf8ec;
  adddata->x=0;
  adddata->y=100;
  adddata->width=pictures[TEMP]->width;
  adddata->height=1;

  /* 5. Copy helsinki */
  effectlist=effectlistentry_new(effect_new(copy_new, params_01_copy_helsinki),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[HELSINKI];
  copydata->dest=pictures[TEMP];
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=320;
  copydata->desty=188;
  copydata->sourcewidth=pictures[HELSINKI]->width;
  copydata->sourceheight=pictures[HELSINKI]->height;
  copydata->destwidth=pictures[HELSINKI]->width;
  copydata->destheight=pictures[HELSINKI]->height;
  copydata->alpha=0;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 4. Copy y2k */
  effectlist=effectlistentry_new(effect_new(copy_new, params_01_copy_y2k),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[Y2K];
  copydata->dest=pictures[TEMP];
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=165;
  copydata->desty=151;
  copydata->sourcewidth=pictures[Y2K]->width;
  copydata->sourceheight=pictures[Y2K]->height;
  copydata->destwidth=pictures[Y2K]->width;
  copydata->destheight=pictures[Y2K]->height;
  copydata->alpha=0;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 3. Copy Colon */
  effectlist=effectlistentry_new(effect_new(copy_new, params_01_copy_colon),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[COLON];
  copydata->dest=pictures[TEMP];
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=135;
  copydata->desty=161;
  copydata->sourcewidth=pictures[COLON]->width;
  copydata->sourceheight=pictures[COLON]->height;
  copydata->destwidth=pictures[COLON]->width;
  copydata->destheight=pictures[COLON]->height;
  copydata->alpha=0;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 2. Copy Assembly */
  effectlist=effectlistentry_new(effect_new(copy_new, params_01_copy_assembly),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[ASSEMBLY];
  copydata->dest=pictures[TEMP];
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=10;
  copydata->desty=150;
  copydata->sourcewidth=pictures[ASSEMBLY]->width;
  copydata->sourceheight=pictures[ASSEMBLY]->height;
  copydata->destwidth=pictures[ASSEMBLY]->width;
  copydata->destheight=pictures[ASSEMBLY]->height;
  copydata->alpha=0;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 1. Clear */
  effectlist=effectlistentry_new(effect_new(copy_new, NULL),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[TEMP];
  copydata->dest=pictures[TEMP];
  copydata->destx=0;
  copydata->desty=0;
  copydata->sourcewidth=pictures[TEMP]->width;
  copydata->sourceheight=pictures[TEMP]->height;
  copydata->destwidth=pictures[TEMP]->width;
  copydata->destheight=pictures[TEMP]->height;
  copydata->alpha=0;
  copydata->mode=COPY_MODE_OVERWRITE;
  copydata->interpolate=0;
}
