/* assembly2002demo07.c
 *
 * Copyright 2001-2002 Vesa Halttunen (Vesuri/dA JoRMaS)
 *
 * This file is part of JRm-core.
 *
 * JRm-core is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * JRm-core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JRm-core; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* FACTORY 1 OUTLINE */
#include "assembly2002demo.h"

static void params_07_copy_factory(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_07_START;
  if(time<0)
    time=0;

  if(time<500) {
    if(time%100<50)
      data->alpha=255;
    else
      data->alpha=0;
  } else
    data->alpha=255;
}

static void params_07_scale_factory(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_07_START;
  if(time<0)
    time=0;

  if(time>500) {
    if(time<950) {
      data->sourcewidth=(double)data->source->width*((double)(1000-time)/500);
      data->sourceheight=(double)data->source->height*((double)(1000-time)/500);
      data->sourcex=(data->source->width-data->sourcewidth)/2;
      data->sourcey=(data->source->height-data->sourceheight)/2;
    } else
      data->alpha=0;
  }
}

static void params_07_copy_hata(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_07_START;
  if(time<0)
    time=0;

  if(time>500) {
    if(time<1000) {
      data->destwidth=(double)data->source->width*((double)(time-500)/500);
      data->destheight=(double)data->source->height*((double)(time-500)/500);
      data->destx=data->dest->width/2-(double)data->source->width/2*((double)(time-500)/500);
      data->desty=(data->dest->height-data->destheight)/2;
    } else {
      data->destwidth=data->sourcewidth;
      data->destheight=data->sourceheight;
      data->destx=data->dest->width/2-data->source->width/2;
      data->desty=(data->dest->height-data->destheight)/2;
      if(time<1250)
	data->alpha=(1250-time);
      else if(time<1500)
	data->alpha=(time-1250);
      else if(time<SONGPOSTOTIME(1, 43))
	data->alpha=255;
      else if(time<SONGPOSTOTIME(2, 12)) {
	if(time%100<50)
	  data->alpha=255;
	else
	  data->alpha=0;
      } else if(time<SONGPOSTOTIME(2, 48))
	data->alpha=255;
      else
	data->alpha=(SONGPOSTOTIME(3, 16)-time)/8;
    }
  }
}

static void params_07_clear(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_07_START;
  if(time<0)
    time=0;

  if(time>500) {
    if(time>1000)
      time=1000;
    data->mode=COPY_MODE_OVERWRITE;
    data->sourcewidth=(double)200*((double)(time-500)/500);
    data->sourceheight=(double)40*((double)(time-500)/500);
    data->destwidth=data->sourcewidth;
    data->destheight=data->sourceheight;
    data->destx=(data->dest->width-data->destwidth)/2;
    data->desty=(data->dest->height-data->destheight)/2;
  }
}

void part_07() {
  copy_data *copydata;

  if(effectlist)
    effectlist_free(effectlist);
  effectlist=NULL;

  /* 4. Copy hata */
  effectlist=effectlistentry_new(effect_new(copy_new, params_07_copy_hata),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[HATA];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=189;
  copydata->desty=144;
  copydata->sourcewidth=pictures[HATA]->width;
  copydata->sourceheight=pictures[HATA]->height;
  copydata->destwidth=1;
  copydata->destheight=1;
  copydata->alpha=255;
  copydata->mode=COPY_MODE_OVERWRITE;
  copydata->interpolate=1;

  /* 3. Clear the area */
  effectlist=effectlistentry_new(effect_new(copy_new, params_07_clear),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=&screenbuffer;
  copydata->dest=&screenbuffer;
  copydata->destx=200;
  copydata->desty=150;
  copydata->sourcewidth=1;
  copydata->sourceheight=1;
  copydata->destwidth=1;
  copydata->destheight=1;
  copydata->alpha=0;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=1;

  /* 2. Scale */
  effectlist=effectlistentry_new(effect_new(copy_new, params_07_scale_factory),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[TEMP];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=0;
  copydata->desty=0;
  copydata->sourcewidth=pictures[TEMP]->width;
  copydata->sourceheight=pictures[TEMP]->height;
  copydata->destwidth=screenbuffer.width;
  copydata->destheight=screenbuffer.height;
  copydata->alpha=255;
  copydata->mode=COPY_MODE_OVERWRITE;
  copydata->interpolate=1;

  /* 1. Copy factory */
  effectlist=effectlistentry_new(effect_new(copy_new, params_07_copy_factory),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[FACTORY1OUTLINE];
  copydata->dest=pictures[TEMP];
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=0;
  copydata->desty=0;
  copydata->sourcewidth=pictures[TEMP]->width;
  copydata->sourceheight=pictures[TEMP]->height;
  copydata->destwidth=pictures[TEMP]->width;
  copydata->destheight=pictures[TEMP]->height;
  copydata->alpha=0;
  copydata->mode=COPY_MODE_OVERWRITE;
  copydata->interpolate=0;
}
